/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.network.message;

import com.bluepowermod.ClientProxy;
import com.bluepowermod.part.tube.TubeStack;
import com.bluepowermod.tile.TileMachineBase;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import uk.co.qmunity.lib.client.gui.GuiContainerBase;
import uk.co.qmunity.lib.network.LocatedPacket;

public class MessageSyncMachineBacklog
extends LocatedPacket<MessageSyncMachineBacklog> {
    private List<TubeStack> stacks = new ArrayList<TubeStack>();

    public MessageSyncMachineBacklog() {
    }

    public MessageSyncMachineBacklog(TileMachineBase tile, List<TubeStack> stacks) {
        super(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
        this.stacks = stacks;
    }

    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.stacks.size());
        for (TubeStack stack : this.stacks) {
            NBTTagCompound tag = new NBTTagCompound();
            stack.writeToNBT(tag);
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
        }
    }

    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        int amount = buf.readInt();
        for (int i = 0; i < amount; ++i) {
            this.stacks.add(TubeStack.loadFromNBT(ByteBufUtils.readTag((ByteBuf)buf)));
        }
    }

    public void handleClientSide(EntityPlayer player) {
        TileEntity te = player.field_70170_p.func_147438_o(this.x, this.y, this.z);
        if (te instanceof TileMachineBase) {
            ((TileMachineBase)te).setBacklog(this.stacks);
            GuiContainerBase gui = (GuiContainerBase)ClientProxy.getOpenedGui();
            if (gui != null) {
                gui.redraw();
            }
        }
    }

    public void handleServerSide(EntityPlayer player) {
    }
}

