/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part;

import com.bluepowermod.api.item.IDatabaseSaveable;
import com.bluepowermod.part.PartInfo;
import com.bluepowermod.part.PartManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import uk.co.qmunity.lib.client.render.RenderHelper;
import uk.co.qmunity.lib.part.IPart;
import uk.co.qmunity.lib.part.IPartCollidable;
import uk.co.qmunity.lib.part.IPartInteractable;
import uk.co.qmunity.lib.part.IPartOccluding;
import uk.co.qmunity.lib.part.IPartSelectable;
import uk.co.qmunity.lib.part.IPartUpdateListener;
import uk.co.qmunity.lib.part.IPartWAILAProvider;
import uk.co.qmunity.lib.part.PartBase;
import uk.co.qmunity.lib.raytrace.QMovingObjectPosition;
import uk.co.qmunity.lib.raytrace.RayTracer;
import uk.co.qmunity.lib.vec.Vec3d;
import uk.co.qmunity.lib.vec.Vec3dCube;
import uk.co.qmunity.lib.vec.Vec3i;

public abstract class BPPart
extends PartBase
implements IPartSelectable,
IPartCollidable,
IPartOccluding,
IPartUpdateListener,
IPartInteractable,
IDatabaseSaveable,
IPartWAILAProvider {
    private PartInfo partInfo;

    public World getWorld() {
        if (this.getParent() == null) {
            return null;
        }
        return super.getWorld();
    }

    public int getX() {
        if (this.getParent() == null) {
            return 0;
        }
        return super.getX();
    }

    public int getY() {
        if (this.getParent() == null) {
            return 0;
        }
        return super.getY();
    }

    public int getZ() {
        if (this.getParent() == null) {
            return 0;
        }
        return super.getZ();
    }

    public abstract String getUnlocalizedName();

    public ItemStack getItem() {
        if (this.partInfo == null) {
            this.partInfo = PartManager.getPartInfo(this.getType());
        }
        return this.partInfo.getStack();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean renderBreaking(Vec3i translation, RenderHelper renderer, RenderBlocks renderBlocks, int pass, QMovingObjectPosition mop) {
        return this.renderStatic(translation, renderer, renderBlocks, pass);
    }

    public List<Vec3dCube> getOcclusionBoxes() {
        return new ArrayList<Vec3dCube>();
    }

    public void addCollisionBoxesToList(List<Vec3dCube> boxes, Entity entity) {
    }

    public QMovingObjectPosition rayTrace(Vec3d start, Vec3d end) {
        return RayTracer.instance().rayTraceCubes((IPartSelectable)this, start, end);
    }

    public List<Vec3dCube> getSelectionBoxes() {
        return new ArrayList<Vec3dCube>();
    }

    public ItemStack getPickedItem(QMovingObjectPosition mop) {
        return this.getItem();
    }

    @SideOnly(value=Side.CLIENT)
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
    }

    public void onPartChanged(IPart part) {
        if (this.getWorld() != null && !this.getWorld().field_72995_K) {
            this.onUpdate();
        }
    }

    public void onNeighborBlockChange() {
        if (this.getWorld() != null && !this.getWorld().field_72995_K) {
            this.onUpdate();
        }
    }

    public void onNeighborTileChange() {
    }

    public void onAdded() {
        if (this.getWorld() != null && !this.getWorld().field_72995_K) {
            this.onUpdate();
        }
    }

    public void onRemoved() {
    }

    public void onLoaded() {
        if (this.getWorld() != null && !this.getWorld().field_72995_K) {
            this.onUpdate();
        }
    }

    public void onUnloaded() {
    }

    public void onConverted() {
        if (!this.getWorld().field_72995_K) {
            this.onUpdate();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addWAILABody(List<String> text) {
    }

    @Override
    public boolean canCopy(ItemStack templateStack, ItemStack outputStack) {
        return false;
    }

    @Override
    public boolean canGoInCopySlot(ItemStack stack) {
        return false;
    }

    @Override
    public List<ItemStack> getItemsOnStack(ItemStack stack) {
        return new ArrayList<ItemStack>();
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister reg) {
    }

    public boolean onActivated(EntityPlayer player, QMovingObjectPosition hit, ItemStack item) {
        return false;
    }

    public void onClicked(EntityPlayer player, QMovingObjectPosition hit, ItemStack item) {
    }

    public void onUpdate() {
    }

    public void notifyUpdate() {
        this.getWorld().func_147444_c(this.getX(), this.getY(), this.getZ(), Blocks.field_150350_a);
    }

    public CreativeTabs[] getCreativeTabs() {
        return new CreativeTabs[]{this.getCreativeTab()};
    }

    public CreativeTabs getCreativeTab() {
        return null;
    }

    public Block.SoundType getPlacementSound() {
        return Block.field_149778_k;
    }

    @SideOnly(value=Side.CLIENT)
    public void addTooltip(ItemStack item, List<String> tip) {
    }

    public List<ItemStack> getSubItems() {
        return Arrays.asList(this.getItem());
    }
}

