/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part;

import com.bluepowermod.client.render.RenderPartItem;
import com.bluepowermod.item.ItemPart;
import com.bluepowermod.part.BPPart;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Constructor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;

public class PartInfo {
    private final String type;
    private final BPPart example;
    private final Item item;
    private final ItemStack stack;
    private Constructor<? extends BPPart> constructor;
    private Object[] arguments;

    public PartInfo(Class<? extends BPPart> clazz, Object ... arguments) {
        this.arguments = arguments;
        this.generateConstructor(clazz, arguments);
        this.example = this.create();
        this.type = this.example.getType();
        this.item = new ItemPart(this);
        this.stack = new ItemStack(this.item);
    }

    private void generateConstructor(Class<? extends BPPart> clazz, Object ... arguments) {
        try {
            Class[] argsClasses = new Class[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                argsClasses[i] = arguments[i].getClass();
            }
            this.constructor = clazz.getConstructor(argsClasses);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public BPPart create() {
        try {
            return this.constructor.newInstance(this.arguments);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public String getType() {
        return this.type;
    }

    public BPPart getExample() {
        return this.example;
    }

    public ItemStack getStack() {
        return this.stack.func_77946_l();
    }

    public ItemStack getStack(int stackSize) {
        ItemStack ret = this.stack.func_77946_l();
        ret.field_77994_a = stackSize;
        return ret;
    }

    public Item getItem() {
        return this.item;
    }

    public void registerItem() {
        GameRegistry.registerItem((Item)this.item, (String)("part." + this.type));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerRenderer() {
        MinecraftForgeClient.registerItemRenderer((Item)this.item, (IItemRenderer)RenderPartItem.instance);
    }
}

