/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.gate.digital;

import com.bluepowermod.api.wire.redstone.RedwireType;
import com.bluepowermod.part.gate.component.GateComponentBorder;
import com.bluepowermod.part.gate.component.GateComponentTorch;
import com.bluepowermod.part.gate.component.GateComponentWire;
import com.bluepowermod.part.gate.connection.GateConnectionBase;
import com.bluepowermod.part.gate.connection.GateConnectionDigital;
import com.bluepowermod.part.gate.digital.GateSimpleDigital;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import uk.co.qmunity.lib.texture.Layout;

public class GateRSLatch
extends GateSimpleDigital {
    private int mode = 0;
    private GateComponentTorch t1;
    private GateComponentTorch t2;
    private GateComponentWire w1;
    private GateComponentWire w2;

    @Override
    protected void initializeConnections() {
        ((GateConnectionDigital)this.front()).reset().enable().setOutput(true);
        ((GateConnectionDigital)this.left()).reset().enable();
        ((GateConnectionDigital)this.back()).reset().enable();
        ((GateConnectionDigital)this.right()).reset().enable();
        if (this.mode == 0) {
            ((GateConnectionDigital)this.right()).setOutput(true);
        } else if (this.mode == 1) {
            ((GateConnectionDigital)this.left()).setOutput(true);
        }
    }

    @Override
    protected void initComponents() {
        this.t1 = new GateComponentTorch(this, 255, 0.25, true);
        this.addComponent(this.t1);
        this.t2 = new GateComponentTorch(this, 4101340, 0.25, true).setState(true);
        this.addComponent(this.t2);
        this.w1 = new GateComponentWire(this, 0xFF0000, RedwireType.BLUESTONE).setPower((byte)(this.mode == 3 || this.mode == 1 ? 255 : 0));
        this.addComponent(this.w1);
        this.w2 = new GateComponentWire(this, 0xFFF600, RedwireType.BLUESTONE).setPower((byte)(this.mode == 2 || this.mode == 0 ? 255 : 0));
        this.addComponent(this.w2);
        this.addComponent(new GateComponentWire(this, 12976383, RedwireType.BLUESTONE).bind((GateConnectionBase)this.right()));
        this.addComponent(new GateComponentWire(this, 65280, RedwireType.BLUESTONE).bind((GateConnectionBase)this.left()));
        this.addComponent(new GateComponentBorder(this, 0x7D7D7D));
    }

    @Override
    protected String getGateType() {
        return "rs";
    }

    @Override
    public void doLogic() {
    }

    @Override
    public void tick() {
        if (this.getWorld().field_72995_K) {
            return;
        }
        GateConnectionDigital c1 = this.mode == 0 || this.mode == 3 ? (GateConnectionDigital)this.left() : (GateConnectionDigital)this.right();
        GateConnectionDigital c2 = this.mode == 0 || this.mode == 3 ? (GateConnectionDigital)this.right() : (GateConnectionDigital)this.left();
        boolean s1 = c2.getInput() || this.t2.getState();
        boolean s2 = c1.getInput() || this.t1.getState();
        this.t1.setState(!s1);
        this.t2.setState(!s2);
        (this.mode == 0 || this.mode == 2 ? this.w1 : this.w2).setPower((byte)(s2 ? 255 : 0));
        (this.mode == 0 || this.mode == 2 ? this.w2 : this.w1).setPower((byte)(s1 ? 255 : 0));
        ((GateConnectionDigital)this.front()).setOutput(this.t2.getState());
        ((GateConnectionDigital)this.back()).setOutput(this.t1.getState());
        if (this.mode == 0 || this.mode == 1) {
            c1.setOutput(this.t1.getState());
            c2.setOutput(this.t2.getState());
        } else {
            c1.setOutput(false);
            c2.setOutput(false);
        }
        c1.refresh();
        c2.refresh();
    }

    @Override
    public Layout getLayout() {
        Layout layout = super.getLayout();
        if (layout == null) {
            return null;
        }
        return layout.getSubLayout(this.mode);
    }

    @Override
    public boolean changeMode() {
        if (!this.getWorld().field_72995_K) {
            ++this.mode;
            if (this.mode >= 4) {
                this.mode = 0;
            }
            this.getComponents().clear();
            this.initConnections();
            this.initComponents();
            this.doLogic();
            this.sendUpdatePacket();
        }
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("mode", this.mode);
        super.writeToNBT(tag);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        int lastMode = this.mode;
        this.mode = tag.func_74762_e("mode");
        if (lastMode != this.mode) {
            this.getComponents().clear();
            this.initComponents();
        }
        super.readFromNBT(tag);
    }

    public void writeUpdateData(DataOutput buffer, int channel) throws IOException {
        buffer.writeInt(this.mode);
        super.writeUpdateData(buffer, channel);
    }

    public void readUpdateData(DataInput buffer, int channel) throws IOException {
        int lastMode = 0;
        this.mode = buffer.readInt();
        if (lastMode != this.mode) {
            this.getComponents().clear();
            this.initComponents();
        }
        super.readUpdateData(buffer, channel);
    }
}

