/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.gate.digital;

import com.bluepowermod.api.wire.redstone.RedwireType;
import com.bluepowermod.part.gate.component.GateComponentBorder;
import com.bluepowermod.part.gate.component.GateComponentTaintedSiliconChip;
import com.bluepowermod.part.gate.component.GateComponentWire;
import com.bluepowermod.part.gate.connection.GateConnectionBase;
import com.bluepowermod.part.gate.connection.GateConnectionDigital;
import com.bluepowermod.part.gate.digital.GateSimpleDigital;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;

public class GateRandomizer
extends GateSimpleDigital {
    private static final Random random = new Random();
    private int ticks = 0;
    private final boolean[] out = new boolean[3];
    private GateComponentTaintedSiliconChip c1;
    private GateComponentTaintedSiliconChip c2;
    private GateComponentTaintedSiliconChip c3;

    @Override
    public void initializeConnections() {
        ((GateConnectionDigital)this.front()).enable().setOutputOnly();
        ((GateConnectionDigital)this.left()).enable().setOutputOnly();
        ((GateConnectionDigital)this.right()).enable().setOutputOnly();
        ((GateConnectionDigital)this.back()).enable();
    }

    @Override
    public void initComponents() {
        this.addComponent(new GateComponentWire(this, 1638144, RedwireType.BLUESTONE).bind((GateConnectionBase)this.front()));
        this.addComponent(new GateComponentWire(this, 0xFFF600, RedwireType.BLUESTONE).bind((GateConnectionBase)this.right()));
        this.addComponent(new GateComponentWire(this, 12976383, RedwireType.BLUESTONE).bind((GateConnectionBase)this.back()));
        this.addComponent(new GateComponentWire(this, 0xFF0000, RedwireType.BLUESTONE).bind((GateConnectionBase)this.left()));
        this.c2 = new GateComponentTaintedSiliconChip(this, 14068503);
        this.addComponent(this.c2);
        this.c1 = new GateComponentTaintedSiliconChip(this, 255);
        this.addComponent(this.c1);
        this.c3 = new GateComponentTaintedSiliconChip(this, 52479);
        this.addComponent(this.c3);
        this.addComponent(new GateComponentBorder(this, 0x7D7D7D));
    }

    @Override
    public String getGateType() {
        return "randomizer";
    }

    @Override
    public void tick() {
        if (this.getWorld().field_72995_K) {
            return;
        }
        if (((GateConnectionDigital)this.back()).getInput()) {
            if (this.ticks % 5 == 0) {
                this.out[0] = random.nextBoolean();
                this.out[1] = random.nextBoolean();
                this.out[2] = random.nextBoolean();
                ((GateConnectionDigital)this.left()).setOutput(this.out[0]);
                ((GateConnectionDigital)this.front()).setOutput(this.out[1]);
                ((GateConnectionDigital)this.right()).setOutput(this.out[2]);
                this.c1.setState(this.out[0]);
                this.c2.setState(this.out[1]);
                this.c3.setState(this.out[2]);
            }
            ++this.ticks;
        } else {
            this.ticks = 0;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("out_0", this.out[0]);
        tag.func_74757_a("out_1", this.out[1]);
        tag.func_74757_a("out_2", this.out[2]);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.out[0] = tag.func_74767_n("out_0");
        this.out[1] = tag.func_74767_n("out_1");
        this.out[2] = tag.func_74767_n("out_2");
    }

    @Override
    public void doLogic() {
    }
}

