/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.gate.digital;

import com.bluepowermod.api.wire.redstone.RedwireType;
import com.bluepowermod.part.gate.component.GateComponentBorder;
import com.bluepowermod.part.gate.component.GateComponentTorch;
import com.bluepowermod.part.gate.component.GateComponentWire;
import com.bluepowermod.part.gate.connection.GateConnectionDigital;
import com.bluepowermod.part.gate.digital.GateSimpleDigital;
import com.bluepowermod.util.Color;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import uk.co.qmunity.lib.raytrace.QMovingObjectPosition;

public class GateRepeater
extends GateSimpleDigital {
    private boolean power = false;
    private boolean currentUpdate = false;
    private int ticksRemaining = 0;
    private int location = 0;
    private int[] ticks = new int[]{1, 2, 3, 4, 8, 16, 32, 64, 128, 256, 1024};
    private GateComponentTorch t1;
    private GateComponentTorch t2;
    private GateComponentWire w1;
    private GateComponentWire w2;

    @Override
    public void initializeConnections() {
        ((GateConnectionDigital)this.front()).enable().setOutputOnly();
        ((GateConnectionDigital)this.back()).enable();
    }

    @Override
    public void initComponents() {
        this.t1 = new GateComponentTorch(this, 255, 0.3125, true);
        this.addComponent(this.t1);
        this.t2 = new GateComponentTorch(this, 0.6875, 0.75, 0.25, true).setState(true);
        this.addComponent(this.t2);
        this.w1 = new GateComponentWire(this, 12976383, RedwireType.BLUESTONE).setPower((byte)-1);
        this.addComponent(this.w1);
        this.w2 = new GateComponentWire(this, 0xFF0000, RedwireType.BLUESTONE);
        this.addComponent(this.w2);
        this.addComponent(new GateComponentBorder(this, 0x7D7D7D));
    }

    @Override
    public String getGateType() {
        return "repeater";
    }

    @Override
    public void doLogic() {
    }

    @Override
    public void tick() {
        if (this.getWorld().field_72995_K) {
            return;
        }
        boolean in = ((GateConnectionDigital)this.back()).getInput();
        if (in != this.currentUpdate && (in || !in && this.ticksRemaining == 0)) {
            this.ticksRemaining = this.ticks[this.location];
            this.currentUpdate = in;
        }
        if (this.ticksRemaining > 0) {
            --this.ticksRemaining;
        }
        if (this.ticksRemaining == 0) {
            this.power = this.currentUpdate;
        }
        ((GateConnectionDigital)this.front()).setOutput(this.power);
        this.t1.setState(this.power);
        this.w1.setPower(this.power ? (byte)0 : -1);
        this.w2.setPower(((GateConnectionDigital)this.back()).getInput() || this.ticksRemaining > 0 && this.currentUpdate ? (byte)-1 : 0);
        this.t2.setState(!((GateConnectionDigital)this.back()).getInput() && (this.ticksRemaining <= 0 || !this.currentUpdate));
    }

    @Override
    public boolean changeMode() {
        this.location = (this.location + 1) % this.ticks.length;
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addWAILABody(List<String> info) {
        info.add(I18n.func_135052_a((String)"waila.bluepower:repeater.delay", (Object[])new Object[0]) + ": " + (Object)((Object)Color.WHITE) + this.ticks[this.location] + " " + I18n.func_135052_a((String)"waila.bluepower:repeater.ticks", (Object[])new Object[0]));
    }

    @Override
    public boolean onActivated(EntityPlayer player, QMovingObjectPosition hit, ItemStack item) {
        if (super.onActivated(player, hit, item)) {
            return true;
        }
        this.location = (this.location + 1) % this.ticks.length;
        this.sendUpdatePacket();
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74757_a("power", this.power);
        tag.func_74757_a("currentUpdate", this.currentUpdate);
        tag.func_74768_a("ticksRemaining", this.ticksRemaining);
        tag.func_74768_a("location", this.location);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.power = tag.func_74767_n("power");
        this.currentUpdate = tag.func_74767_n("currentUpdate");
        this.ticksRemaining = tag.func_74762_e("ticksRemaining");
        this.location = tag.func_74762_e("location");
    }

    @Override
    public void writeUpdateData(DataOutput buffer) throws IOException {
        super.writeUpdateData(buffer);
        buffer.writeInt(this.location);
    }

    @Override
    public void readUpdateData(DataInput buffer) throws IOException {
        super.readUpdateData(buffer);
        this.location = buffer.readInt();
        this.t2.setZ((double)(12 - this.location) / 16.0);
    }
}

