/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.gate.digital;

import com.bluepowermod.api.wire.redstone.RedwireType;
import com.bluepowermod.part.gate.component.GateComponentBorder;
import com.bluepowermod.part.gate.component.GateComponentTorch;
import com.bluepowermod.part.gate.component.GateComponentWire;
import com.bluepowermod.part.gate.connection.GateConnectionBase;
import com.bluepowermod.part.gate.connection.GateConnectionDigital;
import com.bluepowermod.part.gate.digital.GateSimpleDigital;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import uk.co.qmunity.lib.misc.ShiftingBuffer;
import uk.co.qmunity.lib.texture.Layout;

public class GateTransparentLatch
extends GateSimpleDigital {
    private boolean mirrored = false;
    private GateComponentTorch t1;
    private GateComponentTorch t2;
    private GateComponentTorch t3;
    private GateComponentTorch t4;
    private GateComponentTorch t5;
    private GateComponentWire w1;
    private GateComponentWire w2;
    private GateComponentWire w3;
    private ShiftingBuffer<Boolean> buf = new ShiftingBuffer(10, 2, (Object)false);

    @Override
    public void initializeConnections() {
        ((GateConnectionDigital)this.front()).enable().setOutputOnly();
        ((GateConnectionDigital)this.left()).enable();
        ((GateConnectionDigital)this.back()).enable();
        ((GateConnectionDigital)this.right()).enable().setOutputOnly();
    }

    @Override
    public void initComponents() {
        this.t1 = new GateComponentTorch(this, 2186125, 0.25, true).setState(false);
        this.addComponent(this.t1);
        this.t2 = new GateComponentTorch(this, 255, 0.25, true).setState(true);
        this.addComponent(this.t2);
        this.t3 = new GateComponentTorch(this, 4101340, 0.25, true).setState(false);
        this.addComponent(this.t3);
        this.t4 = new GateComponentTorch(this, 7274677, 0.25, true).setState(false);
        this.addComponent(this.t4);
        this.t5 = new GateComponentTorch(this, 7747014, 0.25, true).setState(true);
        this.addComponent(this.t5);
        this.addComponent(new GateComponentWire(this, 0xFF0000, RedwireType.BLUESTONE).bind((GateConnectionBase)this.left()));
        this.addComponent(new GateComponentWire(this, 12976383, RedwireType.BLUESTONE).bind((GateConnectionBase)this.back()));
        this.w1 = new GateComponentWire(this, 0xFFF600, RedwireType.BLUESTONE);
        this.addComponent(this.w1);
        this.w2 = new GateComponentWire(this, 1638144, RedwireType.BLUESTONE).setPower((byte)-1);
        this.addComponent(this.w2);
        this.w3 = new GateComponentWire(this, 13807153, RedwireType.BLUESTONE).setPower((byte)-1);
        this.addComponent(this.w3);
        this.addComponent(new GateComponentBorder(this, 0x7D7D7D));
    }

    @Override
    public String getGateType() {
        return "transparent";
    }

    @Override
    public void doLogic() {
    }

    @Override
    public void tick() {
        if (this.getWorld().field_72995_K) {
            return;
        }
        GateConnectionDigital in = this.mirrored ? (GateConnectionDigital)this.right() : (GateConnectionDigital)this.left();
        GateConnectionDigital out = this.mirrored ? (GateConnectionDigital)this.left() : (GateConnectionDigital)this.right();
        this.buf.shift();
        this.t4.setState((Boolean)this.buf.get(0));
        ((GateConnectionDigital)this.front()).setOutput((Boolean)this.buf.get(0));
        out.setOutput((Boolean)this.buf.get(0));
        this.w2.setPower((byte)(this.t1.getState() || this.t5.getState() ? 255 : 0));
        this.t3.setState(this.w2.getPower() == 0);
        this.w1.setPower((byte)(this.t3.getState() ? 255 : 0));
        this.t2.setState(!((GateConnectionDigital)this.back()).getInput());
        this.w3.setPower((byte)(this.t2.getState() ? 255 : 0));
        this.t1.setState(!in.getInput() && this.w3.getPower() == 0);
        this.t5.setState(this.w1.getPower() == 0 && !((GateConnectionDigital)this.back()).getInput());
        this.buf.set(0, (Object)(this.w2.getPower() == 0 ? 1 : 0));
    }

    @Override
    public boolean changeMode() {
        if (!this.getWorld().field_72995_K) {
            this.mirrored = !this.mirrored;
            this.getComponents().clear();
            this.initConnections();
            this.initComponents();
            this.doLogic();
            this.sendUpdatePacket();
        }
        return true;
    }

    @Override
    public Layout getLayout() {
        Layout layout = super.getLayout();
        if (layout == null) {
            return null;
        }
        return layout.getSubLayout(this.mirrored ? 1 : 0);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74757_a("mirrored", this.mirrored);
        super.writeToNBT(tag);
        this.buf.writeToNBT(tag, "buffer");
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        boolean wasMirrored = this.mirrored;
        this.mirrored = tag.func_74767_n("mirrored");
        if (wasMirrored != this.mirrored) {
            this.getComponents().clear();
            this.initComponents();
        }
        super.readFromNBT(tag);
        this.buf.readFromNBT(tag, "buffer");
    }

    public void writeUpdateData(DataOutput buffer, int channel) throws IOException {
        buffer.writeBoolean(this.mirrored);
        super.writeUpdateData(buffer, channel);
    }

    public void readUpdateData(DataInput buffer, int channel) throws IOException {
        boolean wasMirrored = this.mirrored;
        this.mirrored = buffer.readBoolean();
        if (wasMirrored != this.mirrored) {
            this.getComponents().clear();
            this.initComponents();
        }
        super.readUpdateData(buffer, channel);
    }
}

