/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.gate.wireless;

import com.bluepowermod.api.connect.ConnectionType;
import com.bluepowermod.api.connect.IConnection;
import com.bluepowermod.api.gate.IGateLogic;
import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.api.wire.redstone.IBundledConductor;
import com.bluepowermod.api.wire.redstone.IBundledDevice;
import com.bluepowermod.api.wire.redstone.IRedstoneConductor;
import com.bluepowermod.api.wire.redstone.IRedstoneDevice;
import com.bluepowermod.api.wire.redstone.IRedwire;
import com.bluepowermod.api.wire.redstone.RedwireType;
import com.bluepowermod.api.wireless.IFrequency;
import com.bluepowermod.api.wireless.IWirelessDevice;
import com.bluepowermod.client.gui.gate.GuiGateWireless;
import com.bluepowermod.network.BPNetworkHandler;
import com.bluepowermod.network.message.MessageWirelessFrequencySync;
import com.bluepowermod.part.IGuiButtonSensitive;
import com.bluepowermod.part.gate.GateBase;
import com.bluepowermod.part.gate.connection.GateConnectionAnalogue;
import com.bluepowermod.part.gate.connection.GateConnectionBase;
import com.bluepowermod.part.gate.connection.GateConnectionBundledAnalogue;
import com.bluepowermod.part.gate.connection.GateConnectionBundledDigital;
import com.bluepowermod.part.gate.connection.GateConnectionDigital;
import com.bluepowermod.part.gate.wireless.Frequency;
import com.bluepowermod.part.gate.wireless.IWirelessGate;
import com.bluepowermod.part.gate.wireless.WirelessManager;
import com.bluepowermod.part.gate.wireless.WirelessMode;
import com.bluepowermod.util.DebugHelper;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.client.render.RenderHelper;
import uk.co.qmunity.lib.misc.Pair;
import uk.co.qmunity.lib.part.IPart;
import uk.co.qmunity.lib.part.IPartPlacement;
import uk.co.qmunity.lib.transform.Rotation;
import uk.co.qmunity.lib.transform.Transformation;
import uk.co.qmunity.lib.util.Dir;
import uk.co.qmunity.lib.vec.Vec3d;
import uk.co.qmunity.lib.vec.Vec3dCube;
import uk.co.qmunity.lib.vec.Vec3i;

public class GateTransceiver
extends GateBase<GateConnectionBase, GateConnectionBase, GateConnectionBase, GateConnectionBase, GateConnectionBase, GateConnectionBase>
implements IGateLogic<GateTransceiver>,
IWirelessDevice,
IWirelessGate,
IGuiButtonSensitive,
IRedstoneConductor.IAdvancedRedstoneConductor,
IBundledConductor.IAdvancedBundledConductor {
    private static final List<GateTransceiver> transceivers = new ArrayList<GateTransceiver>();
    private boolean isBundled;
    private boolean isAnalogue;
    private Frequency frequency = null;
    private WirelessMode mode = WirelessMode.BOTH;

    public GateTransceiver(Boolean isBundled, Boolean isAnalogue) {
        this.isBundled = isBundled;
        this.isAnalogue = isAnalogue;
    }

    @Override
    public void initConnections() {
        ((GateConnectionBase)this.front(this.isBundled ? (this.isAnalogue ? new GateConnectionBundledAnalogue(this, Dir.FRONT) : new GateConnectionBundledDigital(this, Dir.FRONT)) : (this.isAnalogue ? new GateConnectionAnalogue(this, Dir.FRONT) : new GateConnectionDigital(this, Dir.FRONT)))).setEnabled(true);
    }

    @Override
    public void initComponents() {
    }

    @Override
    public String getGateType() {
        return "wirelesstransceiver" + (this.isAnalogue ? ".analog" : "") + (this.isBundled ? ".bundled" : "");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean renderStatic(Vec3i translation, RenderHelper renderer, RenderBlocks renderBlocks, int pass) {
        super.renderStatic(translation, renderer, renderBlocks, pass);
        if (this.getParent() != null) {
            renderer.addTransformation((Transformation)new Rotation(0.0, 180.0, 0.0));
        }
        IIcon obsidian = Blocks.field_150343_Z.func_149691_a(0, 0);
        IIcon quartz = Blocks.field_150371_ca.func_149691_a(0, 0);
        IIcon iron = Blocks.field_150339_S.func_149691_a(0, 0);
        IIcon gold = Blocks.field_150340_R.func_149691_a(0, 0);
        renderer.renderBox(new Vec3dCube(0.4375, 0.125, 0.4375, 0.5625, 0.5, 0.5625), obsidian);
        if (this.getParent() == null || this.getWorld() == null) {
            renderer.addTransformation((Transformation)new Rotation(0.0, -((double)System.currentTimeMillis() / 100.0) % 360.0, 0.0));
        }
        renderer.addTransformation((Transformation)new Rotation(45.0, 0.0, 0.0));
        renderer.renderBox(new Vec3dCube(0.46875, 0.5625, 0.46875, 0.53125, 0.625, 0.53125), iron);
        renderer.renderBox(new Vec3dCube(0.4375, 0.625, 0.4375, 0.5625, 0.75, 0.5625), gold);
        renderer.renderBox(new Vec3dCube(0.375, 0.5, 0.3125, 0.625, 0.5625, 0.6875), quartz);
        renderer.renderBox(new Vec3dCube(0.3125, 0.5, 0.375, 0.6875, 0.5625, 0.625), quartz);
        for (int i = 0; i < 4; ++i) {
            renderer.renderBox(new Vec3dCube(0.3125, 0.5625, 0.625, 0.375, 0.625, 0.6875).rotate(0, i * 90, 0, Vec3d.center), quartz);
            renderer.renderBox(new Vec3dCube(0.25, 0.5625, 0.375, 0.3125, 0.625, 0.625).rotate(0, i * 90, 0, Vec3d.center), quartz);
            renderer.renderBox(new Vec3dCube(0.25, 0.625, 0.3125, 0.3125, 0.6875, 0.6875).rotate(0, i * 90, 0, Vec3d.center), quartz);
            renderer.renderBox(new Vec3dCube(0.25, 0.6875, 0.6875, 0.3125, 0.75, 0.75).rotate(0, i * 90, 0, Vec3d.center), quartz);
            renderer.renderBox(new Vec3dCube(0.1875, 0.6875, 0.25, 0.25, 0.75, 0.75).rotate(0, i * 90, 0, Vec3d.center), quartz);
        }
        renderer.resetTransformations();
        return true;
    }

    @Override
    public void doLogic() {
    }

    @Override
    public void tick() {
    }

    @Override
    public boolean changeMode() {
        return false;
    }

    @Override
    public IGateLogic<? extends GateBase<GateConnectionBase, GateConnectionBase, GateConnectionBase, GateConnectionBase, GateConnectionBase, GateConnectionBase>> logic() {
        return this;
    }

    @Override
    public GateTransceiver getGate() {
        return this;
    }

    @Override
    public void setFrequency(IFrequency freq) {
        this.frequency = (Frequency)freq;
    }

    @Override
    public Frequency getFrequency() {
        return this.frequency;
    }

    @Override
    public WirelessMode getMode() {
        return this.mode;
    }

    @Override
    public void setMode(WirelessMode mode) {
        this.mode = mode;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74768_a("mode", this.mode.ordinal());
        if (this.frequency != null) {
            this.frequency.writeToNBT(tag);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.mode = WirelessMode.values()[tag.func_74762_e("mode")];
        if (tag.func_74764_b("freq_name")) {
            Frequency f = new Frequency();
            f.readFromNBT(tag);
            this.frequency = (Frequency)WirelessManager.COMMON_INSTANCE.getFrequency(f.getAccessibility(), f.getFrequencyName(), f.getOwner());
        } else {
            this.frequency = null;
        }
    }

    @Override
    public void writeUpdateData(DataOutput buffer) throws IOException {
        super.writeUpdateData(buffer);
        buffer.writeInt(this.mode.ordinal());
        buffer.writeBoolean(this.frequency != null);
        if (this.frequency != null) {
            this.frequency.writeToBuffer(buffer);
        }
    }

    public void readUpdateData(DataInput buffer, int channel) throws IOException {
        super.readUpdateData(buffer, channel);
        this.mode = WirelessMode.values()[buffer.readInt()];
        if (buffer.readBoolean()) {
            if (this.frequency == null) {
                this.frequency = new Frequency();
            }
            this.frequency.readFromBuffer(buffer);
        } else {
            this.frequency = null;
        }
    }

    @Override
    protected void handleGUIServer(EntityPlayer player) {
        this.sendUpdatePacket();
        BPNetworkHandler.INSTANCE.sendTo((IMessage)new MessageWirelessFrequencySync(player), (EntityPlayerMP)player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected GuiScreen getGui(EntityPlayer player) {
        return new GuiGateWireless(this, this.isBundled, this.mode);
    }

    @Override
    protected boolean hasGUI() {
        return true;
    }

    @Override
    public boolean isBundled() {
        return this.isBundled;
    }

    @Override
    public void onButtonPress(EntityPlayer player, int messageId, int value) {
        if (messageId == 0) {
            this.mode = WirelessMode.values()[value];
        }
        if (messageId == 1) {
            this.setFrequency(null);
            BPNetworkHandler.INSTANCE.sendTo((IMessage)new MessageWirelessFrequencySync(player), (EntityPlayerMP)player);
        }
        this.sendUpdatePacket();
    }

    @Override
    public boolean hasLoss(ForgeDirection side) {
        return false;
    }

    @Override
    public boolean isAnalogue(ForgeDirection side) {
        return this.isAnalogue;
    }

    @Override
    public boolean canPropagateFrom(ForgeDirection fromSide) {
        return !this.isBundled;
    }

    @Override
    public boolean canPropagateBundledFrom(ForgeDirection fromSide) {
        return this.isBundled;
    }

    @Override
    public Collection<Map.Entry<IConnection<IRedstoneDevice>, Boolean>> propagate(ForgeDirection fromSide) {
        ArrayList<Map.Entry<IConnection<IRedstoneDevice>, Boolean>> l = new ArrayList<Map.Entry<IConnection<IRedstoneDevice>, Boolean>>();
        if (this.frequency == null) {
            return l;
        }
        l.add((Map.Entry<IConnection<IRedstoneDevice>, Boolean>)new Pair(this.getRedstoneConnectionCache().getConnectionOnSide(fromSide), (Object)false));
        for (IWirelessDevice d : WirelessManager.COMMON_INSTANCE.getDevices()) {
            IConnection<IRedstoneDevice> c;
            if (d == this || d.getFrequency() == null || !d.getFrequency().equals(this.getFrequency()) || !(d instanceof GateTransceiver) || (c = ((GateTransceiver)d).getRedstoneConnectionCache().getConnectionOnSide(((GateConnectionBase)((GateTransceiver)d).front()).getForgeDirection())) == null) continue;
            l.add((Map.Entry<IConnection<IRedstoneDevice>, Boolean>)new Pair(c, (Object)false));
        }
        return l;
    }

    @Override
    public Collection<Map.Entry<IConnection<IBundledDevice>, Boolean>> propagateBundled(ForgeDirection fromSide) {
        return Collections.emptyList();
    }

    @Override
    public boolean canConnect(ForgeDirection side, IRedstoneDevice device, ConnectionType type) {
        if (device instanceof IRedwire) {
            RedwireType rwt = ((IRedwire)((Object)device)).getRedwireType(type == ConnectionType.STRAIGHT ? side.getOpposite() : (type == ConnectionType.CLOSED_CORNER ? this.getFace() : this.getFace().getOpposite()));
            if (rwt == null) {
                return false;
            }
            if (rwt.isAnalogue() != this.isAnalogue(side)) {
                return false;
            }
        }
        return !this.isBundled && super.canConnect(side, device, type);
    }

    @Override
    public boolean canConnect(ForgeDirection side, IBundledDevice device, ConnectionType type) {
        if (device instanceof IRedwire) {
            RedwireType rwt = ((IRedwire)((Object)device)).getRedwireType(type == ConnectionType.STRAIGHT ? side.getOpposite() : (type == ConnectionType.CLOSED_CORNER ? this.getFace() : this.getFace().getOpposite()));
            if (rwt == null) {
                return false;
            }
            if (rwt.isAnalogue() != this.isAnalogue(side)) {
                return false;
            }
        }
        return this.isBundled && super.canConnect(side, device, type);
    }

    @Override
    public void onAdded() {
        super.onAdded();
        if (!transceivers.contains(this)) {
            transceivers.add(this);
        }
        WirelessManager.COMMON_INSTANCE.registerWirelessDevice(this);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!transceivers.contains(this)) {
            transceivers.add(this);
        }
        WirelessManager.COMMON_INSTANCE.registerWirelessDevice(this);
    }

    @Override
    public void onRemoved() {
        super.onRemoved();
        transceivers.remove(this);
        WirelessManager.COMMON_INSTANCE.unregisterWirelessDevice(this);
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
        transceivers.remove(this);
        WirelessManager.COMMON_INSTANCE.unregisterWirelessDevice(this);
    }

    @Override
    public IPartPlacement getPlacement(IPart part, World world, Vec3i location, ForgeDirection face, MovingObjectPosition mop, EntityPlayer player) {
        if (!DebugHelper.isDebugModeEnabled()) {
            return null;
        }
        return super.getPlacement(part, world, location, face, mop, player);
    }

    @Override
    public void addTooltip(ItemStack item, List<String> tip) {
        if (!DebugHelper.isDebugModeEnabled()) {
            tip.add((Object)((Object)MinecraftColor.RED) + I18n.func_135052_a((String)"Disabled temporarily. Still not fully working.", (Object[])new Object[0]));
        } else {
            tip.add((Object)((Object)MinecraftColor.CYAN) + I18n.func_135052_a((String)"Disabled temporarily. Still not fully working.", (Object[])new Object[0]));
        }
    }
}

