/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.part.lamp;

import com.bluepowermod.api.connect.ConnectionType;
import com.bluepowermod.api.connect.IConnection;
import com.bluepowermod.api.connect.IConnectionCache;
import com.bluepowermod.api.misc.MinecraftColor;
import com.bluepowermod.api.wire.redstone.IRedstoneDevice;
import com.bluepowermod.init.BPCreativeTabs;
import com.bluepowermod.part.BPPartFace;
import com.bluepowermod.part.tube.PneumaticTube;
import com.bluepowermod.part.wire.redstone.PartRedwireFreestanding;
import com.bluepowermod.redstone.RedstoneApi;
import com.bluepowermod.redstone.RedstoneConnectionCache;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import uk.co.qmunity.lib.client.render.RenderHelper;
import uk.co.qmunity.lib.helper.MathHelper;
import uk.co.qmunity.lib.helper.RedstoneHelper;
import uk.co.qmunity.lib.part.IPartRedstone;
import uk.co.qmunity.lib.part.ITilePartHolder;
import uk.co.qmunity.lib.part.MicroblockShape;
import uk.co.qmunity.lib.part.compat.MultipartCompatibility;
import uk.co.qmunity.lib.part.compat.OcclusionHelper;
import uk.co.qmunity.lib.transform.Rotation;
import uk.co.qmunity.lib.transform.Transformation;
import uk.co.qmunity.lib.vec.IWorldLocation;
import uk.co.qmunity.lib.vec.Vec3d;
import uk.co.qmunity.lib.vec.Vec3dCube;
import uk.co.qmunity.lib.vec.Vec3i;

public abstract class PartLamp
extends BPPartFace
implements IPartRedstone,
IRedstoneDevice {
    protected final MinecraftColor color;
    protected final boolean inverted;
    protected byte power = 0;
    private byte[] input = new byte[6];
    private RedstoneConnectionCache connections = RedstoneApi.getInstance().createRedstoneConnectionCache(this);

    public PartLamp(MinecraftColor color, Boolean inverted) {
        this.color = color;
        this.inverted = inverted;
    }

    public String getType() {
        return this.getLampType() + "." + this.color.name().toLowerCase() + (this.inverted ? ".inverted" : "");
    }

    protected abstract String getLampType();

    @Override
    public String getUnlocalizedName() {
        return this.getType();
    }

    @Override
    public void addCollisionBoxesToList(List<Vec3dCube> boxes, Entity entity) {
        boxes.addAll(this.getSelectionBoxes());
    }

    @Override
    public List<Vec3dCube> getOcclusionBoxes() {
        return this.getSelectionBoxes();
    }

    @Override
    public List<Vec3dCube> getSelectionBoxes() {
        return Arrays.asList(new Vec3dCube(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        this.power = 0;
        RenderHelper rh = RenderHelper.instance;
        rh.setRenderCoords(null, 0, 0, 0);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
        Tessellator.field_78398_a.func_78382_b();
        this.renderStatic(new Vec3i(0, 0, 0), rh, RenderBlocks.getInstance(), 0);
        Tessellator.field_78398_a.func_78381_a();
        rh.reset();
        GL11.glPushMatrix();
        this.renderGlow(1);
        GL11.glPopMatrix();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110576_c);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Vec3d translation, double delta, int pass) {
        RenderHelper renderer = RenderHelper.instance;
        renderer.reset();
        switch (this.getFace().ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                renderer.addTransformation((Transformation)new Rotation(180.0, 0.0, 0.0, Vec3d.center));
                break;
            }
            case 2: {
                renderer.addTransformation((Transformation)new Rotation(90.0, 0.0, 0.0, Vec3d.center));
                break;
            }
            case 3: {
                renderer.addTransformation((Transformation)new Rotation(-90.0, 0.0, 0.0, Vec3d.center));
                break;
            }
            case 4: {
                renderer.addTransformation((Transformation)new Rotation(0.0, 0.0, -90.0, Vec3d.center));
                break;
            }
            case 5: {
                renderer.addTransformation((Transformation)new Rotation(0.0, 0.0, 90.0, Vec3d.center));
            }
        }
        this.renderGlow(pass);
        renderer.resetTransformations();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean renderStatic(Vec3i loc, RenderHelper renderer, RenderBlocks renderBlocks, int pass) {
        switch (this.getFace().ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                renderer.addTransformation((Transformation)new Rotation(180.0, 0.0, 0.0, Vec3d.center));
                break;
            }
            case 2: {
                renderer.addTransformation((Transformation)new Rotation(90.0, 0.0, 0.0, Vec3d.center));
                break;
            }
            case 3: {
                renderer.addTransformation((Transformation)new Rotation(-90.0, 0.0, 0.0, Vec3d.center));
                break;
            }
            case 4: {
                renderer.addTransformation((Transformation)new Rotation(0.0, 0.0, -90.0, Vec3d.center));
                break;
            }
            case 5: {
                renderer.addTransformation((Transformation)new Rotation(0.0, 0.0, 90.0, Vec3d.center));
            }
        }
        this.renderLamp(renderer);
        renderer.resetTransformations();
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderOnPass(int pass) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderLamp(RenderHelper renderer) {
    }

    @SideOnly(value=Side.CLIENT)
    public void renderGlow(int pass) {
    }

    public int getLightValue() {
        int pow;
        int n = pow = this.inverted ? 15 - this.power : this.power;
        if (Loader.isModLoaded((String)"coloredlightscore")) {
            int color = this.color.getHex();
            int ri = color >> 16 & 0xFF;
            int gi = color >> 8 & 0xFF;
            int bi = color >> 0 & 0xFF;
            float r = (float)ri / 256.0f;
            float g = (float)gi / 256.0f;
            float b = (float)bi / 256.0f;
            if (r < 0.0f) {
                r = 0.0f;
            } else if (r > 1.0f) {
                r = 1.0f;
            }
            if (g < 0.0f) {
                g = 0.0f;
            } else if (g > 1.0f) {
                g = 1.0f;
            }
            if (b < 0.0f) {
                b = 0.0f;
            } else if (b > 1.0f) {
                b = 1.0f;
            }
            return pow | ((int)(15.0f * b) << 15) + ((int)(15.0f * g) << 10) + ((int)(15.0f * r) << 5);
        }
        return pow;
    }

    @Override
    public void onAdded() {
        super.onAdded();
        this.connections.recalculateConnections();
        this.onUpdate();
    }

    @Override
    public void onUpdate() {
        this.recalculatePower();
    }

    private void recalculatePower() {
        if (this.getWorld().field_72995_K) {
            return;
        }
        byte old = this.power;
        int pow = 0;
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            IConnection<IRedstoneDevice> con = this.connections.getConnectionOnSide(d);
            pow = con != null ? Math.max(pow, this.input[d.ordinal()] & 0xFF) : Math.max(pow, MathHelper.map((int)RedstoneHelper.getInput((World)this.getWorld(), (int)this.getX(), (int)this.getY(), (int)this.getZ(), (ForgeDirection)d), (int)0, (int)15, (int)0, (int)255));
        }
        this.power = (byte)pow;
        if (old != this.power) {
            this.sendUpdatePacket();
        }
    }

    public int getStrongPower(ForgeDirection side) {
        return 0;
    }

    public int getWeakPower(ForgeDirection side) {
        return 0;
    }

    public boolean canConnectRedstone(ForgeDirection side) {
        return true;
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74774_a("power", this.power);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.power = tag.func_74771_c("power");
    }

    @Override
    public void writeUpdateData(DataOutput buffer) throws IOException {
        super.writeUpdateData(buffer);
        buffer.writeByte(this.power);
    }

    @Override
    public void readUpdateData(DataInput buffer) throws IOException {
        super.readUpdateData(buffer);
        this.power = buffer.readByte();
        if (this.getParent() != null && this.getWorld() != null) {
            this.getWorld().func_147463_c(EnumSkyBlock.Block, this.getX(), this.getY(), this.getZ());
        }
    }

    @Override
    public boolean canStay() {
        Vec3i loc = new Vec3i((IWorldLocation)this).add(this.getFace());
        if (MultipartCompatibility.getPartHolder((World)this.getWorld(), (Vec3i)loc) != null) {
            if (MultipartCompatibility.getPart((World)this.getWorld(), (Vec3i)loc, PartRedwireFreestanding.class) != null) {
                return true;
            }
            PneumaticTube t = (PneumaticTube)MultipartCompatibility.getPart((World)this.getWorld(), (Vec3i)loc, PneumaticTube.class);
            if (t != null && t.getRedwireType() != null) {
                return true;
            }
        }
        return super.canStay();
    }

    @Override
    public CreativeTabs getCreativeTab() {
        return BPCreativeTabs.lighting;
    }

    @Override
    public boolean canConnect(ForgeDirection side, IRedstoneDevice dev, ConnectionType type) {
        if (side == ForgeDirection.UNKNOWN) {
            return false;
        }
        return OcclusionHelper.microblockOcclusionTest((ITilePartHolder)this.getParent(), (MicroblockShape)MicroblockShape.EDGE, (int)1, (ForgeDirection[])new ForgeDirection[]{this.getFace(), side});
    }

    @Override
    public IConnectionCache<? extends IRedstoneDevice> getRedstoneConnectionCache() {
        return this.connections;
    }

    @Override
    public byte getRedstonePower(ForgeDirection side) {
        return 0;
    }

    @Override
    public void setRedstonePower(ForgeDirection side, byte power) {
        this.input[side.ordinal()] = power;
    }

    @Override
    public void onRedstoneUpdate() {
        this.recalculatePower();
    }

    @Override
    public boolean isNormalFace(ForgeDirection side) {
        return false;
    }
}

