/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.recipe;

import com.bluepowermod.BluePower;
import com.bluepowermod.api.recipe.IAlloyFurnaceRecipe;
import com.bluepowermod.api.recipe.IAlloyFurnaceRegistry;
import com.bluepowermod.init.Config;
import com.bluepowermod.util.ItemStackUtils;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.registry.GameData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class AlloyFurnaceRegistry
implements IAlloyFurnaceRegistry {
    private static AlloyFurnaceRegistry INSTANCE = new AlloyFurnaceRegistry();
    private final List<IAlloyFurnaceRecipe> alloyFurnaceRecipes = new ArrayList<IAlloyFurnaceRecipe>();
    private final List<ItemStack> bufferedRecyclingItems = new ArrayList<ItemStack>();
    private final Map<ItemStack, ItemStack> moltenDownMap = new HashMap<ItemStack, ItemStack>();
    private final List<String> blacklist = new ArrayList<String>();

    private AlloyFurnaceRegistry() {
    }

    public static AlloyFurnaceRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public void addRecipe(IAlloyFurnaceRecipe recipe) {
        this.alloyFurnaceRecipes.add(recipe);
    }

    public List<IAlloyFurnaceRecipe> getAllRecipes() {
        return this.alloyFurnaceRecipes;
    }

    @Override
    public void addRecipe(ItemStack craftingResult, Object ... requiredItems) {
        if (craftingResult == null || craftingResult.func_77973_b() == null) {
            throw new NullPointerException("Can't register an Alloy Furnace recipe with a null output stack or item");
        }
        ItemStack[] requiredStacks = new ItemStack[requiredItems.length];
        for (int i = 0; i < requiredStacks.length; ++i) {
            if (requiredItems[i] instanceof ItemStack) {
                requiredStacks[i] = (ItemStack)requiredItems[i];
                continue;
            }
            if (requiredItems[i] instanceof Item) {
                requiredStacks[i] = new ItemStack((Item)requiredItems[i], 1, Short.MAX_VALUE);
                continue;
            }
            if (requiredItems[i] instanceof Block) {
                requiredStacks[i] = new ItemStack(Item.func_150898_a((Block)((Block)requiredItems[i])), 1, Short.MAX_VALUE);
                continue;
            }
            throw new IllegalArgumentException("Alloy Furnace crafting ingredients can only be ItemStack, Item or Block!");
        }
        this.addRecipe(new StandardAlloyFurnaceRecipe(craftingResult, requiredStacks));
    }

    @Override
    public void addRecyclingRecipe(ItemStack recycledItem, String ... blacklist) {
        if (recycledItem == null) {
            throw new NullPointerException("Recycled item can't be null!");
        }
        this.bufferedRecyclingItems.add(recycledItem);
        if (blacklist.length > 0) {
            ModContainer mc = Loader.instance().activeModContainer();
            BluePower.log.info((mc != null ? mc.getName() : "Unknown mod") + " added to the Alloy Furnace recycling blacklist: " + Arrays.toString(blacklist));
            Collections.addAll(this.blacklist, blacklist);
        }
    }

    @Override
    public void addRecyclingRecipe(ItemStack recycledItem, ItemStack moltenDownItem, String ... blacklist) {
        if (moltenDownItem == null) {
            throw new NullPointerException("Molten down item can't be null!");
        }
        this.addRecyclingRecipe(recycledItem, blacklist);
        this.moltenDownMap.put(recycledItem, moltenDownItem);
    }

    public void generateRecyclingRecipes() {
        Collections.addAll(this.blacklist, Config.alloyFurnaceBlacklist);
        ArrayList<Item> blacklist = new ArrayList<Item>();
        for (String configString : this.blacklist) {
            Item item = (Item)GameData.getItemRegistry().func_82594_a(configString);
            if (item != null) {
                blacklist.add(item);
                continue;
            }
            BluePower.log.info("Config entry \"" + configString + "\" not an existing item/block name! Will not be added to the blacklist");
        }
        ArrayList<ItemStack> registeredRecycledItems = new ArrayList<ItemStack>();
        ArrayList<ItemStack> registeredResultItems = new ArrayList<ItemStack>();
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        for (IRecipe recipe : recipes) {
            int recyclingAmount = 0;
            ItemStack currentlyRecycledInto = null;
            for (ItemStack recyclingItem : this.bufferedRecyclingItems) {
                try {
                    ShapelessRecipes shapeless;
                    if (recipe instanceof ShapedRecipes) {
                        ShapedRecipes shaped = (ShapedRecipes)recipe;
                        if (shaped.field_77574_d == null) continue;
                        for (ItemStack itemStack : shaped.field_77574_d) {
                            if (itemStack == null || !ItemStackUtils.isItemFuzzyEqual(itemStack, recyclingItem)) continue;
                            ItemStack moltenDownItem = this.getRecyclingStack(recyclingItem);
                            if (currentlyRecycledInto != null && !ItemStackUtils.isItemFuzzyEqual(currentlyRecycledInto, moltenDownItem)) continue;
                            currentlyRecycledInto = moltenDownItem;
                            recyclingAmount += moltenDownItem.field_77994_a;
                        }
                        continue;
                    }
                    if (recipe instanceof ShapelessRecipes) {
                        shapeless = (ShapelessRecipes)recipe;
                        if (shapeless.field_77579_b == null) continue;
                        for (ItemStack input : shapeless.field_77579_b) {
                            if (input == null || !ItemStackUtils.isItemFuzzyEqual(input, recyclingItem)) continue;
                            ItemStack moltenDownItem = this.getRecyclingStack(recyclingItem);
                            if (currentlyRecycledInto != null && !ItemStackUtils.isItemFuzzyEqual(currentlyRecycledInto, moltenDownItem)) continue;
                            currentlyRecycledInto = moltenDownItem;
                            recyclingAmount += moltenDownItem.field_77994_a;
                        }
                        continue;
                    }
                    if (recipe instanceof ShapedOreRecipe) {
                        ShapedOreRecipe shapedOreRecipe = (ShapedOreRecipe)recipe;
                        if (shapedOreRecipe.getInput() == null) continue;
                        block7: for (Object object : shapedOreRecipe.getInput()) {
                            ArrayList<ItemStack> itemList;
                            if (object == null) continue;
                            if (object instanceof ItemStack) {
                                itemList = new ArrayList<ItemStack>();
                                itemList.add((ItemStack)object);
                            } else {
                                itemList = (ArrayList<ItemStack>)object;
                            }
                            for (ItemStack item : itemList) {
                                if (item == null || !ItemStackUtils.isItemFuzzyEqual(item, recyclingItem)) continue;
                                ItemStack moltenDownItem = this.getRecyclingStack(recyclingItem);
                                if (currentlyRecycledInto != null && !ItemStackUtils.isItemFuzzyEqual(currentlyRecycledInto, moltenDownItem)) continue block7;
                                currentlyRecycledInto = moltenDownItem;
                                recyclingAmount += moltenDownItem.field_77994_a;
                                continue block7;
                            }
                        }
                        continue;
                    }
                    if (!(recipe instanceof ShapelessOreRecipe)) continue;
                    shapeless = (ShapelessOreRecipe)recipe;
                    block9: for (Object input : shapeless.getInput()) {
                        ArrayList<ItemStack> itemList;
                        if (input == null) continue;
                        if (input instanceof ItemStack) {
                            itemList = new ArrayList<ItemStack>();
                            itemList.add((ItemStack)input);
                        } else {
                            itemList = (ArrayList<ItemStack>)input;
                        }
                        for (ItemStack item : itemList) {
                            if (item == null || !ItemStackUtils.isItemFuzzyEqual(item, recyclingItem)) continue;
                            ItemStack moltenDownItem = this.getRecyclingStack(recyclingItem);
                            if (currentlyRecycledInto != null && !ItemStackUtils.isItemFuzzyEqual(currentlyRecycledInto, moltenDownItem)) continue block9;
                            currentlyRecycledInto = moltenDownItem;
                            recyclingAmount += moltenDownItem.field_77994_a;
                            continue block9;
                        }
                    }
                }
                catch (Throwable e) {
                    BluePower.log.error("Error when generating an Alloy Furnace recipe for item " + recyclingItem.func_82833_r() + ", recipe output: " + recipe.func_77571_b().func_82833_r());
                    e.printStackTrace();
                }
            }
            if (recyclingAmount <= 0 || recipe.func_77571_b().field_77994_a <= 0) continue;
            boolean shouldAdd = true;
            for (int i = 0; i < registeredRecycledItems.size(); ++i) {
                if (!ItemStackUtils.isItemFuzzyEqual((ItemStack)registeredRecycledItems.get(i), recipe.func_77571_b())) continue;
                if (((ItemStack)registeredResultItems.get((int)i)).field_77994_a < recyclingAmount) {
                    shouldAdd = false;
                    break;
                }
                registeredResultItems.remove(i);
                registeredRecycledItems.remove(i);
                --i;
            }
            if (!shouldAdd) continue;
            if (blacklist.contains(recipe.func_77571_b().func_77973_b())) {
                BluePower.log.info("Skipped adding item/block " + recipe.func_77571_b().func_82833_r() + " to the Alloy Furnace recipes.");
                continue;
            }
            ItemStack resultItem = new ItemStack(currentlyRecycledInto.func_77973_b(), Math.min(64, recyclingAmount), currentlyRecycledInto.func_77960_j());
            registeredResultItems.add(resultItem);
            registeredRecycledItems.add(recipe.func_77571_b());
        }
        for (int i = 0; i < registeredResultItems.size(); ++i) {
            this.addRecipe((ItemStack)registeredResultItems.get(i), registeredRecycledItems.get(i));
        }
    }

    private ItemStack getRecyclingStack(ItemStack original) {
        ItemStack moltenDownStack = this.moltenDownMap.get(original);
        return moltenDownStack != null ? moltenDownStack : original;
    }

    public IAlloyFurnaceRecipe getMatchingRecipe(ItemStack[] input, ItemStack outputSlot) {
        for (IAlloyFurnaceRecipe recipe : this.alloyFurnaceRecipes) {
            ItemStack craftingResult;
            if (!recipe.matches(input) || outputSlot != null && (!ItemStack.func_77970_a((ItemStack)outputSlot, (ItemStack)(craftingResult = recipe.getCraftingResult(input))) || !outputSlot.func_77969_a(craftingResult) || craftingResult.field_77994_a + outputSlot.field_77994_a > outputSlot.func_77976_d())) continue;
            return recipe;
        }
        return null;
    }

    public class StandardAlloyFurnaceRecipe
    implements IAlloyFurnaceRecipe {
        private final ItemStack craftingResult;
        private final ItemStack[] requiredItems;

        private StandardAlloyFurnaceRecipe(ItemStack craftingResult, ItemStack ... requiredItems) {
            if (craftingResult == null) {
                throw new IllegalArgumentException("Alloy Furnace crafting result can't be null!");
            }
            if (requiredItems.length > 9) {
                throw new IllegalArgumentException("There can't be more than 9 crafting ingredients for the Alloy Furnace!");
            }
            for (ItemStack requiredItem : requiredItems) {
                if (requiredItem != null) continue;
                throw new NullPointerException("An Alloy Furnace crafting ingredient can't be null!");
            }
            for (ItemStack stack : requiredItems) {
                for (ItemStack stack2 : requiredItems) {
                    if (stack == stack2 || !ItemStackUtils.isItemFuzzyEqual(stack, stack2)) continue;
                    throw new IllegalArgumentException("No equivalent Alloy Furnace crafting ingredient can be given twice! This does take OreDict + wildcard values in account.");
                }
            }
            this.craftingResult = craftingResult;
            this.requiredItems = requiredItems;
        }

        @Override
        public boolean matches(ItemStack[] input) {
            for (ItemStack requiredItem : this.requiredItems) {
                ItemStack inputStack;
                int itemsNeeded = requiredItem.field_77994_a;
                ItemStack[] itemStackArray = input;
                int n = itemStackArray.length;
                for (int i = 0; !(i >= n || (inputStack = itemStackArray[i]) != null && ItemStackUtils.isItemFuzzyEqual(inputStack, requiredItem) && (itemsNeeded -= inputStack.field_77994_a) <= 0); ++i) {
                }
                if (itemsNeeded <= 0) continue;
                return false;
            }
            return true;
        }

        @Override
        public void useItems(ItemStack[] input) {
            for (ItemStack requiredItem : this.requiredItems) {
                int itemsNeeded = requiredItem.field_77994_a;
                for (int i = 0; i < input.length; ++i) {
                    ItemStack inputStack = input[i];
                    if (inputStack == null || !ItemStackUtils.isItemFuzzyEqual(inputStack, requiredItem)) continue;
                    int itemsSubstracted = Math.min(inputStack.field_77994_a, itemsNeeded);
                    inputStack.field_77994_a -= itemsSubstracted;
                    if (inputStack.field_77994_a <= 0) {
                        input[i] = null;
                    }
                    if ((itemsNeeded -= itemsSubstracted) <= 0) break;
                }
                if (itemsNeeded <= 0) continue;
                throw new IllegalArgumentException("Alloy Furnace recipe using items, after using still items required?? This is a bug!");
            }
        }

        @Override
        public ItemStack getCraftingResult(ItemStack[] input) {
            return this.craftingResult;
        }

        public ItemStack[] getRequiredItems() {
            return this.requiredItems;
        }
    }
}

