/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.redstone;

import com.bluepowermod.api.connect.ConnectionType;
import com.bluepowermod.api.wire.redstone.IBundledDevice;
import com.bluepowermod.api.wire.redstone.IRedstoneDevice;
import com.bluepowermod.part.wire.ConnectionLogicHelper;
import com.bluepowermod.redstone.BundledConnection;
import com.bluepowermod.redstone.DummyRedstoneDevice;
import com.bluepowermod.redstone.RedstoneApi;
import com.bluepowermod.redstone.RedstoneConnection;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class RedConnectionHelper {
    private static ConnectionLogicHelper<IRedstoneDevice, RedstoneConnection> redstone = new ConnectionLogicHelper<IRedstoneDevice, RedstoneConnection>(new ConnectionLogicHelper.IConnectableProvider<IRedstoneDevice, RedstoneConnection>(){

        @Override
        public IRedstoneDevice getConnectableAt(World world, int x, int y, int z, ForgeDirection face, ForgeDirection side) {
            return RedstoneApi.getInstance().getRedstoneDevice(world, x, y, z, face, side);
        }

        @Override
        public RedstoneConnection createConnection(IRedstoneDevice a, IRedstoneDevice b, ForgeDirection sideA, ForgeDirection sideB, ConnectionType type) {
            return RedstoneApi.getInstance().createConnection(a, b, sideA, sideB, type);
        }

        @Override
        public boolean canConnect(IRedstoneDevice from, IRedstoneDevice to, ForgeDirection side, ConnectionType type) {
            return from.canConnect(side, to, type);
        }

        @Override
        public boolean isValidClosedCorner(IRedstoneDevice o) {
            return !(o instanceof DummyRedstoneDevice);
        }

        @Override
        public boolean isValidOpenCorner(IRedstoneDevice o) {
            return true;
        }

        @Override
        public boolean isValidStraight(IRedstoneDevice o) {
            return true;
        }

        @Override
        public boolean isNormalFace(IRedstoneDevice o, ForgeDirection face) {
            return o.isNormalFace(face);
        }
    });
    private static ConnectionLogicHelper<IBundledDevice, BundledConnection> bundled = new ConnectionLogicHelper<IBundledDevice, BundledConnection>(new ConnectionLogicHelper.IConnectableProvider<IBundledDevice, BundledConnection>(){

        @Override
        public IBundledDevice getConnectableAt(World world, int x, int y, int z, ForgeDirection face, ForgeDirection side) {
            return RedstoneApi.getInstance().getBundledDevice(world, x, y, z, face, side);
        }

        @Override
        public BundledConnection createConnection(IBundledDevice a, IBundledDevice b, ForgeDirection sideA, ForgeDirection sideB, ConnectionType type) {
            return RedstoneApi.getInstance().createConnection(a, b, sideA, sideB, type);
        }

        @Override
        public boolean canConnect(IBundledDevice from, IBundledDevice to, ForgeDirection side, ConnectionType type) {
            return from.canConnect(side, to, type);
        }

        @Override
        public boolean isValidClosedCorner(IBundledDevice o) {
            return !(o instanceof DummyRedstoneDevice);
        }

        @Override
        public boolean isValidOpenCorner(IBundledDevice o) {
            return true;
        }

        @Override
        public boolean isValidStraight(IBundledDevice o) {
            return true;
        }

        @Override
        public boolean isNormalFace(IBundledDevice o, ForgeDirection face) {
            return o.isNormalFace(face);
        }
    });

    public static RedstoneConnection getNeighbor(IRedstoneDevice device, ForgeDirection side) {
        return redstone.getNeighbor(device, side);
    }

    public static BundledConnection getBundledNeighbor(IBundledDevice device, ForgeDirection side) {
        return bundled.getNeighbor(device, side);
    }
}

