/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.redstone;

import com.bluepowermod.api.connect.ConnectionType;
import com.bluepowermod.api.connect.IConnection;
import com.bluepowermod.api.connect.IConnectionCache;
import com.bluepowermod.api.connect.IConnectionListener;
import com.bluepowermod.api.wire.redstone.IRedstoneDevice;
import com.bluepowermod.redstone.RedConnectionHelper;
import com.bluepowermod.redstone.RedstoneApi;
import com.bluepowermod.redstone.RedstoneConnection;
import net.minecraftforge.common.util.ForgeDirection;

public class RedstoneConnectionCache
implements IConnectionCache<IRedstoneDevice> {
    private IRedstoneDevice dev;
    private RedstoneConnection[] connections = new RedstoneConnection[7];
    private boolean listening = false;

    public RedstoneConnectionCache(IRedstoneDevice dev) {
        this.dev = dev;
    }

    @Override
    public IRedstoneDevice getSelf() {
        return this.dev;
    }

    @Override
    public IConnection<IRedstoneDevice> getConnectionOnSide(ForgeDirection side) {
        return this.connections[side.ordinal()];
    }

    @Override
    public void onConnect(ForgeDirection side, IRedstoneDevice connectable, ForgeDirection connectableSide, ConnectionType type) {
        RedstoneConnection redstoneConnection = RedstoneApi.getInstance().createConnection(this.getSelf(), connectable, side, connectableSide, type);
        this.connections[side.ordinal()] = redstoneConnection;
        RedstoneConnection con = redstoneConnection;
        if (this.listening) {
            ((IConnectionListener)((Object)this.dev)).onConnect(con);
        }
    }

    @Override
    public void onDisconnect(ForgeDirection side) {
        RedstoneConnection con = this.connections[side.ordinal()];
        this.connections[side.ordinal()] = null;
        if (this.listening) {
            ((IConnectionListener)((Object)this.dev)).onDisconnect(con);
        }
    }

    @Override
    public void recalculateConnections() {
        if (this.dev.getWorld().field_72995_K) {
            return;
        }
        IRedstoneDevice self = this.getSelf();
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            boolean wasConnected = this.connections[d.ordinal()] != null;
            RedstoneConnection con = RedConnectionHelper.getNeighbor(self, d);
            if (con != null) {
                if (wasConnected && this.connections[d.ordinal()].getB() == con.getB() && this.connections[d.ordinal()].getSideB() == con.getSideB() && this.connections[d.ordinal()].getType() == con.getType()) continue;
                this.onConnect(con.getSideA(), con.getB(), con.getSideB(), con.getType());
                con.getB().getRedstoneConnectionCache().onConnect(con.getSideB(), con.getA(), con.getSideA(), con.getType());
                IConnection<IRedstoneDevice> con2 = con.getB().getRedstoneConnectionCache().getConnectionOnSide(con.getSideB());
                con = this.connections[d.ordinal()];
                if (con == null) {
                    return;
                }
                con.setComplementaryConnection(con2);
                con2.setComplementaryConnection(con);
                continue;
            }
            if (!wasConnected || (con = this.connections[d.ordinal()]) == null) continue;
            this.onDisconnect(con.getSideA());
            con.getB().getRedstoneConnectionCache().onDisconnect(con.getSideB());
        }
    }

    @Override
    public void disconnectAll() {
        for (RedstoneConnection con : this.connections) {
            if (con == null) continue;
            con.getB().getRedstoneConnectionCache().onDisconnect(con.getSideB());
            this.onDisconnect(con.getSideA());
        }
    }

    @Override
    public void listen() {
        this.listening = this.dev instanceof IConnectionListener;
    }
}

