/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier1;

import com.bluepowermod.api.tube.IPneumaticTube;
import com.bluepowermod.helper.IOHelper;
import com.bluepowermod.helper.ItemStackHelper;
import com.bluepowermod.init.BPBlocks;
import com.bluepowermod.part.IGuiButtonSensitive;
import com.bluepowermod.part.tube.TubeStack;
import com.bluepowermod.tile.tier1.TileTransposer;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileFilter
extends TileTransposer
implements ISidedInventory,
IGuiButtonSensitive {
    protected final ItemStack[] inventory = new ItemStack[9];
    public IPneumaticTube.TubeColor filterColor = IPneumaticTube.TubeColor.NONE;
    public int fuzzySetting;

    @Override
    public TubeStack acceptItemFromTube(TubeStack stack, ForgeDirection from, boolean simulate) {
        if (!(from != this.getFacingDirection() || this.isItemAccepted(stack.stack) && this.isBufferEmpty())) {
            return stack;
        }
        if (!simulate) {
            this.addItemToOutputBuffer(stack.stack, this.filterColor);
        }
        return null;
    }

    @Override
    protected boolean isItemAccepted(ItemStack item) {
        boolean everythingNull = true;
        for (ItemStack invStack : this.inventory) {
            if (invStack == null) continue;
            if (ItemStackHelper.areStacksEqual(invStack, item, this.fuzzySetting)) {
                return true;
            }
            everythingNull = false;
        }
        return everythingNull;
    }

    @Override
    protected IPneumaticTube.TubeColor getAcceptedItemColor(ItemStack item) {
        return this.filterColor;
    }

    @Override
    protected void pullItem() {
        if (this.isBufferEmpty()) {
            ItemStack extractedStack;
            ForgeDirection dir = this.getOutputDirection().getOpposite();
            TileEntity tile = this.getTileCache(dir);
            ForgeDirection direction = dir.getOpposite();
            boolean everythingNull = true;
            for (ItemStack filterStack : this.inventory) {
                if (filterStack == null) continue;
                everythingNull = false;
                ItemStack extractedStack2 = IOHelper.extract(tile, direction, filterStack, true, false, this.fuzzySetting);
                if (extractedStack2 == null) continue;
                this.addItemToOutputBuffer(extractedStack2, this.filterColor);
                break;
            }
            if (everythingNull && (extractedStack = IOHelper.extract(tile, direction, false)) != null) {
                this.addItemToOutputBuffer(extractedStack, this.filterColor);
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tCompound) {
        super.func_145839_a(tCompound);
        for (int i = 0; i < 9; ++i) {
            NBTTagCompound tc = tCompound.func_74775_l("inventory" + i);
            this.inventory[i] = ItemStack.func_77949_a((NBTTagCompound)tc);
        }
        this.filterColor = IPneumaticTube.TubeColor.values()[tCompound.func_74771_c("filterColor")];
        this.fuzzySetting = tCompound.func_74771_c("fuzzySetting");
    }

    @Override
    public void func_145841_b(NBTTagCompound tCompound) {
        super.func_145841_b(tCompound);
        for (int i = 0; i < 9; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound tc = new NBTTagCompound();
            this.inventory[i].func_77955_b(tc);
            tCompound.func_74782_a("inventory" + i, (NBTBase)tc);
        }
        tCompound.func_74774_a("filterColor", (byte)this.filterColor.ordinal());
        tCompound.func_74774_a("fuzzySetting", (byte)this.fuzzySetting);
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory[i];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= amount) {
                this.func_70299_a(slot, null);
            } else {
                itemStack = itemStack.func_77979_a(amount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int i) {
        ItemStack itemStack = this.func_70301_a(i);
        if (itemStack != null) {
            this.func_70299_a(i, null);
        }
        return itemStack;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.inventory[i] = itemStack;
    }

    public String func_145825_b() {
        return BPBlocks.filter.func_149739_a();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return true;
    }

    @Override
    public List<ItemStack> getDrops() {
        List<ItemStack> drops = super.getDrops();
        for (ItemStack stack : this.inventory) {
            if (stack == null) continue;
            drops.add(stack);
        }
        return drops;
    }

    public int[] func_94128_d(int var1) {
        ForgeDirection direction = this.getFacingDirection();
        if (var1 == direction.ordinal() || var1 == direction.getOpposite().ordinal()) {
            return new int[0];
        }
        return new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    }

    public boolean func_102007_a(int slot, ItemStack itemStack, int side) {
        return true;
    }

    public boolean func_102008_b(int slot, ItemStack itemStack, int side) {
        return true;
    }

    @Override
    public void onButtonPress(EntityPlayer player, int messageId, int value) {
        if (messageId == 0) {
            this.filterColor = IPneumaticTube.TubeColor.values()[value];
        }
        if (messageId == 1) {
            this.fuzzySetting = value;
        }
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }
}

