/*
 * Decompiled with CFR 0.152.
 */
package com.bluepowermod.tile.tier1;

import com.bluepowermod.tile.IEjectAnimator;
import com.bluepowermod.tile.TileBase;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileIgniter
extends TileBase
implements IEjectAnimator {
    private boolean isActive;

    @Override
    protected void redstoneChanged(boolean newValue) {
        super.redstoneChanged(newValue);
        this.isActive = newValue;
        this.sendUpdatePacket();
        ForgeDirection direction = this.getFacingDirection();
        if (this.getIsRedstonePowered()) {
            this.ignite(direction);
        } else {
            this.extinguish(direction);
        }
    }

    @Override
    public void writeToPacketNBT(NBTTagCompound tCompound) {
        super.writeToPacketNBT(tCompound);
        tCompound.func_74757_a("isActive", this.isActive);
    }

    @Override
    public void readFromPacketNBT(NBTTagCompound tCompound) {
        super.readFromPacketNBT(tCompound);
        this.isActive = tCompound.func_74767_n("isActive");
        if (this.field_145850_b != null) {
            this.markForRenderUpdate();
        }
    }

    private void ignite(ForgeDirection direction) {
        if (this.getIsRedstonePowered() && this.field_145850_b.func_147437_c(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ)) {
            this.field_145850_b.func_147449_b(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ, (Block)Blocks.field_150480_ab);
        }
    }

    private void extinguish(ForgeDirection direction) {
        Block target = this.field_145850_b.func_147439_a(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
        if (!(this.getIsRedstonePowered() || target != Blocks.field_150480_ab && target != Blocks.field_150427_aO)) {
            this.field_145850_b.func_147449_b(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ, Blocks.field_150350_a);
        }
    }

    @Override
    public void func_145845_h() {
        if (this.getTicker() % 5 == 0) {
            this.ignite(this.getFacingDirection());
        }
        super.func_145845_h();
    }

    @Override
    public boolean isEjecting() {
        return this.isActive;
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }
}

