/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.core.blocks.IItemTyped;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSapling;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;
import net.minecraft.world.gen.feature.WorldGenerator;

public class BlockMushroom
extends BlockSapling
implements IItemTyped {
    private final WorldGenerator[] generators;
    private final ItemStack[] drops;

    public BlockMushroom() {
        this.func_149711_c(0.0f);
        this.generators = new WorldGenerator[]{new WorldGenBigMushroom(MushroomType.BROWN.ordinal()), new WorldGenBigMushroom(MushroomType.RED.ordinal())};
        this.drops = new ItemStack[]{new ItemStack((Block)Blocks.field_150338_P), new ItemStack((Block)Blocks.field_150337_Q)};
        this.func_149647_a(null);
        this.func_149675_a(true);
    }

    public boolean func_149653_t() {
        return true;
    }

    public ArrayList<ItemStack> getDrops(World world, int X, int Y, int Z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        MushroomType type = this.getTypeFromMeta(metadata);
        ret.add(this.drops[type.ordinal()]);
        return ret;
    }

    protected boolean func_149854_a(Block block) {
        return block == Blocks.field_150391_bh;
    }

    public void func_149674_a(World world, int i, int j, int k, Random random) {
        if (world.field_72995_K) {
            return;
        }
        int meta = world.func_72805_g(i, j, k);
        MushroomType type = this.getTypeFromMeta(meta);
        int maturity = meta >> 2;
        this.tickGermling(world, i, j, k, random, type, maturity);
    }

    private void tickGermling(World world, int i, int j, int k, Random random, MushroomType type, int maturity) {
        int lightvalue = world.func_72957_l(i, j + 1, k);
        if (random.nextInt(2) != 0) {
            return;
        }
        if (maturity != 3) {
            maturity = 3;
            int matX = maturity << 2;
            int meta = matX | type.ordinal();
            world.func_72921_c(i, j, k, meta, 2);
        } else if (lightvalue <= 7) {
            this.func_149878_d(world, i, j, k, random);
        }
    }

    public void func_149878_d(World world, int i, int j, int k, Random random) {
        MushroomType type = this.getTypeFromMeta(world.func_72805_g(i, j, k));
        world.func_147468_f(i, j, k);
        if (!this.generators[type.ordinal()].func_76484_a(world, random, i, j, k)) {
            world.func_147465_d(i, j, k, (Block)this, type.ordinal(), 0);
        }
    }

    @Override
    public MushroomType getTypeFromMeta(int meta) {
        return MushroomType.values()[meta %= MushroomType.values().length];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 1));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        MushroomType type = this.getTypeFromMeta(meta);
        switch (type) {
            case BROWN: {
                return Blocks.field_150338_P.func_149691_a(side, meta);
            }
            case RED: {
                return Blocks.field_150337_Q.func_149691_a(side, meta);
            }
        }
        return null;
    }

    public static enum MushroomType {
        BROWN,
        RED;

    }
}

