/*
 * Decompiled with CFR 0.152.
 */
package crazypants.util;

import com.pahimar.ee3.api.exchange.EnergyValueRegistryProxy;
import com.pahimar.ee3.api.exchange.RecipeRegistryProxy;
import cpw.mods.fml.common.Loader;
import crazypants.enderio.EnderIO;
import crazypants.enderio.config.Config;
import crazypants.enderio.item.ItemEnderFood;
import crazypants.enderio.machine.recipe.Recipe;
import crazypants.enderio.machine.recipe.RecipeInput;
import crazypants.enderio.material.MachinePart;
import crazypants.enderio.material.Material;
import crazypants.enderio.material.PowderIngot;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class EE3Util {
    public static final String EE3_ID = "EE3";
    public static final boolean IS_EE3_LOADED = Loader.isModLoaded((String)"EE3");

    public static void registerItemStack(ItemStack itemStack, int emv) {
        if (IS_EE3_LOADED) {
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)itemStack, (float)emv);
        }
    }

    public static void registerItemStackLike(ItemStack itemStack, ItemStack copyFrom) {
        if (IS_EE3_LOADED) {
            RecipeRegistryProxy.addRecipe((Object)itemStack, Collections.singletonList(copyFrom));
        }
    }

    public static void registerFluidStack(FluidStack fluidStack, int emv) {
        if (IS_EE3_LOADED) {
            EnergyValueRegistryProxy.addPreAssignedEnergyValue((Object)fluidStack, (float)emv);
        }
    }

    public static void registerRecipe(ItemStack itemStack, List<?> recipeInputList) {
        if (IS_EE3_LOADED) {
            RecipeRegistryProxy.addRecipe((Object)itemStack, recipeInputList);
        }
    }

    public static void registerRecipe(FluidStack fluidStack, List<?> recipeInputList) {
        if (IS_EE3_LOADED) {
            RecipeRegistryProxy.addRecipe((Object)fluidStack, recipeInputList);
        }
    }

    public static void registerRecipe(ItemStack itemStack, Object ... recipeInputList) {
        if (IS_EE3_LOADED) {
            RecipeRegistryProxy.addRecipe((Object)itemStack, Arrays.asList(recipeInputList));
        }
    }

    public static void registerRecipe(FluidStack fluidStack, Object ... recipeInputList) {
        if (IS_EE3_LOADED) {
            RecipeRegistryProxy.addRecipe((Object)fluidStack, Arrays.asList(recipeInputList));
        }
    }

    public static void registerMiscRecipes() {
        if (IS_EE3_LOADED) {
            ItemStack basicGear = new ItemStack((Item)EnderIO.itemMachinePart, 1, MachinePart.BASIC_GEAR.ordinal());
            ItemStack stick4 = new ItemStack(Items.field_151055_y, 4);
            ItemStack cobble4 = new ItemStack(Blocks.field_150347_e, 4);
            EE3Util.registerRecipe(basicGear, stick4, cobble4);
            ItemStack flour10 = new ItemStack((Item)EnderIO.itemPowderIngot, 10, PowderIngot.FLOUR.ordinal());
            ItemStack wheat5 = new ItemStack(Items.field_151015_O, 5);
            ItemStack seeds1 = new ItemStack(Items.field_151014_N, 1);
            EE3Util.registerRecipe(flour10, wheat5, seeds1);
            ItemStack enderios = ItemEnderFood.EnderFood.ENDERIOS.getStack();
            ItemStack bowl = new ItemStack(Items.field_151054_z, 1);
            ItemStack wheat = new ItemStack(Items.field_151015_O, 1);
            ItemStack milkb = new ItemStack(Items.field_151117_aB, 1);
            FluidStack milk = FluidContainerRegistry.getFluidForFilledItem((ItemStack)milkb);
            ItemStack dustEnderPearl = new ItemStack((Item)EnderIO.itemPowderIngot, 1, PowderIngot.POWDER_ENDER.ordinal());
            if (milk != null) {
                EE3Util.registerRecipe(enderios, bowl, milk, wheat, dustEnderPearl);
            } else {
                EE3Util.registerRecipe(enderios, bowl, milkb, wheat, dustEnderPearl);
            }
            ItemStack dustCoal = new ItemStack((Item)EnderIO.itemPowderIngot, 1, PowderIngot.POWDER_COAL.ordinal());
            ItemStack coal = new ItemStack(Items.field_151044_h, 1);
            EE3Util.registerRecipe(dustCoal, coal);
            ItemStack dustIron = new ItemStack((Item)EnderIO.itemPowderIngot, 1, PowderIngot.POWDER_IRON.ordinal());
            ItemStack iron = new ItemStack(Items.field_151042_j, 1);
            EE3Util.registerRecipe(dustIron, iron);
            ItemStack dustGold = new ItemStack((Item)EnderIO.itemPowderIngot, 1, PowderIngot.POWDER_GOLD.ordinal());
            ItemStack gold = new ItemStack(Items.field_151043_k, 1);
            EE3Util.registerRecipe(dustGold, gold);
            ItemStack dustObsidian4 = new ItemStack((Item)EnderIO.itemPowderIngot, 4, PowderIngot.POWDER_OBSIDIAN.ordinal());
            ItemStack obsidian = new ItemStack(Blocks.field_150343_Z, 1);
            EE3Util.registerRecipe(dustObsidian4, obsidian);
            ItemStack enderDust9 = new ItemStack((Item)EnderIO.itemPowderIngot, 9, PowderIngot.POWDER_ENDER.ordinal());
            ItemStack enderPearl = new ItemStack(Items.field_151079_bi);
            EE3Util.registerRecipe(enderDust9, enderPearl);
            ItemStack cbc8 = Material.BINDER_COMPOSITE.getStack(8);
            ItemStack sand2 = new ItemStack((Block)Blocks.field_150354_m, 2);
            ItemStack gravel5 = new ItemStack(Blocks.field_150351_n, 5);
            ItemStack gravel6 = new ItemStack(Blocks.field_150351_n, 6);
            ItemStack clay_ball2 = new ItemStack(Items.field_151119_aD, 2);
            ItemStack clay_ball1 = new ItemStack(Items.field_151119_aD, 1);
            if (Config.useAlternateBinderRecipe) {
                EE3Util.registerRecipe(cbc8, gravel5, clay_ball2, sand2);
            } else {
                EE3Util.registerRecipe(cbc8, gravel6, clay_ball1, sand2);
            }
            EE3Util.registerRecipe(cbc8, gravel6, clay_ball1, sand2);
            ItemStack cbc = Material.BINDER_COMPOSITE.getStack();
            ItemStack binder4 = Material.CONDUIT_BINDER.getStack(4);
            EE3Util.registerRecipe(binder4, cbc);
            ItemStack silicon = Material.SILICON.getStack(1);
            EE3Util.registerRecipe(silicon, sand2);
            int numConduits = Config.numConduitsPerRecipe;
            ItemStack phasedIronNugget3 = Material.PHASED_IRON_NUGGET.getStack(3);
            ItemStack binder6 = Material.CONDUIT_BINDER.getStack(6);
            ItemStack itemConduit = new ItemStack((Item)EnderIO.itemItemConduit, numConduits, 0);
            EE3Util.registerRecipe(itemConduit, phasedIronNugget3, binder6);
        }
    }

    public static void registerBasicToManyRecipe(Recipe recipe) {
        if (IS_EE3_LOADED) {
            ArrayList<ItemStack> in = new ArrayList<ItemStack>();
            for (RecipeInput r0 : recipe.getInputs()) {
                in.add(r0.getInput().func_77946_l());
            }
            EE3Util.registerRecipe(recipe.getOutputs()[0].getOutput().func_77946_l(), in);
        }
    }
}

