/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.network.message;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import net.blay09.mods.waystones.util.WaystoneEntry;

public class MessageWaystones
implements IMessage {
    private WaystoneEntry[] entries;
    private WaystoneEntry[] serverEntries;
    private String lastServerWaystoneName;
    private long lastFreeWarp;
    private long lastWarpStoneUse;

    public MessageWaystones() {
    }

    public MessageWaystones(WaystoneEntry[] entries, WaystoneEntry[] serverEntries, String lastServerWaystoneName, long lastFreeWarp, long lastWarpStoneUse) {
        this.entries = entries;
        this.serverEntries = serverEntries;
        this.lastFreeWarp = lastFreeWarp;
        this.lastWarpStoneUse = lastWarpStoneUse;
        this.lastServerWaystoneName = lastServerWaystoneName;
    }

    public void fromBytes(ByteBuf buf) {
        int i;
        this.entries = new WaystoneEntry[buf.readByte()];
        for (i = 0; i < this.entries.length; ++i) {
            this.entries[i] = WaystoneEntry.read(buf);
        }
        this.serverEntries = new WaystoneEntry[buf.readByte()];
        for (i = 0; i < this.serverEntries.length; ++i) {
            this.serverEntries[i] = WaystoneEntry.read(buf);
            this.serverEntries[i].setGlobal(true);
        }
        this.lastServerWaystoneName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.lastFreeWarp = buf.readLong();
        this.lastWarpStoneUse = buf.readLong();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.entries.length);
        for (WaystoneEntry entry : this.entries) {
            entry.write(buf);
        }
        buf.writeByte(this.serverEntries.length);
        for (WaystoneEntry entry : this.serverEntries) {
            entry.write(buf);
        }
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.lastServerWaystoneName);
        buf.writeLong(this.lastFreeWarp);
        buf.writeLong(this.lastWarpStoneUse);
    }

    public WaystoneEntry[] getEntries() {
        return this.entries;
    }

    public WaystoneEntry[] getServerEntries() {
        return this.serverEntries;
    }

    public String getLastServerWaystoneName() {
        return this.lastServerWaystoneName;
    }

    public long getLastFreeWarp() {
        return this.lastFreeWarp;
    }

    public long getLastWarpStoneUse() {
        return this.lastWarpStoneUse;
    }
}

