/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.util;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockPos {
    private static final int NUM_X_BITS = 26;
    private static final int NUM_Z_BITS = 26;
    private static final int NUM_Y_BITS = 12;
    private static final int Y_SHIFT = 26;
    private static final int X_SHIFT = 38;
    private static final long X_MASK = 0x3FFFFFFL;
    private static final long Y_MASK = 4095L;
    private static final long Z_MASK = 0x3FFFFFFL;
    private final int x;
    private final int y;
    private final int z;

    public BlockPos(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public BlockPos(TileEntity tileEntity) {
        this.x = tileEntity.field_145851_c;
        this.y = tileEntity.field_145848_d;
        this.z = tileEntity.field_145849_e;
    }

    public BlockPos(EntityPlayer player) {
        this.x = (int)player.field_70165_t;
        this.y = (int)player.field_70163_u;
        this.z = (int)player.field_70161_v;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public long toLong() {
        return ((long)this.getX() & 0x3FFFFFFL) << 38 | ((long)this.getY() & 0xFFFL) << 26 | (long)this.getZ() & 0x3FFFFFFL;
    }

    public static BlockPos fromLong(long value) {
        int i = (int)(value >> 38);
        int j = (int)(value << 26 >> 52);
        int k = (int)(value << 38 >> 38);
        return new BlockPos(i, j, k);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockPos blockPos = (BlockPos)o;
        return this.x == blockPos.x && this.y == blockPos.y && this.z == blockPos.z;
    }

    public int hashCode() {
        int result = this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public boolean equals(int xCoord, int yCoord, int zCoord) {
        return this.x == xCoord && this.y == yCoord && this.z == zCoord;
    }

    public BlockPos offset(ForgeDirection facing) {
        return new BlockPos(this.x + facing.offsetX, this.y + facing.offsetY, this.z + facing.offsetZ);
    }
}

