/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import openmods.gui.component.BaseComponent;
import openmods.gui.listener.IValueChangedListener;

public class GuiComponentPalettePicker
extends BaseComponent {
    private List<PaletteEntry> palette = ImmutableList.of();
    private int rowSize = 2;
    private int columnCount;
    private int areaSize = 4;
    private IValueChangedListener<PaletteEntry> listener;
    private boolean drawTooltip = false;

    public GuiComponentPalettePicker(int x, int y) {
        super(x, y);
    }

    @Override
    public int getWidth() {
        return this.rowSize * this.areaSize;
    }

    @Override
    public int getHeight() {
        return this.columnCount * this.areaSize;
    }

    private void recalculate() {
        if (this.palette.isEmpty()) {
            this.columnCount = 0;
        } else {
            int count = this.palette.size();
            this.columnCount = (count + (this.rowSize - 1)) / this.rowSize;
        }
    }

    public void setPalette(List<PaletteEntry> colors) {
        this.palette = ImmutableList.copyOf(colors);
        this.recalculate();
    }

    public void setRowSize(int rowSize) {
        this.rowSize = rowSize;
        this.recalculate();
    }

    public void setAreaSize(int areaSize) {
        this.areaSize = areaSize;
    }

    public void setDrawTooltip(boolean drawTooltip) {
        this.drawTooltip = drawTooltip;
    }

    public void setListener(IValueChangedListener<PaletteEntry> listener) {
        this.listener = listener;
    }

    @Override
    public void render(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        int by;
        Iterator<PaletteEntry> it = this.palette.iterator();
        int bx = this.x + offsetX;
        int ry = by = this.y + offsetY;
        block0: for (int column = 0; column < this.columnCount; ++column) {
            int ny = ry + this.areaSize;
            int rx = bx;
            for (int row = 0; row < this.rowSize; ++row) {
                if (!it.hasNext()) break block0;
                PaletteEntry entry = it.next();
                int nx = rx + this.areaSize;
                GuiComponentPalettePicker.func_73734_a((int)rx, (int)ry, (int)nx, (int)ny, (int)(0xFF000000 | entry.rgb));
                rx = nx;
            }
            ry = ny;
        }
    }

    @Override
    public void renderOverlay(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        PaletteEntry entry;
        if (this.drawTooltip && this.isMouseOver(mouseX, mouseY) && (entry = this.findEntry(mouseX - this.x, mouseY - this.y)) != null) {
            this.drawHoveringText(entry.name, offsetX + mouseX, offsetY + mouseY, minecraft.field_71466_p);
        }
    }

    @Override
    public void mouseDown(int mouseX, int mouseY, int button) {
        PaletteEntry entry;
        super.mouseDown(mouseX, mouseY, button);
        if (this.listener != null && (entry = this.findEntry(mouseX, mouseY)) != null) {
            this.listener.valueChanged(entry);
        }
    }

    private PaletteEntry findEntry(int mouseX, int mouseY) {
        int index;
        int row = mouseX / this.areaSize;
        int column = mouseY / this.areaSize;
        if (row < this.rowSize && column < this.columnCount && (index = column * this.rowSize + row) >= 0 && index < this.palette.size()) {
            return this.palette.get(index);
        }
        return null;
    }

    public static class PaletteEntry {
        public final int callback;
        public final int rgb;
        public final String name;

        public PaletteEntry(int callback, int rgb, String name) {
            this.callback = callback;
            this.rgb = rgb;
            this.name = name;
        }
    }
}

