/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.blocks;

import ganymedes01.etfuturum.blocks.BaseBlock;
import ganymedes01.etfuturum.client.sound.ModSounds;
import ganymedes01.etfuturum.lib.RenderIDs;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class BlockSlime
extends BaseBlock {
    private static final Map<Entity, Double> SLIME_BOUNCE_CACHE = new WeakHashMap<Entity, Double>();
    private long lastBounceTick;

    public BlockSlime() {
        super(Material.field_151571_B);
        this.func_149711_c(0.0f);
        this.setNames("slime");
        this.setBlockSound(ModSounds.soundSlime);
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        float f = 0.125f;
        return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)((float)(y + 1) - f), (double)(z + 1));
    }

    public void func_149746_a(World world, int x, int y, int z, Entity entity, float fallDistance) {
        if (!entity.func_70093_af()) {
            entity.field_70143_R = 0.0f;
            if (entity.field_70181_x < 0.1) {
                SLIME_BOUNCE_CACHE.put(entity, -entity.field_70181_x);
                this.lastBounceTick = world.func_82737_E();
            }
        }
        super.func_149746_a(world, x, y, z, entity, fallDistance);
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (this.lastBounceTick == world.func_82737_E()) {
            Double bounce = SLIME_BOUNCE_CACHE.remove(entity);
            if (bounce != null) {
                entity.field_70181_x = bounce;
            }
        } else {
            SLIME_BOUNCE_CACHE.clear();
        }
        double d = 0.4 + Math.abs(entity.field_70181_x) * 0.2;
        entity.field_70159_w *= d;
        entity.field_70179_y *= d;
        super.func_149670_a(world, x, y, z, entity);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149701_w() {
        return 1;
    }

    public int func_149645_b() {
        return RenderIDs.SLIME_BLOCK;
    }
}

