/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.core.utils;

import cpw.mods.fml.common.Loader;
import ganymedes01.etfuturum.client.sound.ModSounds;
import ganymedes01.etfuturum.compat.ModsList;
import ganymedes01.etfuturum.configuration.configs.ConfigBlocksItems;
import ganymedes01.etfuturum.configuration.configs.ConfigModCompat;
import ganymedes01.etfuturum.configuration.configs.ConfigSounds;
import ganymedes01.etfuturum.spectator.SpectatorMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;

public class Utils {
    public static final ForgeDirection[] FORGE_DIRECTIONS = ForgeDirection.values();
    public static final ForgeDirection[] HORIZONTAL_FORGE_DIRECTIONS = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST};
    public static final EnumFacing[] ENUM_FACING_VALUES = EnumFacing.values();
    public static final EnumFacing[] HORIZONTAL_ENUM_FACING = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST};
    public static final float SQRT_2 = MathHelper.func_76129_c((float)2.0f);
    private static String betterFpsAlgo;
    private static Integer maxMeta;
    private static Integer minMeta;

    public static String getUnlocalisedName(String name) {
        return "etfuturum." + name;
    }

    public static String getBlockTexture(String name) {
        return "etfuturum:" + name;
    }

    public static String getItemTexture(String name) {
        return "etfuturum:" + name;
    }

    public static ResourceLocation getResource(String path) {
        return new ResourceLocation(path);
    }

    public static String getConainerName(String name) {
        return "container.etfuturum." + name;
    }

    public static String getModContainer() {
        return Loader.instance().activeModContainer().getName();
    }

    public static <T> T getTileEntity(IBlockAccess world, int x, int y, int z, Class<T> cls) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!cls.isInstance(tile)) {
            return null;
        }
        return (T)tile;
    }

    public static List<String> getOreNames(ItemStack stack) {
        ArrayList<String> list = new ArrayList<String>();
        for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
            list.add(OreDictionary.getOreName((int)id));
        }
        return list;
    }

    public static void loadItemStacksFromNBT(NBTTagList tag, ItemStack[] stacks) {
        for (int i = 0; i < tag.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = tag.func_150305_b(i);
            int j = nbttagcompound1.func_74771_c("Slot") & 0xFF;
            if (j >= stacks.length) continue;
            stacks[j] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    public static NBTTagList writeItemStacksToNBT(ItemStack[] stacks) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < stacks.length; ++i) {
            if (stacks[i] == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stacks[i].func_77955_b(tag);
            list.func_74742_a((NBTBase)tag);
        }
        return list;
    }

    public static NBTTagCompound createUUIDTag(UUID uuid) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        nbttagcompound.func_74772_a("M", uuid.getMostSignificantBits());
        nbttagcompound.func_74772_a("L", uuid.getLeastSignificantBits());
        return nbttagcompound;
    }

    public static UUID getUUIDFromTag(NBTTagCompound tag) {
        return new UUID(tag.func_74763_f("M"), tag.func_74763_f("L"));
    }

    public static MovingObjectPosition forwardsRaycast(Entity p_188802_0_, boolean p_188802_1_, boolean p_188802_2_, Entity p_188802_3_) {
        double d0 = p_188802_0_.field_70165_t;
        double d1 = p_188802_0_.field_70163_u;
        double d2 = p_188802_0_.field_70161_v;
        double d3 = p_188802_0_.field_70159_w;
        double d4 = p_188802_0_.field_70181_x;
        double d5 = p_188802_0_.field_70179_y;
        World world = p_188802_0_.field_70170_p;
        Vec3 vec3d = Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
        Vec3 vec3d1 = Vec3.func_72443_a((double)(d0 + d3), (double)(d1 + d4), (double)(d2 + d5));
        MovingObjectPosition raytraceresult = world.func_147447_a(vec3d, vec3d1, false, true, false);
        if (p_188802_1_) {
            if (raytraceresult != null) {
                vec3d1 = Vec3.func_72443_a((double)raytraceresult.field_72307_f.field_72450_a, (double)raytraceresult.field_72307_f.field_72448_b, (double)raytraceresult.field_72307_f.field_72449_c);
            }
            Entity entity = null;
            List list = world.func_72839_b(p_188802_0_, p_188802_0_.field_70121_D.func_72321_a(d3, d4, d5).func_72314_b(1.0, 1.0, 1.0));
            double d6 = 0.0;
            for (int i = 0; i < list.size(); ++i) {
                double d7;
                AxisAlignedBB axisalignedbb;
                MovingObjectPosition raytraceresult1;
                Entity entity1 = (Entity)list.get(i);
                if (!entity1.func_70067_L() || !p_188802_2_ && entity1.func_70028_i(p_188802_3_) || entity1.field_70145_X || (raytraceresult1 = (axisalignedbb = entity1.field_70121_D.func_72314_b((double)0.3f, (double)0.3f, (double)0.3f)).func_72327_a(vec3d, vec3d1)) == null || !((d7 = vec3d.func_72436_e(raytraceresult1.field_72307_f)) < d6) && d6 != 0.0) continue;
                entity = entity1;
                d6 = d7;
            }
            if (entity != null) {
                raytraceresult = new MovingObjectPosition(entity);
            }
        }
        return raytraceresult;
    }

    public static void rotateTowardsMovement(Entity p_188803_0_, float p_188803_1_) {
        double d0 = p_188803_0_.field_70159_w;
        double d1 = p_188803_0_.field_70181_x;
        double d2 = p_188803_0_.field_70179_y;
        float f = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        p_188803_0_.field_70177_z = (float)(Utils.atan2(d2, d0) * 57.29577951308232) + 90.0f;
        p_188803_0_.field_70125_A = (float)(Utils.atan2(f, d1) * 57.29577951308232) - 90.0f;
        while (p_188803_0_.field_70125_A - p_188803_0_.field_70127_C < -180.0f) {
            p_188803_0_.field_70127_C -= 360.0f;
        }
        while (p_188803_0_.field_70125_A - p_188803_0_.field_70127_C >= 180.0f) {
            p_188803_0_.field_70127_C += 360.0f;
        }
        while (p_188803_0_.field_70177_z - p_188803_0_.field_70126_B < -180.0f) {
            p_188803_0_.field_70126_B -= 360.0f;
        }
        while (p_188803_0_.field_70177_z - p_188803_0_.field_70126_B >= 180.0f) {
            p_188803_0_.field_70126_B += 360.0f;
        }
        p_188803_0_.field_70125_A = p_188803_0_.field_70127_C + (p_188803_0_.field_70125_A - p_188803_0_.field_70127_C) * p_188803_1_;
        p_188803_0_.field_70177_z = p_188803_0_.field_70126_B + (p_188803_0_.field_70177_z - p_188803_0_.field_70126_B) * p_188803_1_;
    }

    public static double atan2(double p_181159_0_, double p_181159_2_) {
        boolean flag2;
        boolean flag1;
        boolean flag;
        double FRAC_BIAS = Double.longBitsToDouble(4805340802404319232L);
        double[] ASINE_TAB = new double[257];
        double[] COS_TAB = new double[257];
        for (int j = 0; j < 257; ++j) {
            double d0 = (double)j / 256.0;
            double d1 = Math.asin(d0);
            COS_TAB[j] = Math.cos(d1);
            ASINE_TAB[j] = d1;
        }
        double d0 = p_181159_2_ * p_181159_2_ + p_181159_0_ * p_181159_0_;
        if (Double.isNaN(d0)) {
            return Double.NaN;
        }
        boolean bl = flag = p_181159_0_ < 0.0;
        if (flag) {
            p_181159_0_ = -p_181159_0_;
        }
        boolean bl2 = flag1 = p_181159_2_ < 0.0;
        if (flag1) {
            p_181159_2_ = -p_181159_2_;
        }
        boolean bl3 = flag2 = p_181159_0_ > p_181159_2_;
        if (flag2) {
            double d1 = p_181159_2_;
            p_181159_2_ = p_181159_0_;
            p_181159_0_ = d1;
        }
        double d9 = Utils.fastInvSqrt(d0);
        p_181159_2_ *= d9;
        double d2 = FRAC_BIAS + (p_181159_0_ *= d9);
        int i = (int)Double.doubleToRawLongBits(d2);
        double d3 = ASINE_TAB[i];
        double d4 = COS_TAB[i];
        double d5 = d2 - FRAC_BIAS;
        double d6 = p_181159_0_ * d4 - p_181159_2_ * d5;
        double d7 = (6.0 + d6 * d6) * d6 * 0.16666666666666666;
        double d8 = d3 + d7;
        if (flag2) {
            d8 = 1.5707963267948966 - d8;
        }
        if (flag1) {
            d8 = Math.PI - d8;
        }
        if (flag) {
            d8 = -d8;
        }
        return d8;
    }

    public static double fastInvSqrt(double p_181161_0_) {
        double d0 = 0.5 * p_181161_0_;
        long i = Double.doubleToRawLongBits(p_181161_0_);
        i = 6910469410427058090L - (i >> 1);
        p_181161_0_ = Double.longBitsToDouble(i);
        p_181161_0_ *= 1.5 - d0 * p_181161_0_ * p_181161_0_;
        return p_181161_0_;
    }

    public static double perlinFade(double value) {
        return value * value * value * (value * (value * 6.0 - 15.0) + 10.0);
    }

    public static double perlinFadeDerivative(double value) {
        return 30.0 * value * value * (value - 1.0) * (value - 1.0);
    }

    public static float lerp(float delta, float start, float end) {
        return start + delta * (end - start);
    }

    public static double lerp(double delta, double start, double end) {
        return start + delta * (end - start);
    }

    public static double lerp2(double deltaX, double deltaY, double x0y0, double x1y0, double x0y1, double x1y1) {
        return Utils.lerp(deltaY, Utils.lerp(deltaX, x0y0, x1y0), Utils.lerp(deltaX, x0y1, x1y1));
    }

    public static double lerp3(double deltaX, double deltaY, double deltaZ, double x0y0z0, double x1y0z0, double x0y1z0, double x1y1z0, double x0y0z1, double x1y0z1, double x0y1z1, double x1y1z1) {
        return Utils.lerp(deltaZ, Utils.lerp2(deltaX, deltaY, x0y0z0, x1y0z0, x0y1z0, x1y1z0), Utils.lerp2(deltaX, deltaY, x0y0z1, x1y0z1, x0y1z1, x1y1z1));
    }

    public static long lfloor(double value) {
        long l = (long)value;
        return value < (double)l ? l - 1L : l;
    }

    public static float fastInverseSqrt(float x) {
        float f = 0.5f * x;
        int i = Float.floatToIntBits(x);
        i = 1597463007 - (i >> 1);
        x = Float.intBitsToFloat(i);
        x *= 1.5f - f * x * x;
        return x;
    }

    public static double fastInverseSqrt(double x) {
        double d = 0.5 * x;
        long l = Double.doubleToRawLongBits(x);
        l = 6910469410427058090L - (l >> 1);
        x = Double.longBitsToDouble(l);
        x *= 1.5 - d * x * x;
        return x;
    }

    public static <T> T getRandom(List<T> list, Random rand) {
        return list.get(rand.nextInt(list.size()));
    }

    public static <T> T getRandom(T[] array, Random rand) {
        return array[rand.nextInt(array.length)];
    }

    public static int getRandom(int[] array, Random rand) {
        return array[rand.nextInt(array.length)];
    }

    public static void setBlockSound(Block block, Block.SoundType type) {
        block.func_149672_a(Utils.getSound(type));
    }

    public static Block.SoundType getSound(Block.SoundType type) {
        if (type instanceof ModSounds.CustomSound) {
            return ConfigSounds.newBlockSounds ? type : ((ModSounds.CustomSound)type).getDisabledSound();
        }
        return type;
    }

    public static Vec3 getVec3FromEntity(Entity entity, float p_70666_1_) {
        if (p_70666_1_ == 1.0f) {
            return Vec3.func_72443_a((double)entity.field_70165_t, (double)entity.field_70163_u, (double)entity.field_70161_v);
        }
        double d0 = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)p_70666_1_;
        double d1 = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)p_70666_1_;
        double d2 = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)p_70666_1_;
        return Vec3.func_72443_a((double)d0, (double)d1, (double)d2);
    }

    public static int distManhattan(int x1, int y1, int z1, int x2, int y2, int z2) {
        float f = Math.abs(x2 - x1);
        float f1 = Math.abs(y2 - y1);
        float f2 = Math.abs(z2 - z1);
        return (int)(f + f1 + f2);
    }

    public static String getNamesForConfig(String ... names) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < names.length; ++i) {
            sb.append(", ");
            if (i == names.length - 1) {
                sb.append("and ");
            }
            sb.append(names[i].split("_")[0]);
            sb.append(" ");
            sb.append(names[i].split("_")[1]);
        }
        return sb.toString();
    }

    public static boolean badBetterFPSAlgorithm() {
        if (betterFpsAlgo == null) {
            betterFpsAlgo = "";
            try {
                betterFpsAlgo = (String)Class.forName("me.guichaguri.betterfps.BetterFpsHelper").getField("ALGORITHM_NAME").get(null);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
        }
        return Objects.equals(betterFpsAlgo, "rivens-half") || Objects.equals(betterFpsAlgo, "taylors");
    }

    public static long hashPos(int x, int y, int z) {
        return Utils.cantor(x, Utils.cantor(y, z));
    }

    public static long cantor(long a, long b) {
        return (a + b + 1L) * (a + b) / 2L + b;
    }

    public static BiomeGenBase[] excludeBiomesFromTypesWithDefaults(BiomeGenBase[] list, BiomeDictionary.Type ... typesBlacklist) {
        return Utils.excludeBiomesFromTypes(list, (BiomeDictionary.Type[])ArrayUtils.addAll((Object[])typesBlacklist, (Object[])new BiomeDictionary.Type[]{BiomeDictionary.Type.NETHER, BiomeDictionary.Type.END, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.WASTELAND}));
    }

    public static BiomeGenBase[] excludeBiomesFromTypes(BiomeGenBase[] list, BiomeDictionary.Type ... typesBlacklist) {
        for (BiomeDictionary.Type typeToBlacklist : typesBlacklist) {
            list = (BiomeGenBase[])ArrayUtils.removeElements((Object[])list, (Object[])BiomeDictionary.getBiomesForType((BiomeDictionary.Type)typeToBlacklist));
        }
        return list;
    }

    public static int getMaxMetadata() {
        if (maxMeta == null) {
            maxMeta = ModsList.NOT_ENOUGH_IDS.isLoaded() && ModsList.NOT_ENOUGH_IDS.isVersionNewerOrEqual("2.0.0") ? Integer.valueOf(Short.MAX_VALUE) : (ModsList.ENDLESS_IDS_BLOCKITEM.isLoaded() ? Integer.valueOf(65536) : Integer.valueOf(15));
        }
        return maxMeta;
    }

    public static int getMinMetadata() {
        if (minMeta == null) {
            minMeta = ModsList.NOT_ENOUGH_IDS.isLoaded() && ModsList.NOT_ENOUGH_IDS.isVersionNewerOrEqual("2.0.0") ? Integer.valueOf(Short.MIN_VALUE) : Integer.valueOf(0);
        }
        return minMeta;
    }

    public static boolean isMetaInBlockBounds(int meta) {
        return meta <= Utils.getMaxMetadata() && meta >= Utils.getMinMetadata();
    }

    public static boolean isMetaInBlockBoundsIgnoreWildcard(int meta) {
        return meta == Short.MAX_VALUE || Utils.isMetaInBlockBounds(meta);
    }

    public static void copyAttribs(Block to, Block from) {
        to.func_149711_c(from.field_149782_v);
        to.func_149752_b(from.field_149781_w);
        to.func_149672_a(from.field_149762_H);
        to.func_149715_a((float)from.func_149750_m() / 15.0f);
        to.func_149713_g(from.func_149717_k());
        for (int i = 0; i < 16; ++i) {
            to.setHarvestLevel(from.getHarvestTool(i), from.getHarvestLevel(i), i);
        }
    }

    public static boolean hasPotionEffect(ItemStack p_hasEffect_1_) {
        List var2 = Items.field_151068_bn.func_77832_l(p_hasEffect_1_);
        return var2 != null && !var2.isEmpty();
    }

    public static void setLightLevel(Block block, int level) {
        block.func_149715_a((float)level / 15.0f);
    }

    public static ItemStack getFirstStackFromTag(String type) {
        if (OreDictionary.getOres((String)type).isEmpty()) {
            return null;
        }
        return ((ItemStack)OreDictionary.getOres((String)type).get(0)).func_77946_l();
    }

    public static ItemStack getFirstBlockFromTag(String oreDictTag) {
        return Utils.getFirstBlockFromTag(oreDictTag, null);
    }

    public static ItemStack getFirstBlockFromTag(String oreDictTag, ItemStack fallback) {
        return Utils.getFirstFromTagConditional(oreDictTag, itemStack -> itemStack.func_77973_b() instanceof ItemBlock, fallback);
    }

    public static ItemStack getFirstFromTagConditional(String oreDictTag, Predicate<ItemStack> predicate, ItemStack fallback) {
        for (ItemStack stack : OreDictionary.getOres((String)oreDictTag)) {
            if (!predicate.test(stack)) continue;
            return stack;
        }
        return fallback;
    }

    public static ItemStack getFirstNonDeepslateBlockFromTag(String oreDictTag, ItemStack fallback) {
        return Utils.getFirstFromTagConditional(oreDictTag, itemStack -> itemStack.func_77973_b() instanceof ItemBlock && !Block.func_149634_a((Item)itemStack.func_77973_b()).getClass().getName().toLowerCase().contains("deepslate"), fallback);
    }

    public static boolean enableModdedDeepslateOres() {
        return Utils.enableModdedDeepslateOres(null);
    }

    public static boolean enableModdedDeepslateOres(ModsList mod) {
        return ConfigModCompat.moddedDeepslateOres && ConfigBlocksItems.enableDeepslate && ConfigBlocksItems.enableDeepslateOres && (mod == null || mod.isLoaded() && !ConfigModCompat.moddedDeepslateOresBlacklist.contains(mod.modID()));
    }

    public static boolean enableModdedRawOres() {
        return Utils.enableModdedRawOres(null);
    }

    public static boolean enableModdedRawOres(ModsList mod) {
        return ConfigBlocksItems.enableRawOres && ConfigModCompat.moddedRawOres && (mod == null || mod.isLoaded() && !ConfigModCompat.moddedRawOresBlacklist.contains(mod.modID()));
    }

    public static boolean listGeneralModdedDeepslateOre(String oreDict) {
        return !ConfigModCompat.moddedDeepslateOresBlacklist.contains(oreDict) && !OreDictionary.getOres((String)oreDict).isEmpty();
    }

    public static boolean listGeneralModdedRawOre(String oreDict) {
        return !ConfigModCompat.moddedRawOresBlacklist.contains(oreDict.replace("ingot", "ore")) && !OreDictionary.getOres((String)oreDict).isEmpty() && !OreDictionary.getOres((String)oreDict.replace("ingot", "ore")).isEmpty();
    }

    public static List<EntityPlayer> getListWithoutSpectators(List<EntityPlayer> list) {
        return list.stream().filter(entity -> !SpectatorMode.isSpectator(entity)).collect(Collectors.toList());
    }
}

