/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.core.utils.structurenbt;

import cpw.mods.fml.common.registry.GameRegistry;
import ganymedes01.etfuturum.core.utils.structurenbt.BlockStateContainer;
import ganymedes01.etfuturum.core.utils.structurenbt.NBTStructure;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class BlockStateConverter {
    public static final BlockStateConverter DEFAULT_INSTANCE = new BlockStateConverter();

    public Map<Integer, BlockStateContainer> processPalette(ForgeDirection dir, Set<Pair<Integer, NBTTagCompound>> paletteNBT) {
        HashMap<Integer, BlockStateContainer> map = new HashMap<Integer, BlockStateContainer>();
        for (Pair<Integer, NBTTagCompound> pair : paletteNBT) {
            Map<String, String> properties;
            String namespace = NBTStructure.getBlockNamespaceFromNBT((NBTTagCompound)pair.getRight());
            Block block = this.getBlockFromNamespace(namespace, properties = NBTStructure.getProperties((NBTTagCompound)pair.getRight()));
            if (block == null) continue;
            map.put((Integer)pair.getLeft(), this.createBlockStateContainer(namespace, block, properties, dir));
        }
        return map;
    }

    public BlockStateContainer createBlockStateContainer(String blockName, Block block, Map<String, String> blockStates, ForgeDirection dir) {
        BlockStateContainer bsc = new BlockStateContainer(block, this.getMetaFromStateWithSubtypeAdditions(blockName, blockStates, dir));
        NBTTagCompound nbt = null;
        if (block instanceof ITileEntityProvider) {
            String truncatedName = blockName.substring(blockName.indexOf(":") + 1);
            if (truncatedName.startsWith("potted")) {
                BlockFlower pottedBlock = null;
                int pottedMeta = 0;
                switch (truncatedName.replace("potted_", "")) {
                    case "dandelion": {
                        pottedBlock = Blocks.field_150327_N;
                        break;
                    }
                    case "poppy": {
                        pottedBlock = Blocks.field_150328_O;
                        break;
                    }
                    case "blue_orchid": {
                        pottedBlock = Blocks.field_150328_O;
                        pottedMeta = 1;
                        break;
                    }
                    case "allium": {
                        pottedBlock = Blocks.field_150328_O;
                        pottedMeta = 2;
                        break;
                    }
                    case "azure_bluet": {
                        pottedBlock = Blocks.field_150328_O;
                        pottedMeta = 3;
                        break;
                    }
                    case "oxeye_daisy": {
                        pottedBlock = Blocks.field_150328_O;
                        pottedMeta = 8;
                        break;
                    }
                    case "red_tulip": {
                        pottedBlock = Blocks.field_150328_O;
                        pottedMeta = 4;
                        break;
                    }
                    case "orange_tulip": {
                        pottedBlock = Blocks.field_150328_O;
                        pottedMeta = 5;
                        break;
                    }
                    case "white_tulip": {
                        pottedBlock = Blocks.field_150328_O;
                        pottedMeta = 6;
                        break;
                    }
                    case "pink_tulip": {
                        pottedBlock = Blocks.field_150328_O;
                        pottedMeta = 7;
                        break;
                    }
                    case "fern": {
                        pottedBlock = Blocks.field_150329_H;
                        pottedMeta = 2;
                        break;
                    }
                    case "cactus": {
                        pottedBlock = Blocks.field_150434_aF;
                        break;
                    }
                    case "dead_bush": {
                        pottedBlock = Blocks.field_150330_I;
                        break;
                    }
                    case "red_mushroom": {
                        pottedBlock = Blocks.field_150337_Q;
                        break;
                    }
                    case "brown_mushroom": {
                        pottedBlock = Blocks.field_150338_P;
                        break;
                    }
                    case "oak_sapling": {
                        pottedBlock = Blocks.field_150338_P;
                        break;
                    }
                    case "spruce_sapling": {
                        pottedBlock = Blocks.field_150338_P;
                        pottedMeta = 1;
                        break;
                    }
                    case "birch_sapling": {
                        pottedBlock = Blocks.field_150338_P;
                        pottedMeta = 2;
                        break;
                    }
                    case "jungle_sapling": {
                        pottedBlock = Blocks.field_150338_P;
                        pottedMeta = 3;
                        break;
                    }
                    case "acacia_sapling": {
                        pottedBlock = Blocks.field_150338_P;
                        pottedMeta = 4;
                        break;
                    }
                    case "dark_oak_sapling": {
                        pottedBlock = Blocks.field_150338_P;
                        pottedMeta = 5;
                        break;
                    }
                }
                if (pottedBlock != null) {
                    nbt = new NBTTagCompound();
                    nbt.func_74768_a("Item", Block.func_149682_b((Block)pottedBlock));
                    nbt.func_74768_a("Data", pottedMeta);
                }
            } else if (truncatedName.endsWith("skull") || truncatedName.endsWith("head")) {
                nbt = new NBTTagCompound();
                if (!truncatedName.contains("wall") && blockStates.containsKey("rotation")) {
                    nbt.func_74774_a("Rot", (byte)this.getRotationFromDir(Integer.parseInt(blockStates.get("rotation")), dir));
                }
                int type = 0;
                switch (truncatedName.replace("_head", "").replace("_skull", "").replace("_wall", "")) {
                    case "wither_skeleton": {
                        type = 1;
                        break;
                    }
                    case "zombie": {
                        type = 2;
                        break;
                    }
                    case "player": {
                        type = 3;
                        break;
                    }
                    case "creeper": {
                        type = 4;
                        break;
                    }
                }
                nbt.func_74774_a("SkullType", (byte)(type & 0xFF));
            }
        }
        if (nbt != null) {
            bsc.setCompound(nbt);
        }
        return bsc;
    }

    public int getMetaFromState(String blockName, Map<String, String> blockStates, ForgeDirection dir) {
        String truncatedName = blockName.substring(blockName.indexOf(":") + 1);
        if (blockStates.containsKey("axis")) {
            String axis = blockStates.get("axis");
            if (truncatedName.equals("quartz_pillar")) {
                switch (axis) {
                    case "y": {
                        return 2;
                    }
                    case "x": {
                        return dir == ForgeDirection.NORTH || dir == ForgeDirection.SOUTH ? 3 : 4;
                    }
                    case "z": {
                        return dir == ForgeDirection.NORTH || dir == ForgeDirection.SOUTH ? 4 : 3;
                    }
                }
            } else {
                switch (axis) {
                    case "y": {
                        return 0;
                    }
                    case "x": {
                        return dir == ForgeDirection.NORTH || dir == ForgeDirection.SOUTH ? 4 : 8;
                    }
                    case "z": {
                        return dir == ForgeDirection.NORTH || dir == ForgeDirection.SOUTH ? 8 : 4;
                    }
                }
            }
        } else {
            if (truncatedName.endsWith("torch") && Boolean.parseBoolean(blockStates.get("standing"))) {
                return 5;
            }
            if ((truncatedName.contains("skull") || truncatedName.contains("head")) && !truncatedName.contains("wall")) {
                return 1;
            }
            if (blockStates.containsKey("facing")) {
                String facing = blockStates.get("facing");
                if (truncatedName.endsWith("wall_torch") || truncatedName.endsWith("stairs")) {
                    int meta = 0;
                    if (truncatedName.endsWith("wall_torch")) {
                        meta = 1;
                    } else if ("top".equals(blockStates.get("half"))) {
                        meta = 4;
                    }
                    switch (facing) {
                        case "east": {
                            return meta + (dir == ForgeDirection.NORTH ? 0 : (dir == ForgeDirection.SOUTH ? 1 : (dir == ForgeDirection.WEST ? 2 : (dir == ForgeDirection.EAST ? 3 : 0))));
                        }
                        case "west": {
                            return meta + (dir == ForgeDirection.NORTH ? 1 : (dir == ForgeDirection.SOUTH ? 0 : (dir == ForgeDirection.WEST ? 3 : (dir == ForgeDirection.EAST ? 2 : 1))));
                        }
                        case "south": {
                            return meta + (dir == ForgeDirection.NORTH ? 2 : (dir == ForgeDirection.SOUTH ? 3 : (dir == ForgeDirection.WEST ? 0 : (dir == ForgeDirection.EAST ? 1 : 2))));
                        }
                        case "north": {
                            return meta + (dir == ForgeDirection.NORTH ? 3 : (dir == ForgeDirection.SOUTH ? 2 : (dir == ForgeDirection.WEST ? 1 : (dir == ForgeDirection.EAST ? 0 : 3))));
                        }
                    }
                } else if (truncatedName.equals("end_portal_frame")) {
                    int meta = 0;
                    if (Boolean.parseBoolean(blockStates.get("eye"))) {
                        meta = 4;
                    }
                    switch (facing) {
                        case "south": {
                            return meta + (dir == ForgeDirection.NORTH ? 0 : (dir == ForgeDirection.SOUTH ? 2 : (dir == ForgeDirection.WEST ? 3 : (dir == ForgeDirection.EAST ? 1 : 0))));
                        }
                        case "west": {
                            return meta + (dir == ForgeDirection.NORTH ? 1 : (dir == ForgeDirection.SOUTH ? 3 : (dir == ForgeDirection.WEST ? 2 : (dir == ForgeDirection.EAST ? 0 : 1))));
                        }
                        case "north": {
                            return meta + (dir == ForgeDirection.NORTH ? 2 : (dir == ForgeDirection.SOUTH ? 0 : (dir == ForgeDirection.WEST ? 1 : (dir == ForgeDirection.EAST ? 3 : 2))));
                        }
                        case "east": {
                            return meta + (dir == ForgeDirection.NORTH ? 3 : (dir == ForgeDirection.SOUTH ? 1 : (dir == ForgeDirection.WEST ? 0 : (dir == ForgeDirection.EAST ? 2 : 3))));
                        }
                    }
                } else if (truncatedName.endsWith("anvil")) {
                    switch (facing) {
                        case "north": {
                            return dir == ForgeDirection.NORTH ? 0 : (dir == ForgeDirection.SOUTH ? 2 : (dir == ForgeDirection.WEST ? 1 : (dir == ForgeDirection.EAST ? 3 : 0)));
                        }
                        case "east": {
                            return dir == ForgeDirection.NORTH ? 1 : (dir == ForgeDirection.SOUTH ? 3 : (dir == ForgeDirection.WEST ? 0 : (dir == ForgeDirection.EAST ? 2 : 1)));
                        }
                        case "south": {
                            return dir == ForgeDirection.NORTH ? 2 : (dir == ForgeDirection.SOUTH ? 0 : (dir == ForgeDirection.WEST ? 3 : (dir == ForgeDirection.EAST ? 1 : 2)));
                        }
                        case "west": {
                            return dir == ForgeDirection.NORTH ? 3 : (dir == ForgeDirection.SOUTH ? 1 : (dir == ForgeDirection.WEST ? 2 : (dir == ForgeDirection.EAST ? 0 : 3)));
                        }
                    }
                } else if (truncatedName.endsWith("trapdoor")) {
                    int meta = 0;
                    if ("top".equals(blockStates.get("half"))) {
                        meta += 8;
                    }
                    if (Boolean.parseBoolean(blockStates.get("open"))) {
                        meta += 4;
                    }
                    switch (facing) {
                        case "north": {
                            return meta + (dir == ForgeDirection.NORTH ? 0 : (dir == ForgeDirection.SOUTH ? 1 : (dir == ForgeDirection.WEST ? 2 : (dir == ForgeDirection.EAST ? 3 : 0))));
                        }
                        case "south": {
                            return meta + (dir == ForgeDirection.NORTH ? 1 : (dir == ForgeDirection.SOUTH ? 0 : (dir == ForgeDirection.WEST ? 3 : (dir == ForgeDirection.EAST ? 2 : 1))));
                        }
                        case "west": {
                            return meta + (dir == ForgeDirection.NORTH ? 2 : (dir == ForgeDirection.SOUTH ? 3 : (dir == ForgeDirection.WEST ? 0 : (dir == ForgeDirection.EAST ? 1 : 2))));
                        }
                        case "east": {
                            return meta + (dir == ForgeDirection.NORTH ? 3 : (dir == ForgeDirection.SOUTH ? 2 : (dir == ForgeDirection.WEST ? 1 : (dir == ForgeDirection.EAST ? 0 : 3))));
                        }
                    }
                } else if (truncatedName.endsWith("tripwire_hook")) {
                    int meta = 0;
                    if (Boolean.parseBoolean(blockStates.get("attached"))) {
                        meta += 4;
                    }
                    if (Boolean.parseBoolean(blockStates.get("powered"))) {
                        meta += 8;
                    }
                    switch (facing) {
                        case "south": {
                            return meta + (dir == ForgeDirection.NORTH ? 0 : (dir == ForgeDirection.SOUTH ? 2 : (dir == ForgeDirection.WEST ? 3 : (dir == ForgeDirection.EAST ? 1 : 0))));
                        }
                        case "west": {
                            return meta + (dir == ForgeDirection.NORTH ? 1 : (dir == ForgeDirection.SOUTH ? 3 : (dir == ForgeDirection.WEST ? 2 : (dir == ForgeDirection.EAST ? 0 : 1))));
                        }
                        case "north": {
                            return meta + (dir == ForgeDirection.NORTH ? 2 : (dir == ForgeDirection.SOUTH ? 0 : (dir == ForgeDirection.WEST ? 1 : (dir == ForgeDirection.EAST ? 3 : 2))));
                        }
                        case "east": {
                            return meta + (dir == ForgeDirection.NORTH ? 3 : (dir == ForgeDirection.SOUTH ? 1 : (dir == ForgeDirection.WEST ? 0 : (dir == ForgeDirection.EAST ? 2 : 3))));
                        }
                    }
                } else if (truncatedName.endsWith("door")) {
                    int meta = 0;
                    if ("upper".equals(blockStates.get("half"))) {
                        int rightMeta = dir == ForgeDirection.NORTH || dir == ForgeDirection.SOUTH ? 9 : 8;
                        int leftMeta = dir == ForgeDirection.NORTH || dir == ForgeDirection.SOUTH ? 8 : 9;
                        return "right".equals(blockStates.get("hinge")) ? rightMeta : leftMeta;
                    }
                    if (Boolean.parseBoolean(blockStates.get("open"))) {
                        meta += 4;
                    }
                    switch (facing) {
                        case "east": {
                            return meta + (dir == ForgeDirection.NORTH ? 0 : (dir == ForgeDirection.SOUTH ? 2 : (dir == ForgeDirection.WEST ? 1 : (dir == ForgeDirection.EAST ? 3 : 0))));
                        }
                        case "south": {
                            return meta + (dir == ForgeDirection.NORTH ? 1 : (dir == ForgeDirection.SOUTH ? 3 : (dir == ForgeDirection.WEST ? 0 : (dir == ForgeDirection.EAST ? 2 : 1))));
                        }
                        case "west": {
                            return meta + (dir == ForgeDirection.NORTH ? 2 : (dir == ForgeDirection.SOUTH ? 0 : (dir == ForgeDirection.WEST ? 3 : (dir == ForgeDirection.EAST ? 1 : 2))));
                        }
                        case "north": {
                            return meta + (dir == ForgeDirection.NORTH ? 3 : (dir == ForgeDirection.SOUTH ? 1 : (dir == ForgeDirection.WEST ? 2 : (dir == ForgeDirection.EAST ? 0 : 3))));
                        }
                    }
                } else if (truncatedName.endsWith("fence_gate")) {
                    int meta = 0;
                    if (Boolean.parseBoolean(blockStates.get("open"))) {
                        meta += 4;
                    }
                    switch (facing) {
                        case "south": {
                            return meta + (dir == ForgeDirection.NORTH ? 0 : (dir == ForgeDirection.SOUTH ? 2 : (dir == ForgeDirection.WEST ? 3 : (dir == ForgeDirection.EAST ? 1 : 0))));
                        }
                        case "west": {
                            return meta + (dir == ForgeDirection.NORTH ? 1 : (dir == ForgeDirection.SOUTH ? 3 : (dir == ForgeDirection.WEST ? 2 : (dir == ForgeDirection.EAST ? 0 : 1))));
                        }
                        case "north": {
                            return meta + (dir == ForgeDirection.NORTH ? 2 : (dir == ForgeDirection.SOUTH ? 0 : (dir == ForgeDirection.WEST ? 1 : (dir == ForgeDirection.EAST ? 3 : 2))));
                        }
                        case "east": {
                            return meta + (dir == ForgeDirection.NORTH ? 3 : (dir == ForgeDirection.SOUTH ? 1 : (dir == ForgeDirection.WEST ? 0 : (dir == ForgeDirection.EAST ? 2 : 3))));
                        }
                    }
                } else if (truncatedName.endsWith("bed")) {
                    int meta = 0;
                    if ("head".equals(blockStates.get("part"))) {
                        meta += 8;
                    }
                    switch (facing) {
                        case "south": {
                            return meta + (dir == ForgeDirection.NORTH ? 0 : (dir == ForgeDirection.SOUTH ? 2 : (dir == ForgeDirection.WEST ? 3 : (dir == ForgeDirection.EAST ? 1 : 0))));
                        }
                        case "west": {
                            return meta + (dir == ForgeDirection.NORTH ? 1 : (dir == ForgeDirection.SOUTH ? 3 : (dir == ForgeDirection.WEST ? 2 : (dir == ForgeDirection.EAST ? 0 : 1))));
                        }
                        case "north": {
                            return meta + (dir == ForgeDirection.NORTH ? 2 : (dir == ForgeDirection.SOUTH ? 0 : (dir == ForgeDirection.WEST ? 1 : (dir == ForgeDirection.EAST ? 3 : 2))));
                        }
                        case "east": {
                            return meta + (dir == ForgeDirection.NORTH ? 3 : (dir == ForgeDirection.SOUTH ? 1 : (dir == ForgeDirection.WEST ? 0 : (dir == ForgeDirection.EAST ? 2 : 3))));
                        }
                    }
                } else if (truncatedName.endsWith("repeater") || truncatedName.endsWith("comparator")) {
                    int meta = 0;
                    if (blockStates.containsKey("delay")) {
                        meta = 4 * (Integer.parseInt(blockStates.get("delay")) - 1);
                    }
                    if (truncatedName.endsWith("comparator")) {
                        if ("subtract".equals(blockStates.get("mode"))) {
                            meta += 4;
                        }
                        if (Boolean.parseBoolean(blockStates.get("powered"))) {
                            meta += 8;
                        }
                    }
                    switch (facing) {
                        case "south": {
                            return meta + (dir == ForgeDirection.NORTH ? 0 : (dir == ForgeDirection.SOUTH ? 2 : (dir == ForgeDirection.WEST ? 3 : (dir == ForgeDirection.EAST ? 1 : 0))));
                        }
                        case "west": {
                            return meta + (dir == ForgeDirection.NORTH ? 1 : (dir == ForgeDirection.SOUTH ? 3 : (dir == ForgeDirection.WEST ? 2 : (dir == ForgeDirection.EAST ? 0 : 1))));
                        }
                        case "north": {
                            return meta + (dir == ForgeDirection.NORTH ? 2 : (dir == ForgeDirection.SOUTH ? 0 : (dir == ForgeDirection.WEST ? 1 : (dir == ForgeDirection.EAST ? 3 : 2))));
                        }
                        case "east": {
                            return meta + (dir == ForgeDirection.NORTH ? 3 : (dir == ForgeDirection.SOUTH ? 1 : (dir == ForgeDirection.WEST ? 0 : (dir == ForgeDirection.EAST ? 2 : 3))));
                        }
                    }
                } else {
                    if (truncatedName.endsWith("button")) {
                        int n;
                        int meta = 0;
                        switch (facing) {
                            case "north": {
                                n = meta + (dir == ForgeDirection.NORTH ? 4 : (dir == ForgeDirection.SOUTH ? 3 : (dir == ForgeDirection.WEST ? 2 : (dir == ForgeDirection.EAST ? 1 : 0))));
                                break;
                            }
                            case "south": {
                                n = meta + (dir == ForgeDirection.NORTH ? 3 : (dir == ForgeDirection.SOUTH ? 4 : (dir == ForgeDirection.WEST ? 1 : (dir == ForgeDirection.EAST ? 2 : 0))));
                                break;
                            }
                            case "west": {
                                n = meta + (dir == ForgeDirection.NORTH ? 2 : (dir == ForgeDirection.SOUTH ? 1 : (dir == ForgeDirection.WEST ? 4 : (dir == ForgeDirection.EAST ? 3 : 0))));
                                break;
                            }
                            case "east": {
                                n = meta + (dir == ForgeDirection.NORTH ? 1 : (dir == ForgeDirection.SOUTH ? 2 : (dir == ForgeDirection.WEST ? 3 : (dir == ForgeDirection.EAST ? 4 : 0))));
                                break;
                            }
                            default: {
                                n = 0;
                            }
                        }
                        return n;
                    }
                    if (truncatedName.endsWith("pressure_plate")) {
                        if (Boolean.parseBoolean(blockStates.get("powered"))) {
                            return 1;
                        }
                    } else if (truncatedName.endsWith("vine")) {
                        switch (facing) {
                            case "south": {
                                return dir == ForgeDirection.NORTH ? 1 : (dir == ForgeDirection.SOUTH ? 4 : (dir == ForgeDirection.WEST ? 8 : (dir == ForgeDirection.EAST ? 2 : 0)));
                            }
                            case "west": {
                                return dir == ForgeDirection.NORTH ? 2 : (dir == ForgeDirection.SOUTH ? 8 : (dir == ForgeDirection.WEST ? 4 : (dir == ForgeDirection.EAST ? 1 : 0)));
                            }
                            case "north": {
                                return dir == ForgeDirection.NORTH ? 4 : (dir == ForgeDirection.SOUTH ? 1 : (dir == ForgeDirection.WEST ? 2 : (dir == ForgeDirection.EAST ? 8 : 0)));
                            }
                            case "east": {
                                return dir == ForgeDirection.NORTH ? 8 : (dir == ForgeDirection.SOUTH ? 2 : (dir == ForgeDirection.WEST ? 1 : (dir == ForgeDirection.EAST ? 4 : 0)));
                            }
                        }
                    } else {
                        switch (facing) {
                            case "down": {
                                return 0;
                            }
                            case "up": {
                                return 1;
                            }
                            case "north": {
                                return dir == ForgeDirection.NORTH ? 2 : (dir == ForgeDirection.SOUTH ? 3 : (dir == ForgeDirection.WEST ? 4 : (dir == ForgeDirection.EAST ? 5 : 0)));
                            }
                            case "south": {
                                return dir == ForgeDirection.NORTH ? 3 : (dir == ForgeDirection.SOUTH ? 2 : (dir == ForgeDirection.WEST ? 5 : (dir == ForgeDirection.EAST ? 4 : 0)));
                            }
                            case "west": {
                                return dir == ForgeDirection.NORTH ? 4 : (dir == ForgeDirection.SOUTH ? 5 : (dir == ForgeDirection.WEST ? 2 : (dir == ForgeDirection.EAST ? 3 : 0)));
                            }
                            case "east": {
                                return dir == ForgeDirection.NORTH ? 5 : (dir == ForgeDirection.SOUTH ? 4 : (dir == ForgeDirection.WEST ? 3 : (dir == ForgeDirection.EAST ? 2 : 0)));
                            }
                        }
                    }
                }
            } else if (blockStates.containsKey("stage") && (truncatedName.endsWith("sapling") || truncatedName.equals("mangrove_propagule"))) {
                if (blockStates.get("stage").equals("1")) {
                    return 8;
                }
            } else if (blockStates.containsKey("persistent")) {
                if (blockStates.get("persistent").equals("true")) {
                    return 4;
                }
            } else if (blockStates.containsKey("type") && truncatedName.contains("slab")) {
                if (blockStates.get("type").equals("top")) {
                    return 8;
                }
            } else if (blockStates.containsKey("half") && blockStates.get("half").equals("upper")) {
                if (truncatedName.equals("sunflower") || truncatedName.equals("lilac") || truncatedName.equals("tall_grass") || truncatedName.equals("large_fern") || truncatedName.equals("rose_bush") || truncatedName.equals("peony")) {
                    return 8;
                }
            } else if (blockStates.containsKey("shape") && truncatedName.endsWith("rail")) {
                int meta = 0;
                if (Boolean.parseBoolean(blockStates.get("powered"))) {
                    meta = 8;
                }
                switch (blockStates.get("shape")) {
                    case "north_south": {
                        return meta + (dir == ForgeDirection.NORTH || dir == ForgeDirection.SOUTH ? 0 : 1);
                    }
                    case "east_west": {
                        return meta + (dir == ForgeDirection.NORTH || dir == ForgeDirection.SOUTH ? 1 : 0);
                    }
                    case "ascending_east": {
                        return meta + (dir == ForgeDirection.NORTH ? 2 : (dir == ForgeDirection.SOUTH ? 3 : (dir == ForgeDirection.WEST ? 4 : (dir == ForgeDirection.EAST ? 5 : 0))));
                    }
                    case "ascending_west": {
                        return meta + (dir == ForgeDirection.NORTH ? 3 : (dir == ForgeDirection.SOUTH ? 2 : (dir == ForgeDirection.WEST ? 5 : (dir == ForgeDirection.EAST ? 4 : 0))));
                    }
                    case "ascending_north": {
                        return meta + (dir == ForgeDirection.NORTH ? 4 : (dir == ForgeDirection.SOUTH ? 5 : (dir == ForgeDirection.WEST ? 2 : (dir == ForgeDirection.EAST ? 3 : 0))));
                    }
                    case "ascending_south": {
                        return meta + (dir == ForgeDirection.NORTH ? 5 : (dir == ForgeDirection.SOUTH ? 4 : (dir == ForgeDirection.WEST ? 3 : (dir == ForgeDirection.EAST ? 2 : 0))));
                    }
                    case "south_east": {
                        return dir == ForgeDirection.NORTH ? 6 : (dir == ForgeDirection.SOUTH ? 7 : (dir == ForgeDirection.WEST ? 8 : (dir == ForgeDirection.EAST ? 9 : 0)));
                    }
                    case "south_west": {
                        return dir == ForgeDirection.NORTH ? 7 : (dir == ForgeDirection.SOUTH ? 6 : (dir == ForgeDirection.WEST ? 9 : (dir == ForgeDirection.EAST ? 8 : 0)));
                    }
                    case "north_west": {
                        return dir == ForgeDirection.NORTH ? 8 : (dir == ForgeDirection.SOUTH ? 9 : (dir == ForgeDirection.WEST ? 6 : (dir == ForgeDirection.EAST ? 7 : 0)));
                    }
                    case "north_east": {
                        return dir == ForgeDirection.NORTH ? 9 : (dir == ForgeDirection.SOUTH ? 8 : (dir == ForgeDirection.WEST ? 7 : (dir == ForgeDirection.EAST ? 6 : 0)));
                    }
                }
            } else {
                if (truncatedName.equals("tripwire")) {
                    int meta = 0;
                    meta |= Boolean.parseBoolean(blockStates.get("powered")) ? 1 : 0;
                    meta |= Boolean.parseBoolean(blockStates.get("attached")) ? 4 : 0;
                    return meta |= Boolean.parseBoolean(blockStates.get("disarmed")) ? 8 : 0;
                }
                if (truncatedName.equals("brewing_stand")) {
                    int meta = 0;
                    meta |= Boolean.parseBoolean(blockStates.get("has_bottle_0")) ? 1 : 0;
                    meta |= Boolean.parseBoolean(blockStates.get("has_bottle_1")) ? 2 : 0;
                    return meta |= Boolean.parseBoolean(blockStates.get("has_bottle_2")) ? 4 : 0;
                }
                if (truncatedName.endsWith("mushroom_block")) {
                    return this.getHugeMushroomMetaFromState(blockName, blockStates, dir);
                }
                if (blockStates.containsKey("layers")) {
                    return Integer.parseInt(blockStates.get("layers"));
                }
                if (blockStates.containsKey("power")) {
                    return Integer.parseInt(blockStates.get("power"));
                }
                if (blockStates.containsKey("level")) {
                    return Integer.parseInt(blockStates.get("level"));
                }
                if (blockStates.containsKey("age")) {
                    return Integer.parseInt(blockStates.get("age"));
                }
                if (blockStates.containsKey("rotation")) {
                    return this.getRotationFromDir(Integer.parseInt(blockStates.get("rotation")), dir);
                }
                if (blockStates.containsKey("moisture")) {
                    return Integer.parseInt(blockStates.get("moisture")) == 7 ? 1 : 0;
                }
            }
        }
        return 0;
    }

    public int getHugeMushroomMetaFromState(String blockName, Map<String, String> blockStates, ForgeDirection dir) {
        boolean up = Boolean.parseBoolean(blockStates.get("up"));
        boolean down = Boolean.parseBoolean(blockStates.get("down"));
        boolean north = Boolean.parseBoolean(blockStates.get("north"));
        boolean east = Boolean.parseBoolean(blockStates.get("east"));
        boolean south = Boolean.parseBoolean(blockStates.get("south"));
        boolean west = Boolean.parseBoolean(blockStates.get("west"));
        if (!(up || down || north || east || south || west)) {
            return 0;
        }
        if (up) {
            if (east) {
                if (north) {
                    return 3;
                }
                if (south) {
                    return 9;
                }
                return 6;
            }
            if (west) {
                if (north) {
                    return 1;
                }
                if (south) {
                    return 7;
                }
                return 4;
            }
            if (north) {
                return 2;
            }
            if (south) {
                return 8;
            }
            return 5;
        }
        return 14;
    }

    protected final boolean blockStatesStartWith(Map<String, String> blockStates, String string) {
        return blockStates.keySet().stream().anyMatch(stateName -> stateName.startsWith(string));
    }

    protected final boolean blockStatesEndWith(Map<String, String> blockStates, String string) {
        return blockStates.keySet().stream().anyMatch(stateName -> stateName.endsWith(string));
    }

    protected final boolean blockStatesContain(Map<String, String> blockStates, String string) {
        return blockStates.keySet().stream().anyMatch(stateName -> stateName.contains(string));
    }

    protected final int getRotationFromDir(int rotation, ForgeDirection dir) {
        int n;
        switch (dir) {
            case NORTH: {
                n = rotation;
                break;
            }
            case SOUTH: {
                n = (rotation + 8) % 16;
                break;
            }
            case EAST: {
                n = (4 - rotation) % 16;
                break;
            }
            case WEST: {
                n = (12 - rotation) % 16;
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    public ForgeDirection getItemFrameDirFromRotation(int rotation) {
        ForgeDirection forgeDirection;
        switch (rotation) {
            case 0: {
                forgeDirection = ForgeDirection.NORTH;
                break;
            }
            case 1: {
                forgeDirection = ForgeDirection.EAST;
                break;
            }
            case 2: {
                forgeDirection = ForgeDirection.SOUTH;
                break;
            }
            default: {
                forgeDirection = ForgeDirection.WEST;
            }
        }
        return forgeDirection;
    }

    public int getItemFrameRotationFromDir(ForgeDirection dir) {
        int n;
        switch (dir) {
            case NORTH: {
                n = 0;
                break;
            }
            case EAST: {
                n = 1;
                break;
            }
            case SOUTH: {
                n = 2;
                break;
            }
            default: {
                n = 3;
            }
        }
        return n;
    }

    public int getMetaFromStateWithSubtypeAdditions(String blockName, Map<String, String> blockStates, ForgeDirection dir) {
        int meta = this.getMetaFromState(blockName, blockStates, dir);
        if (blockName.startsWith("minecraft:")) {
            String truncatedName;
            switch (truncatedName = blockName.replace("minecraft:", "")) {
                case "coarse_dirt": {
                    meta = 1;
                    break;
                }
                case "podzol": {
                    meta = 2;
                    break;
                }
                case "spruce_planks": {
                    meta = 1;
                    break;
                }
                case "birch_planks": {
                    meta = 2;
                    break;
                }
                case "jungle_planks": {
                    meta = 3;
                    break;
                }
                case "acacia_planks": {
                    meta = 4;
                    break;
                }
                case "dark_oak_planks": {
                    meta = 5;
                    break;
                }
                case "oak_sapling": {
                    meta = 0;
                    if (this.getMetaFromState(truncatedName, blockStates, dir) <= 7) break;
                    meta += 8;
                    break;
                }
                case "spruce_sapling": {
                    meta = 1;
                    if (this.getMetaFromState(truncatedName, blockStates, dir) <= 7) break;
                    meta += 8;
                    break;
                }
                case "birch_sapling": {
                    meta = 2;
                    if (this.getMetaFromState(truncatedName, blockStates, dir) <= 7) break;
                    meta += 8;
                    break;
                }
                case "jungle_sapling": {
                    meta = 3;
                    if (this.getMetaFromState(truncatedName, blockStates, dir) <= 7) break;
                    meta += 8;
                    break;
                }
                case "acacia_sapling": {
                    meta = 4;
                    if (this.getMetaFromState(truncatedName, blockStates, dir) <= 7) break;
                    meta += 8;
                    break;
                }
                case "dark_oak_sapling": {
                    meta = 5;
                    if (this.getMetaFromState(truncatedName, blockStates, dir) <= 7) break;
                    meta += 8;
                    break;
                }
                case "red_sand": {
                    meta = 1;
                    break;
                }
                case "spruce_log": {
                    ++meta;
                    break;
                }
                case "birch_log": {
                    meta += 2;
                    break;
                }
                case "jungle_log": {
                    meta += 3;
                    break;
                }
                case "dark_oak_log": {
                    ++meta;
                    break;
                }
                case "spruce_leaves": {
                    ++meta;
                    break;
                }
                case "birch_leaves": {
                    meta += 2;
                    break;
                }
                case "jungle_leaves": {
                    meta += 3;
                    break;
                }
                case "dark_oak_leaves": {
                    ++meta;
                    break;
                }
                case "chiseled_sandstone": {
                    meta = 1;
                    break;
                }
                case "cut_sandstone": {
                    meta = 2;
                    break;
                }
                case "grass": {
                    meta = 1;
                    break;
                }
                case "fern": {
                    meta = 2;
                    break;
                }
                case "blue_orchid": {
                    meta = 1;
                    break;
                }
                case "allium": {
                    meta = 2;
                    break;
                }
                case "azure_bluet": {
                    meta = 3;
                    break;
                }
                case "red_tulip": {
                    meta = 4;
                    break;
                }
                case "orange_tulip": {
                    meta = 5;
                    break;
                }
                case "white_tulip": {
                    meta = 6;
                    break;
                }
                case "pink_tulip": {
                    meta = 7;
                    break;
                }
                case "oxeye_daisy": {
                    meta = 8;
                    break;
                }
                case "potted_blue_orchid": {
                    meta = 1;
                    break;
                }
                case "potted_allium": {
                    meta = 2;
                    break;
                }
                case "potted_azure_bluet": {
                    meta = 3;
                    break;
                }
                case "potted_oxeye_daisy": {
                    meta = 8;
                    break;
                }
                case "potted_red_tulip": {
                    meta = 4;
                    break;
                }
                case "potted_orange_tulip": {
                    meta = 5;
                    break;
                }
                case "potted_white_tulip": {
                    meta = 6;
                    break;
                }
                case "potted_pink_tulip": {
                    meta = 7;
                    break;
                }
                case "potted_fern": {
                    meta = 2;
                    break;
                }
                case "potted_spruce_sapling": {
                    meta = 1;
                    break;
                }
                case "potted_birch_sapling": {
                    meta = 2;
                    break;
                }
                case "potted_jungle_sapling": {
                    meta = 3;
                    break;
                }
                case "potted_acacia_sapling": {
                    meta = 4;
                    break;
                }
                case "potted_dark_oak_sapling": {
                    meta = 5;
                    break;
                }
                case "spruce_slab": {
                    ++meta;
                    break;
                }
                case "birch_slab": {
                    meta += 2;
                    break;
                }
                case "jungle_slab": {
                    meta += 3;
                    break;
                }
                case "acacia_slab": {
                    meta += 4;
                    break;
                }
                case "dark_oak_slab": {
                    meta += 5;
                    break;
                }
                case "sandstone_slab": {
                    ++meta;
                    break;
                }
                case "petrified_oak_slab": {
                    meta += 2;
                    break;
                }
                case "cobblestone_slab": {
                    meta += 3;
                    break;
                }
                case "brick_slab": {
                    meta += 4;
                    break;
                }
                case "stone_brick_slab": {
                    meta += 5;
                    break;
                }
                case "nether_brick_slab": {
                    meta += 6;
                    break;
                }
                case "quartz_slab": {
                    meta += 7;
                    break;
                }
                case "smooth_stone": {
                    meta = 8;
                    break;
                }
                case "smooth_sandstone": {
                    meta = 9;
                    break;
                }
                case "chipped_anvil": {
                    if (meta <= 1) break;
                    meta += 4;
                    break;
                }
                case "damaged_anvil": {
                    if (meta <= 1) break;
                    meta += 8;
                    break;
                }
                case "attached_pumpkin_stem": 
                case "attached_melon_stem": {
                    meta = 7;
                    break;
                }
                case "infested_cobblestone": {
                    meta = 1;
                    break;
                }
                case "infested_stone_bricks": {
                    meta = 2;
                    break;
                }
                case "infested_mossy_stone_bricks": {
                    meta = 3;
                    break;
                }
                case "infested_cracked_stone_bricks": {
                    meta = 4;
                    break;
                }
                case "infested_chiseled_stone_bricks": {
                    meta = 5;
                    break;
                }
                case "mossy_stone_bricks": {
                    meta = 1;
                    break;
                }
                case "cracked_stone_bricks": {
                    meta = 2;
                    break;
                }
                case "chiseled_stone_bricks": {
                    meta = 3;
                    break;
                }
                case "mushroom_stem": {
                    boolean up = Boolean.parseBoolean(blockStates.get("up"));
                    boolean down = Boolean.parseBoolean(blockStates.get("down"));
                    boolean north = Boolean.parseBoolean(blockStates.get("north"));
                    boolean east = Boolean.parseBoolean(blockStates.get("east"));
                    boolean south = Boolean.parseBoolean(blockStates.get("south"));
                    boolean west = Boolean.parseBoolean(blockStates.get("west"));
                    if (!north || !east || !south || !west) break;
                    if (up && down) {
                        return 15;
                    }
                    return 10;
                }
                case "mossy_cobblestone_wall": {
                    meta = 1;
                    break;
                }
                case "chiseled_quartz_block": {
                    meta = 1;
                    break;
                }
                case "lilac": {
                    if (!blockStates.containsKey("half") || !blockStates.get("half").equals("upper")) break;
                    meta = 1;
                    break;
                }
                case "tall_grass": {
                    if (!blockStates.containsKey("half") || !blockStates.get("half").equals("upper")) break;
                    meta = 2;
                    break;
                }
                case "large_fern": {
                    if (!blockStates.containsKey("half") || !blockStates.get("half").equals("upper")) break;
                    meta = 3;
                    break;
                }
                case "rose_bush": {
                    if (!blockStates.containsKey("half") || !blockStates.get("half").equals("upper")) break;
                    meta = 4;
                    break;
                }
                case "peony": {
                    if (!blockStates.containsKey("half") || !blockStates.get("half").equals("upper")) break;
                    meta = 5;
                    break;
                }
                case "orange_wool": 
                case "orange_carpet": 
                case "orange_stained_glass": 
                case "orange_stained_glass_pane": 
                case "orange_terracotta": {
                    meta = 1;
                    break;
                }
                case "magenta_wool": 
                case "magenta_carpet": 
                case "magenta_stained_glass": 
                case "magenta_stained_glass_pane": 
                case "magenta_terracotta": {
                    meta = 2;
                    break;
                }
                case "light_blue_wool": 
                case "light_blue_carpet": 
                case "light_blue_stained_glass": 
                case "light_blue_stained_glass_pane": 
                case "light_blue_terracotta": {
                    meta = 3;
                    break;
                }
                case "yellow_wool": 
                case "yellow_carpet": 
                case "yellow_stained_glass": 
                case "yellow_stained_glass_pane": 
                case "yellow_terracotta": {
                    meta = 4;
                    break;
                }
                case "lime_wool": 
                case "lime_carpet": 
                case "lime_stained_glass": 
                case "lime_stained_glass_pane": 
                case "lime_terracotta": {
                    meta = 5;
                    break;
                }
                case "pink_wool": 
                case "pink_carpet": 
                case "pink_stained_glass": 
                case "pink_stained_glass_pane": 
                case "pink_terracotta": {
                    meta = 6;
                    break;
                }
                case "gray_wool": 
                case "gray_carpet": 
                case "gray_stained_glass": 
                case "gray_stained_glass_pane": 
                case "gray_terracotta": {
                    meta = 7;
                    break;
                }
                case "light_gray_wool": 
                case "light_gray_carpet": 
                case "light_gray_stained_glass": 
                case "light_gray_stained_glass_pane": 
                case "light_gray_terracotta": {
                    meta = 8;
                    break;
                }
                case "cyan_wool": 
                case "cyan_carpet": 
                case "cyan_stained_glass": 
                case "cyan_stained_glass_pane": 
                case "cyan_terracotta": {
                    meta = 9;
                    break;
                }
                case "purple_wool": 
                case "purple_carpet": 
                case "purple_stained_glass": 
                case "purple_stained_glass_pane": 
                case "purple_terracotta": {
                    meta = 10;
                    break;
                }
                case "blue_wool": 
                case "blue_carpet": 
                case "blue_stained_glass": 
                case "blue_stained_glass_pane": 
                case "blue_terracotta": {
                    meta = 11;
                    break;
                }
                case "brown_wool": 
                case "brown_carpet": 
                case "brown_stained_glass": 
                case "brown_stained_glass_pane": 
                case "brown_terracotta": {
                    meta = 12;
                    break;
                }
                case "green_wool": 
                case "green_carpet": 
                case "green_stained_glass": 
                case "green_stained_glass_pane": 
                case "green_terracotta": {
                    meta = 13;
                    break;
                }
                case "red_wool": 
                case "red_carpet": 
                case "red_stained_glass": 
                case "red_stained_glass_pane": 
                case "red_terracotta": {
                    meta = 14;
                    break;
                }
                case "black_wool": 
                case "black_carpet": 
                case "black_stained_glass": 
                case "black_stained_glass_pane": 
                case "black_terracotta": {
                    meta = 15;
                    break;
                }
            }
        }
        return meta;
    }

    public Block getBlockFromNamespace(String blockName, Map<String, String> blockStates) {
        Block block;
        String truncatedName = blockName.substring(blockName.indexOf(":") + 1);
        if (blockName.startsWith("minecraft:")) {
            switch (truncatedName) {
                case "grass_block": {
                    return Blocks.field_150349_c;
                }
                case "coarse_dirt": 
                case "podzol": {
                    return Blocks.field_150346_d;
                }
                case "oak_planks": 
                case "spruce_planks": 
                case "birch_planks": 
                case "jungle_planks": 
                case "acacia_planks": 
                case "dark_oak_planks": {
                    return Blocks.field_150344_f;
                }
                case "red_sand": {
                    return Blocks.field_150354_m;
                }
                case "oak_log": 
                case "spruce_log": 
                case "birch_log": 
                case "jungle_log": {
                    return Blocks.field_150364_r;
                }
                case "acacia_log": 
                case "dark_oak_log": {
                    return Blocks.field_150363_s;
                }
                case "oak_leaves": 
                case "spruce_leaves": 
                case "birch_leaves": 
                case "jungle_leaves": {
                    return Blocks.field_150362_t;
                }
                case "acacia_leaves": 
                case "dark_oak_leaves": {
                    return Blocks.field_150361_u;
                }
                case "chiseled_sandstone": 
                case "cut_sandstone": {
                    return Blocks.field_150322_A;
                }
                case "note_block": {
                    return Blocks.field_150323_B;
                }
                case "powered_rail": {
                    return Blocks.field_150318_D;
                }
                case "cobweb": {
                    return Blocks.field_150321_G;
                }
                case "grass": 
                case "fern": {
                    return Blocks.field_150329_H;
                }
                case "dead_bush": {
                    return Blocks.field_150330_I;
                }
                case "dandelion": {
                    return Blocks.field_150327_N;
                }
                case "poppy": 
                case "blue_orchid": 
                case "allium": 
                case "azure_bluet": 
                case "red_tulip": 
                case "orange_tulip": 
                case "white_tulip": 
                case "pink_tulip": 
                case "oxeye_daisy": {
                    return Blocks.field_150328_O;
                }
                case "oak_slab": 
                case "birch_slab": 
                case "spruce_slab": 
                case "jungle_slab": 
                case "acacia_slab": 
                case "dark_oak_slab": {
                    if (blockStates.containsKey("type") && blockStates.get("type").equals("double")) {
                        return Blocks.field_150373_bw;
                    }
                    return Blocks.field_150376_bx;
                }
                case "smooth_stone_slab": 
                case "sandstone_slab": 
                case "petrified_oak_slab": 
                case "cobblestone_slab": 
                case "brick_slab": 
                case "stone_brick_slab": 
                case "nether_brick_slab": 
                case "quartz_slab": {
                    if (blockStates.containsKey("type") && blockStates.get("type").equals("double")) {
                        return Blocks.field_150334_T;
                    }
                    return Blocks.field_150333_U;
                }
                case "smooth_stone": 
                case "smooth_sandstone": {
                    return Blocks.field_150334_T;
                }
                case "bricks": {
                    return Blocks.field_150336_V;
                }
                case "spawner": {
                    return Blocks.field_150474_ac;
                }
                case "furnace": {
                    if (!Boolean.parseBoolean(blockStates.get("lit"))) break;
                    return Blocks.field_150460_al;
                }
                case "cobblestone_stairs": {
                    return Blocks.field_150446_ar;
                }
                case "redstone_ore": {
                    if (Boolean.parseBoolean(blockStates.get("lit"))) {
                        return Blocks.field_150439_ay;
                    }
                }
                case "wall_torch": {
                    return Blocks.field_150478_aa;
                }
                case "redstone_wall_torch": 
                case "redstone_torch": {
                    if (!Boolean.parseBoolean(blockStates.get("lit"))) {
                        return Blocks.field_150437_az;
                    }
                    return Blocks.field_150429_aA;
                }
                case "snow": {
                    return Blocks.field_150431_aC;
                }
                case "snow_block": {
                    return Blocks.field_150433_aE;
                }
                case "carved_pumpkin": {
                    return Blocks.field_150423_aK;
                }
                case "jack_o_lantern": {
                    return Blocks.field_150428_aP;
                }
                case "infested_stone": 
                case "infested_cobblestone": 
                case "infested_stone_bricks": 
                case "infested_mossy_stone_bricks": 
                case "infested_cracked_stone_bricks": 
                case "infested_chiseled_stone_bricks": {
                    return Blocks.field_150418_aU;
                }
                case "stone_bricks": 
                case "mossy_stone_bricks": 
                case "cracked_stone_bricks": 
                case "chiseled_stone_bricks": {
                    return Blocks.field_150417_aV;
                }
                case "mushroom_stem": {
                    return Blocks.field_150419_aX;
                }
                case "melon": {
                    return Blocks.field_150440_ba;
                }
                case "lily_pad": {
                    return Blocks.field_150392_bi;
                }
                case "nether_bricks": {
                    return Blocks.field_150385_bj;
                }
                case "redstone_lamp": {
                    if (Boolean.parseBoolean(blockStates.get("lit"))) {
                        return Blocks.field_150374_bv;
                    }
                }
                case "mossy_cobblestone_wall": {
                    return Blocks.field_150463_bK;
                }
                case "daylight_detector": {
                    if (Boolean.parseBoolean(blockStates.get("inverted"))) {
                        return Blocks.field_150348_b;
                    }
                    return Blocks.field_150453_bW;
                }
                case "nether_quartz_ore": {
                    return Blocks.field_150449_bY;
                }
                case "chiseled_quartz_block": 
                case "quartz_pillar": {
                    return Blocks.field_150371_ca;
                }
                case "terracotta": {
                    return Blocks.field_150405_ch;
                }
                case "sunflower": 
                case "lilac": 
                case "tall_grass": 
                case "large_fern": 
                case "rose_bush": 
                case "peony": {
                    return Blocks.field_150398_cm;
                }
                case "repeater": {
                    if (Boolean.parseBoolean(blockStates.get("powered"))) {
                        return Blocks.field_150416_aS;
                    }
                    return Blocks.field_150413_aR;
                }
                case "comparator": {
                    if (Boolean.parseBoolean(blockStates.get("powered"))) {
                        return Blocks.field_150455_bV;
                    }
                    return Blocks.field_150441_bU;
                }
                case "skeleton_skull": 
                case "skeleton_wall_skull": 
                case "wither_skeleton_skull": 
                case "wither_skeleton_wall_skull": 
                case "zombie_head": 
                case "zombie_wall_head": 
                case "player_head": 
                case "player_wall_head": 
                case "creeper_head": 
                case "creeper_wall_head": {
                    return Blocks.field_150465_bP;
                }
                case "attached_pumpkin_stem": {
                    return Blocks.field_150393_bb;
                }
                case "attached_melon_stem": {
                    return Blocks.field_150394_bc;
                }
                case "potted_poppy": 
                case "potted_dandelion": 
                case "potted_blue_orchid": 
                case "potted_allium": 
                case "potted_azure_bluet": 
                case "potted_oxeye_daisy": 
                case "potted_red_tulip": 
                case "potted_orange_tulip": 
                case "potted_white_tulip": 
                case "potted_pink_tulip": 
                case "potted_fern": 
                case "potted_cactus": 
                case "potted_dead_bush": 
                case "potted_red_mushroom": 
                case "potted_brown_mushroom": 
                case "potted_oak_sapling": 
                case "potted_spruce_sapling": 
                case "potted_birch_sapling": 
                case "potted_jungle_sapling": 
                case "potted_acacia_sapling": 
                case "potted_dark_oak_sapling": {
                    return Blocks.field_150457_bL;
                }
                case "oak_pressure_plate": {
                    return Blocks.field_150452_aw;
                }
                case "oak_fence": {
                    return Blocks.field_150422_aJ;
                }
                case "oak_trapdoor": {
                    return Blocks.field_150415_aT;
                }
                case "oak_fence_gate": {
                    return Blocks.field_150396_be;
                }
                case "oak_button": {
                    return Blocks.field_150471_bO;
                }
                case "oak_door": {
                    return Blocks.field_150466_ao;
                }
                case "oak_sign": {
                    return Blocks.field_150472_an;
                }
                case "oak_wall_sign": {
                    return Blocks.field_150444_as;
                }
                case "red_bed": {
                    return Blocks.field_150324_C;
                }
                case "white_wool": 
                case "orange_wool": 
                case "magenta_wool": 
                case "light_blue_wool": 
                case "yellow_wool": 
                case "lime_wool": 
                case "pink_wool": 
                case "gray_wool": 
                case "light_gray_wool": 
                case "cyan_wool": 
                case "purple_wool": 
                case "blue_wool": 
                case "brown_wool": 
                case "green_wool": 
                case "red_wool": 
                case "black_wool": {
                    return Blocks.field_150325_L;
                }
                case "white_carpet": 
                case "orange_carpet": 
                case "magenta_carpet": 
                case "light_blue_carpet": 
                case "yellow_carpet": 
                case "lime_carpet": 
                case "pink_carpet": 
                case "gray_carpet": 
                case "light_gray_carpet": 
                case "cyan_carpet": 
                case "purple_carpet": 
                case "blue_carpet": 
                case "brown_carpet": 
                case "green_carpet": 
                case "red_carpet": 
                case "black_carpet": {
                    return Blocks.field_150404_cg;
                }
                case "white_stained_glass": 
                case "orange_stained_glass": 
                case "magenta_stained_glass": 
                case "light_blue_stained_glass": 
                case "yellow_stained_glass": 
                case "lime_stained_glass": 
                case "pink_stained_glass": 
                case "gray_stained_glass": 
                case "light_gray_stained_glass": 
                case "cyan_stained_glass": 
                case "purple_stained_glass": 
                case "blue_stained_glass": 
                case "brown_stained_glass": 
                case "green_stained_glass": 
                case "red_stained_glass": 
                case "black_stained_glass": {
                    return Blocks.field_150399_cn;
                }
                case "white_stained_glass_pane": 
                case "orange_stained_glass_pane": 
                case "magenta_stained_glass_pane": 
                case "light_blue_stained_glass_pane": 
                case "yellow_stained_glass_pane": 
                case "lime_stained_glass_pane": 
                case "pink_stained_glass_pane": 
                case "gray_stained_glass_pane": 
                case "light_gray_stained_glass_pane": 
                case "cyan_stained_glass_pane": 
                case "purple_stained_glass_pane": 
                case "blue_stained_glass_pane": 
                case "brown_stained_glass_pane": 
                case "green_stained_glass_pane": 
                case "red_stained_glass_pane": 
                case "black_stained_glass_pane": {
                    return Blocks.field_150397_co;
                }
                case "white_terracotta": 
                case "orange_terracotta": 
                case "magenta_terracotta": 
                case "light_blue_terracotta": 
                case "yellow_terracotta": 
                case "lime_terracotta": 
                case "pink_terracotta": 
                case "gray_terracotta": 
                case "light_gray_terracotta": 
                case "cyan_terracotta": 
                case "purple_terracotta": 
                case "blue_terracotta": 
                case "brown_terracotta": 
                case "green_terracotta": 
                case "red_terracotta": 
                case "black_terracotta": {
                    return Blocks.field_150406_ce;
                }
            }
        }
        return (block = GameRegistry.findBlock((String)blockName.substring(0, blockName.indexOf(":")), (String)truncatedName)) == null ? Blocks.field_150348_b : block;
    }

    public Pair<Item, Integer> getItemAndMetadataFromNamespace(String itemName) {
        return new ImmutablePair((Object)Items.field_151078_bh, (Object)0);
    }
}

