/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.world.generate.feature;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import ganymedes01.etfuturum.ModBlocks;
import ganymedes01.etfuturum.api.mappings.RegistryMapping;
import ganymedes01.etfuturum.core.utils.Utils;
import ganymedes01.etfuturum.core.utils.helpers.BlockPos;
import ganymedes01.etfuturum.core.utils.helpers.DoublePerlinNoiseSampler;
import ganymedes01.etfuturum.core.utils.helpers.Vec3i;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.apache.commons.lang3.tuple.Pair;

public class WorldGenGeode
extends WorldGenerator {
    private final int minGenOffset;
    private final int maxGenOffset;
    private final int invalidBlocksThreshold;
    private final int[] distributionPoints;
    private final int[] outerWallDistance;
    private final double filling;
    private final double innerLayer;
    private final double middleLayer;
    private final double outerLayer;
    private final int[] pointOffset;
    private final double generateCrackChance;
    private final double baseCrackSize;
    private final int crackPointOffset;
    private final double noiseMultiplier;
    private final double buddingAmethystChance;
    private final double usePotentialPlacementsChance;
    private final RegistryMapping<Block> outerBlock;
    private final RegistryMapping<Block> middleBlock;
    private final List<Block> budBlocks;
    private final Block innerBlock;
    private final Block innerBuddingBlock;

    public WorldGenGeode(RegistryMapping<Block> outerBlock, RegistryMapping<Block> middleBlock, Block innerBlock, Block innerBuddingBlock, Block bud1, Block bud2) {
        this(-16, 16, 1, new int[]{3, 4}, new int[]{4, 5, 6}, 1.7, 2.2, 3.2, 4.2, new int[]{1, 2}, 0.95, 2.0, 2, 0.05, 0.083, 0.35, outerBlock, middleBlock, innerBlock, innerBuddingBlock, bud1, bud2);
    }

    public WorldGenGeode(RegistryMapping<Block> outerBlock, RegistryMapping<Block> middleBlock) {
        this(outerBlock, middleBlock, ModBlocks.AMETHYST_BLOCK.get(), ModBlocks.BUDDING_AMETHYST.get(), ModBlocks.AMETHYST_CLUSTER_1.get(), ModBlocks.AMETHYST_CLUSTER_2.get());
    }

    private WorldGenGeode(int minOffset, int maxOffset, int invalidMax, int[] distPoints, int[] outerWallDist, double fill, double inner, double middle, double outer, int[] pointOff, double crackChance, double baseCrack, int crackPointOff, double noiseAmp, double budChance, double potentialPlaceChance, RegistryMapping<Block> outerBlock, RegistryMapping<Block> middleBlock, Block innerBlock, Block innerBuddingBlock, Block bud1, Block bud2) {
        this.outerBlock = outerBlock;
        this.middleBlock = middleBlock;
        this.innerBlock = innerBlock;
        this.innerBuddingBlock = innerBuddingBlock;
        this.budBlocks = ImmutableList.of((Object)bud1, (Object)bud2);
        this.minGenOffset = minOffset;
        this.maxGenOffset = maxOffset;
        this.invalidBlocksThreshold = invalidMax;
        this.distributionPoints = distPoints;
        this.outerWallDistance = outerWallDist;
        this.filling = fill;
        this.innerLayer = inner;
        this.middleLayer = middle;
        this.outerLayer = outer;
        this.pointOffset = pointOff;
        this.generateCrackChance = crackChance;
        this.baseCrackSize = baseCrack;
        this.crackPointOffset = crackPointOff;
        this.noiseMultiplier = noiseAmp;
        this.buddingAmethystChance = budChance;
        this.usePotentialPlacementsChance = potentialPlaceChance;
    }

    protected boolean isInvalidCorner(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return block.func_149688_o() != Material.field_151576_e || !block.func_149662_c();
    }

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        int s;
        BlockPos blockPos = new BlockPos(x, y, z);
        LinkedList list = Lists.newLinkedList();
        int distPoint = Utils.getRandom(this.distributionPoints, random);
        DoublePerlinNoiseSampler doublePerlinNoiseSampler = DoublePerlinNoiseSampler.create(random, -4, 1.0);
        LinkedList list2 = Lists.newLinkedList();
        double outerWallMaxDiv = (double)distPoint / (double)this.outerWallDistance[this.outerWallDistance.length - 1];
        double fillingSqrt = 1.0 / Math.sqrt(this.filling);
        double innerLayerSqrt = 1.0 / Math.sqrt(this.innerLayer + outerWallMaxDiv);
        double middleLayerSqrt = 1.0 / Math.sqrt(this.middleLayer + outerWallMaxDiv);
        double outerLayerSqrt = 1.0 / Math.sqrt(this.outerLayer + outerWallMaxDiv);
        double crackSize = 1.0 / Math.sqrt(this.baseCrackSize + random.nextDouble() / 2.0 + (distPoint > 3 ? outerWallMaxDiv : 0.0));
        boolean generateCrack = (double)random.nextFloat() < this.generateCrackChance;
        int m = 0;
        for (int r = 0; r < distPoint; ++r) {
            int q;
            int p;
            s = Utils.getRandom(this.outerWallDistance, random);
            BlockPos blockPos6 = blockPos.add(s, p = Utils.getRandom(this.outerWallDistance, random), q = Utils.getRandom(this.outerWallDistance, random));
            if (this.isInvalidCorner(world, blockPos6.getX(), blockPos6.getY(), blockPos6.getZ()) && ++m > this.invalidBlocksThreshold) {
                return false;
            }
            list.add(Pair.of((Object)blockPos6, (Object)Utils.getRandom(this.pointOffset, random)));
        }
        if (generateCrack) {
            s = distPoint * 2 + 1;
            switch (random.nextInt(4)) {
                case 0: {
                    list2.add(blockPos.add(s, 7, 0));
                    list2.add(blockPos.add(s, 5, 0));
                    list2.add(blockPos.add(s, 1, 0));
                    break;
                }
                case 1: {
                    list2.add(blockPos.add(0, 7, s));
                    list2.add(blockPos.add(0, 5, s));
                    list2.add(blockPos.add(0, 1, s));
                    break;
                }
                case 2: {
                    list2.add(blockPos.add(s, 7, s));
                    list2.add(blockPos.add(s, 5, s));
                    list2.add(blockPos.add(s, 1, s));
                    break;
                }
                case 3: {
                    list2.add(blockPos.add(0, 7, 0));
                    list2.add(blockPos.add(0, 5, 0));
                    list2.add(blockPos.add(0, 1, 0));
                }
            }
        }
        ArrayList buddingList = Lists.newArrayList();
        Iterator<BlockPos> var48 = BlockPos.iterate(blockPos.add(this.minGenOffset, this.minGenOffset, this.minGenOffset), blockPos.add(this.maxGenOffset, this.maxGenOffset, this.maxGenOffset)).iterator();
        while (true) {
            if (!var48.hasNext()) {
                block8: for (BlockPos buddingPos : buddingList) {
                    EnumFacing[] directions;
                    Block budBlock = Utils.getRandom(this.budBlocks, random);
                    for (EnumFacing budFacing : directions = Utils.ENUM_FACING_VALUES) {
                        BlockPos budPos = buddingPos.offset(budFacing);
                        if (!world.func_147437_c(budPos.getX(), budPos.getY(), budPos.getZ())) continue;
                        world.func_147465_d(budPos.getX(), budPos.getY(), budPos.getZ(), budBlock, (random.nextBoolean() ? 0 : 6) + budFacing.ordinal(), 2);
                        continue block8;
                    }
                }
                return true;
            }
            BlockPos blockPos3 = var48.next();
            double t = doublePerlinNoiseSampler.sample(blockPos3.getX(), blockPos3.getY(), blockPos3.getZ()) * this.noiseMultiplier;
            double currentLayerSqrt = 0.0;
            double v = 0.0;
            for (Pair pair : list) {
                currentLayerSqrt += Utils.fastInverseSqrt(blockPos3.getSquaredDistance((Vec3i)pair.getLeft()) + (double)((Integer)pair.getRight()).intValue()) + t;
            }
            for (BlockPos blockPos4 : list2) {
                v += Utils.fastInverseSqrt(blockPos3.getSquaredDistance(blockPos4) + (double)this.crackPointOffset) + t;
            }
            if (currentLayerSqrt < outerLayerSqrt || world.func_147439_a(blockPos3.getX(), blockPos3.getY(), blockPos3.getZ()).func_149712_f(world, blockPos3.getX(), blockPos3.getY(), blockPos3.getZ()) == -1.0f) continue;
            if (generateCrack && v >= crackSize && currentLayerSqrt < fillingSqrt) {
                world.func_147468_f(blockPos3.getX(), blockPos3.getY(), blockPos3.getZ());
                continue;
            }
            if (currentLayerSqrt >= fillingSqrt) {
                world.func_147468_f(blockPos3.getX(), blockPos3.getY(), blockPos3.getZ());
                continue;
            }
            if (currentLayerSqrt >= innerLayerSqrt) {
                boolean bl2;
                boolean bl = bl2 = (double)random.nextFloat() < this.buddingAmethystChance;
                if (bl2) {
                    world.func_147449_b(blockPos3.getX(), blockPos3.getY(), blockPos3.getZ(), this.innerBuddingBlock);
                } else {
                    world.func_147449_b(blockPos3.getX(), blockPos3.getY(), blockPos3.getZ(), this.innerBlock);
                }
                if (!bl2 || !((double)random.nextFloat() < this.usePotentialPlacementsChance)) continue;
                buddingList.add(new BlockPos((Vec3i)blockPos3));
                continue;
            }
            if (currentLayerSqrt >= middleLayerSqrt) {
                world.func_147465_d(blockPos3.getX(), blockPos3.getY(), blockPos3.getZ(), this.middleBlock.getObject(), this.middleBlock.getMeta(), 2);
                continue;
            }
            if (!(currentLayerSqrt >= outerLayerSqrt)) continue;
            world.func_147465_d(blockPos3.getX(), blockPos3.getY(), blockPos3.getZ(), this.outerBlock.getObject(), this.outerBlock.getMeta(), 2);
        }
    }
}

