/*
 * Decompiled with CFR 0.152.
 */
package makamys.neodymium.command;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import makamys.neodymium.Compat;
import makamys.neodymium.Neodymium;
import makamys.neodymium.command.ISubCommand;
import makamys.neodymium.util.ChatUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.event.ClickEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.ClientCommandHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Mouse;

public class NeodymiumCommand
extends CommandBase {
    public static final EnumChatFormatting HELP_COLOR = EnumChatFormatting.BLUE;
    public static final EnumChatFormatting HELP_USAGE_COLOR = EnumChatFormatting.YELLOW;
    public static final EnumChatFormatting HELP_WARNING_COLOR = EnumChatFormatting.YELLOW;
    public static final EnumChatFormatting HELP_EMPHASIS_COLOR = EnumChatFormatting.DARK_AQUA;
    public static final EnumChatFormatting ERROR_COLOR = EnumChatFormatting.RED;
    private static Map<String, ISubCommand> subCommands = new HashMap<String, ISubCommand>();

    public static void init() {
        ClientCommandHandler.instance.func_71560_a((ICommand)new NeodymiumCommand());
        NeodymiumCommand.registerSubCommand("status", new StatusCommand());
        NeodymiumCommand.registerSubCommand("disable_advanced_opengl", new DisableAdvancedOpenGLCommand());
    }

    public static void registerSubCommand(String key, ISubCommand command) {
        subCommands.put(key, command);
    }

    public String func_71517_b() {
        return "neodymium";
    }

    public String func_71518_a(ICommandSender sender) {
        return "";
    }

    public int func_82362_a() {
        return 0;
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        ISubCommand subCommand;
        if (args.length > 0 && (subCommand = subCommands.get(args[0])) != null) {
            subCommand.processCommand(sender, args);
            return;
        }
        throw new WrongUsageException(this.func_71517_b() + " <" + String.join((CharSequence)"|", this.getNonSecretSubCommands()) + ">", new Object[0]);
    }

    private String[] getNonSecretSubCommands() {
        return (String[])subCommands.entrySet().stream().filter(e -> !((ISubCommand)e.getValue()).isSecret()).map(e -> (String)e.getKey()).toArray(String[]::new);
    }

    public static void addChatMessage(ICommandSender sender, String text) {
        sender.func_145747_a((IChatComponent)new ChatComponentText(text));
    }

    public static void addColoredChatMessage(ICommandSender sender, String text, EnumChatFormatting color) {
        NeodymiumCommand.addColoredChatMessage(sender, text, color, null);
    }

    public static void addColoredChatMessage(ICommandSender sender, String text, EnumChatFormatting color, Consumer<ChatComponentText> fixup) {
        ChatComponentText msg = new ChatComponentText(text);
        msg.func_150256_b().func_150238_a(color);
        if (fixup != null) {
            fixup.accept(msg);
        }
        sender.func_145747_a((IChatComponent)msg);
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        return args.length == 1 ? NeodymiumCommand.func_71530_a((String[])args, (String[])this.getNonSecretSubCommands()) : null;
    }

    public static class DisableAdvancedOpenGLCommand
    implements ISubCommand {
        @Override
        public void processCommand(ICommandSender sender, String[] args) {
            Minecraft mc = Minecraft.func_71410_x();
            if (Compat.disableAdvancedOpenGL()) {
                mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("gui.button.press"), (float)1.0f));
                ChatUtil.showNeoChatMessage(EnumChatFormatting.AQUA + "Disabled Advanced OpenGL.", ChatUtil.MessageVerbosity.INFO);
                mc.field_71438_f.func_72712_a();
            } else {
                float x = (float)Mouse.getX() / (float)Minecraft.func_71410_x().field_71443_c;
                mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)new ResourceLocation("note.bass"), (float)(0.7f + x * 0.2f)));
            }
        }

        @Override
        public boolean isSecret() {
            return true;
        }
    }

    public static class StatusCommand
    implements ISubCommand {
        @Override
        public void processCommand(ICommandSender sender, String[] args) {
            if (Neodymium.renderer != null) {
                List<String> text = Neodymium.renderer.getDebugText(true);
                StatusCommand.addChatMessages(sender, text);
            }
            Pair<List<Compat.Warning>, List<Compat.Warning>> allWarns = Neodymium.showCompatStatus(true);
            List warns = (List)allWarns.getLeft();
            List criticalWarns = (List)allWarns.getRight();
            for (Compat.Warning line : warns) {
                this.addColoredChatMessageWithAction(sender, "* " + line.text, HELP_WARNING_COLOR, line.chatAction);
            }
            for (Compat.Warning line : criticalWarns) {
                this.addColoredChatMessageWithAction(sender, "* " + line.text, ERROR_COLOR, line.chatAction);
            }
        }

        private void addColoredChatMessageWithAction(ICommandSender sender, String text, EnumChatFormatting color, String command) {
            ChatComponentText msg = new ChatComponentText(text);
            msg.func_150256_b().func_150238_a(color);
            if (command != null) {
                msg.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command));
            }
            sender.func_145747_a((IChatComponent)msg);
        }

        private static void addChatMessages(ICommandSender sender, Collection<String> messages) {
            for (String line : messages) {
                sender.func_145747_a((IChatComponent)new ChatComponentText(line));
            }
        }
    }
}

