/*
 * Decompiled with CFR 0.152.
 */
package makamys.neodymium.mixin;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import makamys.neodymium.Compat;
import makamys.neodymium.Neodymium;
import makamys.neodymium.ducks.NeodymiumTessellator;
import makamys.neodymium.ducks.NeodymiumWorldRenderer;
import makamys.neodymium.renderer.ChunkMesh;
import makamys.neodymium.renderer.NeoRenderer;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.entity.EntityLivingBase;
import org.lwjgl.opengl.GL11;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldRenderer.class})
public abstract class MixinWorldRenderer
implements NeodymiumWorldRenderer {
    @Unique
    private boolean nd$savedDrawnStatus;
    @Unique
    private List<ChunkMesh> nd$chunkMeshes;
    @Unique
    private boolean nd$renderPassSuppressed;
    @Shadow
    public boolean field_78927_l;
    @Shadow
    public boolean[] field_78928_m;

    @Override
    public void nd$suppressRenderPasses(boolean suppressed) {
        this.nd$renderPassSuppressed = suppressed;
    }

    @Override
    public List<ChunkMesh> nd$getChunkMeshes() {
        return this.nd$chunkMeshes;
    }

    @Override
    public ChunkMesh nd$beginRenderPass(int pass) {
        if (Neodymium.isActive() && !this.nd$renderPassSuppressed) {
            ChunkMesh cm = new ChunkMesh((WorldRenderer)this, pass);
            ((NeodymiumTessellator)Compat.tessellator()).nd$setCaptureTarget(cm);
            return cm;
        }
        return null;
    }

    @Override
    public void nd$endRenderPass(ChunkMesh chunkMesh) {
        if (Neodymium.isActive() && !this.nd$renderPassSuppressed) {
            if (chunkMesh != null) {
                chunkMesh.finishConstruction();
            }
            ((NeodymiumTessellator)Compat.tessellator()).nd$setCaptureTarget(null);
        }
    }

    @Override
    public boolean nd$isDrawn() {
        return !this.field_78928_m[0] || !this.field_78928_m[1];
    }

    @Unique
    private void nd$reset(boolean sort) {
        this.nd$saveDrawnStatus();
        if (Neodymium.isActive()) {
            if (this.nd$chunkMeshes != null) {
                Collections.fill(this.nd$chunkMeshes, null);
            } else {
                this.nd$chunkMeshes = Lists.newArrayList((Object[])new ChunkMesh[]{null, null});
            }
        }
    }

    @Unique
    private void nd$postUpdateRenderer(boolean sort) {
        this.nd$notifyIfDrawnStatusChanged();
        if (Neodymium.isActive() && this.nd$chunkMeshes != null) {
            Neodymium.renderer.onWorldRendererPost((WorldRenderer)this, sort);
            Collections.fill(this.nd$chunkMeshes, null);
        }
    }

    @Unique
    private void nd$saveDrawnStatus() {
        this.nd$savedDrawnStatus = this.nd$isDrawn();
    }

    @Unique
    private void nd$notifyIfDrawnStatusChanged() {
        boolean drawn = this.nd$isDrawn();
        if (Neodymium.isActive() && drawn != this.nd$savedDrawnStatus) {
            Neodymium.renderer.onWorldRendererChanged((WorldRenderer)this, drawn ? NeoRenderer.WorldRendererChange.VISIBLE : NeoRenderer.WorldRendererChange.INVISIBLE);
        }
    }

    @Inject(method={"updateRenderer"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/WorldRenderer;needsUpdate:Z", ordinal=0)}, require=1)
    private void preUpdateRenderer(CallbackInfo ci) {
        this.nd$reset(false);
    }

    @Inject(method={"updateRendererSort"}, at={@At(value="HEAD")}, require=1)
    private void preUpdateRendererSort(CallbackInfo ci) {
        this.nd$reset(true);
    }

    @Inject(method={"updateRenderer"}, at={@At(value="FIELD", target="Lnet/minecraft/client/renderer/WorldRenderer;isInitialized:Z", ordinal=0, shift=At.Shift.AFTER)}, require=1)
    private void postUpdateRenderer(CallbackInfo ci) {
        this.nd$postUpdateRenderer(false);
    }

    @Inject(method={"updateRendererSort"}, at={@At(value="RETURN")}, require=1)
    private void postUpdateRendererSort(CallbackInfo ci) {
        this.nd$postUpdateRenderer(true);
    }

    @Inject(method={"preRenderBlocks"}, at={@At(value="HEAD")}, require=1)
    private void prePreRenderBlocks(int pass, CallbackInfo ci) {
        if (Neodymium.isActive() && this.nd$chunkMeshes != null) {
            this.nd$chunkMeshes.set(pass, this.nd$beginRenderPass(pass));
        }
    }

    @Redirect(method={"preRenderBlocks"}, at=@At(value="INVOKE", target="Lorg/lwjgl/opengl/GL11;glNewList(II)V"), remap=false, require=1)
    private void noNewList(int list, int mode) {
        if (!Neodymium.isActive() || Compat.keepRenderListLogic()) {
            GL11.glNewList((int)list, (int)mode);
        }
    }

    @Redirect(method={"postRenderBlocks"}, at=@At(value="INVOKE", target="Lorg/lwjgl/opengl/GL11;glEndList()V"), remap=false, require=1)
    private void noEndList() {
        if (!Neodymium.isActive() || Compat.keepRenderListLogic()) {
            GL11.glEndList();
        }
    }

    @Inject(method={"postRenderBlocks"}, at={@At(value="RETURN")}, require=1)
    private void postPostRenderBlocks(int pass, EntityLivingBase entity, CallbackInfo ci) {
        if (Neodymium.isActive() && this.nd$chunkMeshes != null) {
            this.nd$endRenderPass(this.nd$chunkMeshes.get(pass));
        }
    }

    @Inject(method={"setDontDraw"}, at={@At(value="HEAD")}, require=1)
    private void preSetDontDraw(CallbackInfo ci) {
        if (Neodymium.isActive()) {
            Neodymium.renderer.onWorldRendererChanged((WorldRenderer)this, NeoRenderer.WorldRendererChange.DELETED);
        }
    }

    @Inject(method={"updateInFrustum"}, at={@At(value="HEAD")}, require=1)
    private void preUpdateInFrustum(CallbackInfo ci) {
        this.nd$saveDrawnStatus();
    }

    @Inject(method={"updateInFrustum"}, at={@At(value="RETURN")}, require=1)
    private void postUpdateInFrustum(CallbackInfo ci) {
        this.nd$notifyIfDrawnStatusChanged();
    }
}

