/*
 * Decompiled with CFR 0.152.
 */
package makamys.neodymium.renderer;

import gnu.trove.list.array.TIntArrayList;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import makamys.neodymium.Constants;
import makamys.neodymium.Neodymium;
import makamys.neodymium.config.Config;
import makamys.neodymium.ducks.NeodymiumWorldRenderer;
import makamys.neodymium.renderer.Mesh;
import makamys.neodymium.renderer.MeshPolygon;
import makamys.neodymium.renderer.NeoRegion;
import makamys.neodymium.renderer.PolygonNormal;
import makamys.neodymium.util.BufferWriter;
import makamys.neodymium.util.Util;
import makamys.neodymium.util.WarningHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.world.World;
import org.lwjgl.BufferUtils;

public class ChunkMesh
extends Mesh {
    WorldRenderer wr;
    private int tesselatorDataCount;
    private int[] subMeshStart = new int[NORMAL_ORDER.length];
    public static final AtomicLong usedRAM = new AtomicLong();
    public static final AtomicInteger instances = new AtomicInteger();
    public static final ThreadLocal<PolygonMeshBuffer> polygonBuf = ThreadLocal.withInitial(PolygonMeshBuffer::new);
    private static final PolygonNormal[] NORMAL_ORDER = new PolygonNormal[]{PolygonNormal.NONE, PolygonNormal.POSITIVE_Y, PolygonNormal.POSITIVE_X, PolygonNormal.POSITIVE_Z, PolygonNormal.NEGATIVE_X, PolygonNormal.NEGATIVE_Z, PolygonNormal.NEGATIVE_Y};
    private static final int[] POLYGON_NORMAL_TO_NORMAL_ORDER;
    private static final int[] NORMAL_ORDER_TO_POLYGON_NORMAL;
    private static final Flags FLAGS;
    private int bufferSize = 0;
    private static final ThreadLocal<MeshPolygonBucketSort> threadBucketer;

    public ChunkMesh(WorldRenderer wr, int pass) {
        this.x = wr.field_78923_c / 16;
        this.y = wr.field_78920_d / 16;
        this.z = wr.field_78921_e / 16;
        this.wr = wr;
        this.pass = pass;
        Arrays.fill(this.subMeshStart, -1);
        instances.getAndIncrement();
        if (!polygonBuf.get().isEmpty()) {
            Constants.LOGGER.error("Invalid state: tried to construct a chunk mesh before the previous one has finished constructing!");
        }
    }

    public void addTessellatorData(Tessellator t) {
        boolean triangulate;
        ++this.tesselatorDataCount;
        if (t.field_78406_i == 0) {
            return;
        }
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<String> warnings = new ArrayList<String>();
        if (t.field_78409_u != 7 && t.field_78409_u != 4) {
            errors.add("Unsupported draw mode: " + t.field_78409_u);
        }
        boolean bl = triangulate = t.field_78409_u == 7;
        if (this.drawMode == -1) {
            this.drawMode = 4;
            this.verticesPerPolygon = 3;
        }
        if (!t.field_78400_o) {
            errors.add(String.format("Texture data is missing.", new Object[0]));
        }
        if (!t.field_78414_p) {
            warnings.add("Brightness data is missing");
        }
        if (!t.field_78399_n) {
            warnings.add("Color data is missing");
        }
        ChunkMesh.FLAGS.hasBrightness = t.field_78414_p;
        ChunkMesh.FLAGS.hasColor = t.field_78399_n;
        int inputVertices = triangulate ? 4 : 3;
        int outputVertexMultiplier = triangulate ? 2 : 1;
        int tessellatorVertexSize = Neodymium.util.vertexSizeInTessellator();
        int polygonSize = Neodymium.util.polygonSize(3) * outputVertexMultiplier;
        int polygonCount = t.field_78406_i / inputVertices;
        PolygonMeshBuffer buf = polygonBuf.get();
        buf.ensureCapacity(polygonCount * polygonSize);
        for (int polygonI = 0; polygonI < polygonCount; ++polygonI) {
            boolean deleted = MeshPolygon.processPolygon(t.field_78405_h, polygonI * inputVertices * tessellatorVertexSize, buf.data, buf.size, NeoRegion.toRelativeOffset(-t.field_78408_v), NeoRegion.toRelativeOffset(-t.field_78407_w), NeoRegion.toRelativeOffset(-t.field_78417_x), triangulate, FLAGS);
            if (deleted) continue;
            buf.size += polygonSize;
        }
        if (!(buf.isEmpty() || errors.isEmpty() && warnings.isEmpty() || Config.silenceErrors)) {
            String dimId;
            String string = dimId = this.wr.field_78924_a != null && this.wr.field_78924_a.field_73011_w != null ? "" + this.wr.field_78924_a.field_73011_w.field_76574_g : "UNKNOWN";
            if (!errors.isEmpty()) {
                Constants.LOGGER.error("Errors in chunk ({}, {}, {}) in dimension {}:", new Object[]{this.x, this.y, this.z, dimId});
                for (String error : errors) {
                    Constants.LOGGER.error("Error: " + error);
                }
                for (String warning : warnings) {
                    Constants.LOGGER.error("Warning: " + warning);
                }
                Constants.LOGGER.error("(World renderer pos: ({}, {}, {}), Tessellator pos: ({}, {}, {}), Tessellation count: {}", new Object[]{this.wr.field_78923_c, this.wr.field_78920_d, this.wr.field_78921_e, t.field_78408_v, t.field_78407_w, t.field_78417_x, this.tesselatorDataCount});
                Constants.LOGGER.error("Stack trace:");
                try {
                    throw new IllegalArgumentException();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    Constants.LOGGER.error("Skipping chunk due to errors.");
                    buf.reset();
                }
            } else {
                WarningHelper.showDebugMessageOnce(String.format("Warnings in chunk (%d, %d, %d) in dimension %s: %s", this.x, this.y, this.z, dimId, String.join((CharSequence)", ", warnings)));
            }
        }
    }

    private static String tessellatorToString(Tessellator t) {
        return "(" + t.field_78408_v + ", " + t.field_78407_w + ", " + t.field_78417_x + ")";
    }

    @Override
    public int bufferSize() {
        return this.bufferSize;
    }

    public void finishConstruction() {
        PolygonMeshBuffer buf = polygonBuf.get();
        this.polygonCount = buf.size / Neodymium.util.polygonSize(this.verticesPerPolygon);
        this.buffer = this.createBuffer(buf.data);
        this.bufferSize = this.buffer.limit();
        usedRAM.getAndAdd(this.bufferSize);
        buf.reset();
    }

    public static void cancelRendering() {
        PolygonMeshBuffer buf = polygonBuf.get();
        if (!buf.isEmpty()) {
            buf.reset();
            Constants.LOGGER.debug("Cancelled unfinished render pass!");
        }
    }

    private ByteBuffer createBuffer(int[] polygons) {
        int stride = Neodymium.renderer.getStride();
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(this.polygonCount * this.verticesPerPolygon * stride));
        BufferWriter out = new BufferWriter(buffer);
        boolean sortByNormals = this.pass == 0;
        int polygonSize = Neodymium.util.polygonSize(this.verticesPerPolygon);
        int[] indices = null;
        if (sortByNormals) {
            indices = threadBucketer.get().sort(polygons, polygonSize, this.polygonCount);
        }
        for (int i = 0; i < this.polygonCount; ++i) {
            int subMeshStartIdx;
            int index = indices != null ? indices[i] : i;
            int n = subMeshStartIdx = sortByNormals ? POLYGON_NORMAL_TO_NORMAL_ORDER[polygons[(index + 1) * polygonSize - 1]] : 0;
            if (this.subMeshStart[subMeshStartIdx] == -1) {
                this.subMeshStart[subMeshStartIdx] = i;
            }
            Neodymium.util.writeMeshPolygonToBuffer(polygons, index * polygonSize, out, stride, this.verticesPerPolygon);
        }
        buffer.flip();
        return buffer;
    }

    void destroy() {
        if (this.buffer != null) {
            usedRAM.getAndAdd(-this.buffer.limit());
            instances.getAndDecrement();
            this.buffer = null;
            if (this.gpuStatus == Mesh.GPUStatus.SENT) {
                this.gpuStatus = Mesh.GPUStatus.PENDING_DELETE;
            }
        }
    }

    @Override
    public void destroyBuffer() {
        this.destroy();
    }

    static List<ChunkMesh> getChunkMesh(int theX, int theY, int theZ) {
        WorldRenderer wr = new WorldRenderer((World)Minecraft.func_71410_x().field_71441_e, new ArrayList(), theX * 16, theY * 16, theZ * 16, 100000);
        wr.field_78935_u = false;
        wr.field_78936_t = true;
        wr.field_78927_l = true;
        wr.field_78937_s = 0;
        wr.func_78914_f();
        wr.func_147892_a((EntityLivingBase)Minecraft.func_71410_x().field_71439_g);
        return ((NeodymiumWorldRenderer)wr).nd$getChunkMeshes();
    }

    public WorldRenderer wr() {
        return this.wr;
    }

    @Override
    public int writeToIndexBuffer(IntBuffer piFirst, IntBuffer piCount, int cameraXDiv, int cameraYDiv, int cameraZDiv, int pass) {
        if (!Config.cullFaces) {
            return super.writeToIndexBuffer(piFirst, piCount, cameraXDiv, cameraYDiv, cameraZDiv, pass);
        }
        int renderedMeshes = 0;
        int startIndex = -1;
        for (int i = 0; i < NORMAL_ORDER.length + 1; ++i) {
            boolean isVisible;
            if (i < this.subMeshStart.length && this.subMeshStart[i] == -1) continue;
            PolygonNormal normal = i < NORMAL_ORDER.length ? NORMAL_ORDER[i] : null;
            boolean bl = isVisible = normal != null && this.isNormalVisible(normal, cameraXDiv, cameraYDiv, cameraZDiv, pass);
            if (isVisible && startIndex == -1) {
                startIndex = this.subMeshStart[POLYGON_NORMAL_TO_NORMAL_ORDER[normal.ordinal()]];
                continue;
            }
            if (isVisible || startIndex == -1) continue;
            int endIndex = i < this.subMeshStart.length ? this.subMeshStart[i] : this.polygonCount;
            piFirst.put(this.iFirst + startIndex * this.verticesPerPolygon);
            piCount.put((endIndex - startIndex) * this.verticesPerPolygon);
            ++renderedMeshes;
            startIndex = -1;
        }
        return renderedMeshes;
    }

    private boolean isNormalVisible(PolygonNormal normal, int interpXDiv, int interpYDiv, int interpZDiv, int pass) {
        switch (normal) {
            case POSITIVE_X: {
                return interpXDiv >= this.x + 0;
            }
            case NEGATIVE_X: {
                return interpXDiv < this.x + 1;
            }
            case POSITIVE_Y: {
                return interpYDiv >= this.y + 0;
            }
            case NEGATIVE_Y: {
                return interpYDiv < this.y + 1;
            }
            case POSITIVE_Z: {
                return interpZDiv >= this.z + 0;
            }
            case NEGATIVE_Z: {
                return interpZDiv < this.z + 1;
            }
        }
        return pass != 0 || Config.maxUnalignedPolygonDistance == Integer.MAX_VALUE || Util.distSq(interpXDiv, interpYDiv, interpZDiv, this.x, this.y, this.z) < Math.pow(Config.maxUnalignedPolygonDistance, 2.0);
    }

    public double distSq(Entity player) {
        int centerX = this.x * 16 + 8;
        int centerY = this.y * 16 + 8;
        int centerZ = this.z * 16 + 8;
        return player.func_70092_e((double)centerX, (double)centerY, (double)centerZ);
    }

    static {
        FLAGS = new Flags(true, true, true, false);
        POLYGON_NORMAL_TO_NORMAL_ORDER = new int[PolygonNormal.values().length];
        NORMAL_ORDER_TO_POLYGON_NORMAL = new int[PolygonNormal.values().length];
        int i = 0;
        while (i < PolygonNormal.values().length) {
            int idx = Arrays.asList(NORMAL_ORDER).indexOf((Object)PolygonNormal.values()[i]);
            if (idx == -1) {
                idx = 0;
            }
            ChunkMesh.POLYGON_NORMAL_TO_NORMAL_ORDER[i] = idx;
            ChunkMesh.NORMAL_ORDER_TO_POLYGON_NORMAL[idx] = i++;
        }
        threadBucketer = ThreadLocal.withInitial(MeshPolygonBucketSort::new);
    }

    public static class MeshPolygonBucketSort {
        private static final int bucketCount = ChunkMesh.access$000().length;
        private final TIntArrayList[] buckets = new TIntArrayList[bucketCount];
        private int[] resultBuffer;

        public MeshPolygonBucketSort() {
            for (int i = 0; i < bucketCount; ++i) {
                this.buckets[i] = new TIntArrayList();
            }
        }

        private static int bucket(int[] buffer, int polygonSize, int index) {
            return buffer[polygonSize * (index + 1) - 1];
        }

        public int[] sort(int[] buffer, int polygonSize, int polygonCount) {
            int i;
            for (i = 0; i < bucketCount; ++i) {
                this.buckets[i].resetQuick();
            }
            for (i = 0; i < polygonCount; ++i) {
                this.buckets[MeshPolygonBucketSort.bucket(buffer, polygonSize, i)].add(i);
            }
            if (this.resultBuffer == null || this.resultBuffer.length < polygonCount) {
                this.resultBuffer = new int[polygonCount];
            }
            int[] result = this.resultBuffer;
            int offset = 0;
            for (int i2 = 0; i2 < bucketCount; ++i2) {
                TIntArrayList bucket = this.buckets[NORMAL_ORDER_TO_POLYGON_NORMAL[i2]];
                int size = bucket.size();
                bucket.toArray(result, 0, offset, size);
                offset += size;
            }
            assert (offset == polygonCount);
            return result;
        }
    }

    public static class PolygonMeshBuffer {
        public int[] data = new int[1024];
        public int size = 0;

        public void ensureCapacity(int maxNewAmount) {
            int newSize = this.size + maxNewAmount;
            if (newSize > this.data.length) {
                this.data = Arrays.copyOf(this.data, newSize);
            }
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public void reset() {
            this.size = 0;
        }
    }

    public static class Flags {
        public boolean hasTexture;
        public boolean hasBrightness;
        public boolean hasColor;
        public boolean hasNormals;

        public Flags(byte flags) {
            this.hasTexture = (flags & 1) != 0;
            this.hasBrightness = (flags & 2) != 0;
            this.hasColor = (flags & 4) != 0;
            this.hasNormals = (flags & 8) != 0;
        }

        public Flags(boolean hasTexture, boolean hasBrightness, boolean hasColor, boolean hasNormals) {
            this.hasTexture = hasTexture;
            this.hasBrightness = hasBrightness;
            this.hasColor = hasColor;
            this.hasNormals = hasNormals;
        }

        public byte toByte() {
            byte flags = 0;
            if (this.hasTexture) {
                flags = (byte)(flags | 1);
            }
            if (this.hasBrightness) {
                flags = (byte)(flags | 2);
            }
            if (this.hasColor) {
                flags = (byte)(flags | 4);
            }
            if (this.hasNormals) {
                flags = (byte)(flags | 8);
            }
            return flags;
        }
    }
}

