/*
 * Decompiled with CFR 0.152.
 */
package makamys.neodymium.renderer;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import makamys.neodymium.Neodymium;
import makamys.neodymium.config.Config;
import makamys.neodymium.renderer.Mesh;
import makamys.neodymium.renderer.NeoRenderer;
import makamys.neodymium.util.GuiHelper;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GL31;

public class GPUMemoryManager {
    private static final long MEGABYTE = 0x100000L;
    private static final long[] BUFFER_SIZE_BYTES = new long[]{(long)Config.bufferSizePass0 * 0x100000L, (long)Config.bufferSizePass1 * 0x100000L};
    private static final int INDEX_ALLOCATION_SIZE_BYTES = 2048;
    private static final long USED_VRAM_UPDATE_RATE = 1000000000L;
    private static int copyBuffer = 0;
    private static long copyBufferSize = 0L;
    private final List<Mesh> sentMeshes = new ArrayList<Mesh>();
    private final long bufferSizeBytes;
    public final int managerIndex;
    public final int pass;
    public final int drawMode;
    public final int verticesPerPolygon;
    private int indexSize;
    private int nextMesh = 0;
    private long usedVRAM = 0L;
    private long lastUsedVRAMUpdate = 0L;
    public int VAO = 0;
    public int VBO = 0;
    public IntBuffer piFirst = null;
    public IntBuffer piCount = null;

    public GPUMemoryManager(int managerIndex, int pass, int drawMode, int verticesPerPolygon) throws Exception {
        this.bufferSizeBytes = BUFFER_SIZE_BYTES[pass];
        this.managerIndex = managerIndex;
        this.pass = pass;
        this.drawMode = drawMode;
        this.verticesPerPolygon = verticesPerPolygon;
        try {
            this.VBO = GPUMemoryManager.createVBO(this.bufferSizeBytes);
            this.VAO = GPUMemoryManager.createVAO();
        }
        catch (Exception e) {
            this.destroyImpl();
            throw e;
        }
        this.indexSize = 2048;
        this.reAllocIndexBuffers();
        this.piFirst.flip();
        this.piCount.flip();
    }

    public boolean uploadMesh(Mesh mesh) {
        if (mesh == null || mesh.buffer == null || mesh.verticesPerPolygon != this.verticesPerPolygon) {
            return false;
        }
        if (this.end() + (long)mesh.bufferSize() >= this.bufferSizeBytes) {
            return false;
        }
        int size = mesh.bufferSize();
        int insertIndex = -1;
        long nextBase = -1L;
        if (!this.sentMeshes.isEmpty()) {
            if (this.nextMesh < this.sentMeshes.size() - 1) {
                Mesh meshA = this.sentMeshes.get(this.nextMesh);
                Mesh meshB = null;
                for (int i = this.nextMesh + 1; i < this.sentMeshes.size(); ++i) {
                    Mesh meshC = this.sentMeshes.get(i);
                    if (meshC.gpuStatus != Mesh.GPUStatus.SENT) continue;
                    meshB = meshC;
                    break;
                }
                if (meshB != null && meshB.offset - meshA.getEnd() >= (long)size) {
                    nextBase = meshA.getEnd();
                    insertIndex = this.nextMesh + 1;
                }
            }
            if (nextBase == -1L) {
                nextBase = this.sentMeshes.get(this.sentMeshes.size() - 1).getEnd();
            }
        }
        if (nextBase == -1L) {
            nextBase = 0L;
        }
        if (mesh.gpuStatus == Mesh.GPUStatus.UNSENT) {
            this.uploadMeshToVBO(mesh, nextBase);
            if (insertIndex == -1) {
                this.sentMeshes.add(mesh);
            } else {
                this.sentMeshes.add(insertIndex, mesh);
                this.nextMesh = insertIndex;
            }
        }
        mesh.gpuStatus = Mesh.GPUStatus.SENT;
        mesh.attachedManager = this;
        return true;
    }

    public void deleteMesh(Mesh mesh) {
        if (mesh == null || mesh.gpuStatus == Mesh.GPUStatus.UNSENT) {
            return;
        }
        mesh.gpuStatus = Mesh.GPUStatus.PENDING_DELETE;
        mesh.attachedManager = null;
    }

    public void growIndexBuffers() {
        this.indexSize = (int)((float)this.indexSize * 1.5f);
        this.reAllocIndexBuffers();
        this.piFirst.limit(this.piFirst.capacity());
        this.piCount.limit(this.piCount.capacity());
    }

    public void runGC(boolean full) {
        int moved = 0;
        int timesReachedEnd = 0;
        int checksLeft = this.sentMeshes.size();
        while (!full && moved < 32 && checksLeft > 0 || full && timesReachedEnd < 2 && !this.sentMeshes.isEmpty()) {
            --checksLeft;
            ++this.nextMesh;
            if (this.nextMesh >= this.sentMeshes.size()) {
                this.nextMesh = 0;
                ++timesReachedEnd;
            }
            Mesh mesh = this.sentMeshes.get(this.nextMesh);
            if (mesh.gpuStatus == Mesh.GPUStatus.SENT) {
                long offset = this.nextMesh == 0 ? 0L : this.sentMeshes.get(this.nextMesh - 1).getEnd();
                if (mesh.offset == offset) continue;
                this.moveMeshInVBO(mesh, offset);
                ++moved;
                continue;
            }
            if (mesh.gpuStatus != Mesh.GPUStatus.PENDING_DELETE) continue;
            this.deleteMeshFromVBO(mesh);
            this.sentMeshes.remove(this.nextMesh);
            if (this.nextMesh <= 0) continue;
            --this.nextMesh;
        }
    }

    public List<String> debugText() {
        long t = System.nanoTime();
        if (t - this.lastUsedVRAMUpdate > 1000000000L) {
            this.usedVRAM = 0L;
            for (Mesh mesh : this.sentMeshes) {
                this.usedVRAM += (long)mesh.bufferSize();
            }
            this.lastUsedVRAMUpdate = t;
        }
        return Collections.singletonList("PASS " + this.pass + ": " + this.usedVRAM / 1024L / 1024L + "MB (" + this.end() / 1024L / 1024L + "MB) / " + this.bufferSizeBytes / 1024L / 1024L + "MB");
    }

    public int drawDebugInfo(int yOff) {
        int scale = 10000;
        int rowLength = 512;
        int height = (int)(this.bufferSizeBytes / (long)scale) / rowLength;
        GuiHelper.drawRectangle(0, yOff, rowLength, height, 0, 50);
        int meshI = 0;
        Iterator<Mesh> iterator = this.sentMeshes.iterator();
        while (iterator.hasNext()) {
            Mesh mesh;
            int o = (int)(mesh.offset / 10000L);
            mesh = iterator.next();
            int o2 = (int)((mesh.offset + (long)mesh.bufferSize()) / 10000L);
            if (o / rowLength == o2 / rowLength) {
                if (mesh.gpuStatus != Mesh.GPUStatus.PENDING_DELETE) {
                    GuiHelper.drawRectangle(o % rowLength, o / rowLength + yOff, mesh.buffer.limit() / scale + 1, 1, meshI == this.nextMesh ? 65280 : 0xFFFFFF);
                }
            } else {
                for (int i = o; i < o2; ++i) {
                    int x = i % rowLength;
                    int y = i / rowLength;
                    if (mesh.gpuStatus == Mesh.GPUStatus.PENDING_DELETE) continue;
                    GuiHelper.drawRectangle(x, y + yOff, 1, 1, 0xFFFFFF);
                }
            }
            ++meshI;
        }
        GuiHelper.drawRectangle(0 % rowLength, 0 + yOff, 4, 4, 65280);
        GuiHelper.drawRectangle((int)(this.bufferSizeBytes / (long)scale) % rowLength, (int)(this.bufferSizeBytes / (long)scale) / rowLength + yOff, 4, 4, 0xFF0000);
        return (int)(this.bufferSizeBytes / (long)scale) / rowLength + yOff;
    }

    public void destroy() {
        GPUMemoryManager.destroyCopyBuffer();
        if (Neodymium.renderer != null) {
            NeoRenderer.submitTask(this::destroyImpl, 60);
        } else {
            this.destroyImpl();
        }
    }

    private void uploadMeshToVBO(Mesh mesh, long offset) {
        mesh.prepareBuffer();
        if (mesh.bufferSize() > 0) {
            this.copyBytesToVBO(offset, mesh.buffer);
        }
        mesh.iFirst = (int)(offset / (long)Neodymium.renderer.getStride());
        mesh.iCount = mesh.polygonCount * this.verticesPerPolygon;
        mesh.offset = offset;
    }

    private void deleteMeshFromVBO(Mesh mesh) {
        this.deleteBytesFromVBO(mesh.offset, mesh.bufferSize());
        mesh.iFirst = -1;
        mesh.offset = -1L;
        mesh.visible = false;
        mesh.gpuStatus = Mesh.GPUStatus.UNSENT;
        mesh.destroyBuffer();
    }

    private void reAllocIndexBuffers() {
        this.piFirst = GPUMemoryManager.refreshIntBuffer(this.piFirst, BufferUtils.createByteBuffer((int)(this.indexSize * this.verticesPerPolygon)).asIntBuffer());
        this.piCount = GPUMemoryManager.refreshIntBuffer(this.piCount, BufferUtils.createByteBuffer((int)(this.indexSize * this.verticesPerPolygon)).asIntBuffer());
    }

    private void moveMeshInVBO(Mesh mesh, long newOffset) {
        this.moveBytesInVBO(mesh.offset, newOffset, mesh.bufferSize());
        mesh.iFirst = (int)(newOffset / (long)Neodymium.renderer.getStride());
        mesh.offset = newOffset;
    }

    private void copyBytesToVBO(long offset, ByteBuffer bytes) {
        if (bytes.remaining() == 0) {
            return;
        }
        GL15.glBindBuffer((int)34962, (int)this.VBO);
        GL15.glBufferSubData((int)34962, (long)offset, (ByteBuffer)bytes);
        GL15.glBindBuffer((int)34962, (int)0);
    }

    private void moveBytesInVBO(long sourceOffsetBytes, long targetOffsetBytes, long sizeBytes) {
        if (sizeBytes == 0L) {
            return;
        }
        long targetEndBytes = targetOffsetBytes + sizeBytes;
        long sourceEndBytes = sourceOffsetBytes + sizeBytes;
        GL15.glBindBuffer((int)34962, (int)this.VBO);
        if (sourceOffsetBytes <= targetEndBytes && sourceEndBytes >= targetOffsetBytes) {
            GPUMemoryManager.prepareCopyBuffer(sizeBytes);
            GL15.glBindBuffer((int)36663, (int)copyBuffer);
            GL31.glCopyBufferSubData((int)34962, (int)36663, (long)sourceOffsetBytes, (long)0L, (long)sizeBytes);
            GL31.glCopyBufferSubData((int)36663, (int)34962, (long)0L, (long)targetOffsetBytes, (long)sizeBytes);
            GL15.glBindBuffer((int)36663, (int)0);
        } else {
            GL31.glCopyBufferSubData((int)34962, (int)34962, (long)sourceOffsetBytes, (long)targetOffsetBytes, (long)sizeBytes);
        }
        GL15.glBindBuffer((int)34962, (int)0);
    }

    private void deleteBytesFromVBO(long offsetBytes, long sizeBytes) {
    }

    private long end() {
        return this.sentMeshes.isEmpty() ? 0L : this.sentMeshes.get(this.sentMeshes.size() - 1).getEnd();
    }

    private void destroyImpl() {
        if (this.VAO != 0) {
            GL30.glDeleteVertexArrays((int)this.VAO);
            this.VAO = 0;
        }
        if (this.VBO != 0) {
            GL15.glDeleteBuffers((int)this.VBO);
            this.VBO = 0;
        }
    }

    private static int createVBO(long sizeBytes) throws Exception {
        GPUMemoryManager.flushGLError();
        int vbo = GL15.glGenBuffers();
        if (vbo == 0) {
            throw new Exception("Failed to create new VBO");
        }
        GL15.glBindBuffer((int)34962, (int)vbo);
        GL15.glBufferData((int)34962, (long)sizeBytes, (int)35048);
        GL15.glBindBuffer((int)34962, (int)0);
        if (GPUMemoryManager.checkGLError()) {
            GL15.glDeleteBuffers((int)vbo);
            throw new Exception("Failed to allocate " + sizeBytes + " bytes for new VBO");
        }
        return vbo;
    }

    private static int createVAO() throws Exception {
        int vao = GL30.glGenVertexArrays();
        if (vao == 0) {
            throw new Exception("Failed to create vertex array");
        }
        return vao;
    }

    private static void flushGLError() {
        while (GL11.glGetError() != 0) {
        }
    }

    private static boolean checkGLError() {
        return GL11.glGetError() != 0;
    }

    private static IntBuffer refreshIntBuffer(IntBuffer oldBuf, IntBuffer newBuf) {
        if (oldBuf != null) {
            newBuf.position(oldBuf.position());
        }
        return newBuf;
    }

    private static void prepareCopyBuffer(long requiredSizeBytes) {
        if (copyBufferSize >= requiredSizeBytes) {
            return;
        }
        if (copyBuffer == 0) {
            copyBuffer = GL15.glGenBuffers();
        }
        copyBufferSize = GPUMemoryManager.next16Megabyte(requiredSizeBytes);
        GL15.glBindBuffer((int)36663, (int)copyBuffer);
        GL15.glBufferData((int)36663, (long)copyBufferSize, (int)35050);
        GL15.glBindBuffer((int)36663, (int)0);
    }

    private static void destroyCopyBuffer() {
        if (copyBuffer == 0) {
            return;
        }
        GL15.glDeleteBuffers((int)copyBuffer);
        copyBuffer = 0;
        copyBufferSize = 0L;
    }

    private static long next16Megabyte(long size) {
        long sixteenMegs = 0x1000000L;
        long increments = size / 0x1000000L + 1L;
        return increments * 0x1000000L;
    }
}

