/*
 * Decompiled with CFR 0.152.
 */
package makamys.neodymium.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import javax.imageio.ImageIO;
import makamys.neodymium.util.ChatUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.launchwrapper.Launch;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class Util {
    private static boolean allowResourceOverrides = Boolean.parseBoolean(System.getProperty("neodymium.allowResourceOverrides", "false"));

    public static Path getResourcePath(String relPath) {
        File overrideFile;
        if (allowResourceOverrides && (overrideFile = new File(new File(Launch.minecraftHome, "neodymium/resources"), relPath)).exists()) {
            return overrideFile.toPath();
        }
        try {
            URL resourceURL = Util.class.getClassLoader().getResource(relPath);
            switch (resourceURL.getProtocol()) {
                case "jar": {
                    String urlString = resourceURL.getPath();
                    int lastExclamation = urlString.lastIndexOf(33);
                    String newURLString = urlString.substring(0, lastExclamation);
                    return FileSystems.newFileSystem(new File(URI.create(newURLString)).toPath(), null).getPath(relPath, new String[0]);
                }
                case "file": {
                    return new File(URI.create(resourceURL.toString())).toPath();
                }
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String readFile(String path) {
        try {
            return new String(Files.readAllBytes(Util.getResourcePath(path)));
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static byte[] byteBufferToArray(ByteBuffer buffer) {
        byte[] dst = new byte[buffer.limit()];
        int pos = buffer.position();
        buffer.position(0);
        buffer.get(dst);
        buffer.position(pos);
        return dst;
    }

    public static int[] intBufferToArray(IntBuffer buffer) {
        int[] dst = new int[buffer.limit()];
        int pos = buffer.position();
        buffer.position(0);
        buffer.get(dst);
        buffer.position(pos);
        return dst;
    }

    public static float[] floatBufferToArray(FloatBuffer buffer) {
        float[] dst = new float[buffer.limit()];
        int pos = buffer.position();
        buffer.position(0);
        buffer.get(dst);
        buffer.position(pos);
        return dst;
    }

    public static double distSq(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dX = x1 - x2;
        double dY = y1 - y2;
        double dZ = z1 - z2;
        return dX * dX + dY * dY + dZ * dZ;
    }

    public static void dumpTexture() {
        Minecraft mc = Minecraft.func_71410_x();
        Path workingPath = mc.field_71412_D.toPath();
        File terrainFile = workingPath.resolve("terrain.png").toFile();
        int width = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        int height = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        ByteBuffer buf = BufferUtils.createByteBuffer((int)(4 * width * height));
        GL11.glGetTexImage((int)3553, (int)0, (int)32993, (int)5121, (ByteBuffer)buf);
        try {
            BufferedImage img = new BufferedImage(width, height, 2);
            IntBuffer intBuf = buf.asIntBuffer();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    img.setRGB(x, y, intBuf.get());
                }
            }
            ImageIO.write((RenderedImage)img, "png", terrainFile);
        }
        catch (IOException e) {
            ChatUtil.showNeoChatMessage("Failed to dump terrain texture", ChatUtil.MessageVerbosity.ERROR);
            e.printStackTrace();
        }
        ChatUtil.showChatMessage("Dumped terrain texture to: " + terrainFile.getAbsolutePath());
    }

    public static int createBrightness(int sky, int block) {
        return sky << 20 | block << 4;
    }

    public static void setPositionAndLimit(Buffer buffer, int position, int limit) {
        buffer.position(position);
        buffer.limit(limit);
    }
}

