/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.componentAI.jobSystem;

import CoroUtil.componentAI.AITamable;
import CoroUtil.componentAI.jobSystem.JobBase;
import CoroUtil.componentAI.jobSystem.JobManager;
import CoroUtil.entity.EnumActState;
import java.util.Random;

public class JobPlay
extends JobBase {
    public int playTime = 0;
    public int playTimeMax = 400;
    public int playTimeRandomSize = 20;
    public float rotationYaw = 0.0f;

    public JobPlay(JobManager jm) {
        super(jm);
    }

    @Override
    public boolean shouldExecute() {
        return true;
    }

    @Override
    public boolean shouldContinue() {
        return this.playTime == 0;
    }

    @Override
    public void tick() {
        this.playTimeRandomSize = 20;
        if (this.playTime > 0) {
            --this.playTime;
            if (this.playTime == 0) {
                this.playReset();
            }
        }
        double distStart = 1.0;
        double distEnd = 3.0;
        double distStep = 0.5;
        double lookStartStop = 90.0;
        double lookStep = 90.0;
        if (this.playTime > 0) {
            if (this.ent.func_70661_as().func_75500_f()) {
                if (this.isMovementSafe(true, true, false, distStart, distEnd, distStep, lookStartStop, lookStep)) {
                    int randChange = 60;
                    distStart = 0.5;
                    distEnd = 1.0;
                    lookStartStop = 0.0;
                    if (!this.isMovementSafe(false, false, true, distStart, distEnd, distStep, lookStartStop, lookStep)) {
                        this.rotationYaw = this.ent.field_70170_p.func_72820_D() % 40L < 20L ? (this.rotationYaw -= 45.0f) : (this.rotationYaw += 45.0f);
                    }
                    Random rand = new Random();
                    this.rotationYaw += (float)(rand.nextInt(randChange) - randChange / 2);
                    float speed = 0.38f;
                    double vecX = -Math.cos((double)this.rotationYaw * 0.01745329);
                    double vecZ = Math.sin((double)this.rotationYaw * 0.01745329);
                    this.ent.func_70605_aq().func_75642_a(this.ent.field_70165_t + vecX, this.ent.field_70163_u, this.ent.field_70161_v + vecZ, (double)speed);
                    if (rand.nextInt(20) == 0) {
                        this.ent.func_70683_ar().func_75660_a();
                    }
                } else {
                    this.playReset();
                }
            } else {
                this.playReset();
            }
        } else {
            AITamable tamable = this.entInt.getAIAgent().jobMan.getPrimaryJob().tamable;
            if (tamable.isTame()) {
                Random rand = new Random();
                if (this.ent.func_70661_as().func_75500_f() && rand.nextInt(this.playTimeRandomSize) == 0) {
                    this.playStart();
                }
            }
        }
    }

    public void playStart() {
        this.ai.setState(EnumActState.PLAYING);
        this.playTime = this.playTimeMax;
    }

    public void playReset() {
        this.ai.setState(EnumActState.IDLE);
        this.playTime = 0;
    }
}

