/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.entity.render;

import CoroUtil.bt.IBTAgent;
import CoroUtil.entity.render.AnimationStateObject;
import CoroUtil.entity.render.ModelBox;
import CoroUtil.entity.render.RenderEntityCoroAI;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.TextureOffset;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import org.lwjgl.opengl.GL11;

public class ModelRendererBones {
    public float textureWidth = 64.0f;
    public float textureHeight = 32.0f;
    private int textureOffsetX;
    private int textureOffsetY;
    public float rotationPointX;
    public float rotationPointY;
    public float rotationPointZ;
    public float rotationPointXRel;
    public float rotationPointYRel;
    public float rotationPointZRel;
    public float rotateAngleX;
    public float rotateAngleY;
    public float rotateAngleZ;
    private boolean compiled;
    private int displayList;
    public boolean mirror;
    public boolean showModel = true;
    public boolean isHidden;
    public List cubeList = new ArrayList();
    public List childModels;
    public final String boxName;
    private ModelBase baseModel;
    public float offsetX;
    public float offsetY;
    public float offsetZ;
    public int inventoryRenderType = -1;

    public ModelRendererBones(ModelBase par1ModelBase, String par2Str) {
        this.baseModel = par1ModelBase;
        par1ModelBase.field_78092_r.add(this);
        this.boxName = par2Str;
        this.setTextureSize(par1ModelBase.field_78090_t, par1ModelBase.field_78089_u);
    }

    public ModelRendererBones(ModelBase par1ModelBase) {
        this(par1ModelBase, null);
    }

    public ModelRendererBones(ModelBase par1ModelBase, int par2, int par3) {
        this(par1ModelBase);
        this.setTextureOffset(par2, par3);
    }

    public void addChild(ModelRendererBones par1ModelRenderer) {
        if (this.childModels == null) {
            this.childModels = new ArrayList();
        }
        this.childModels.add(par1ModelRenderer);
    }

    public ModelRendererBones setTextureOffset(int par1, int par2) {
        this.textureOffsetX = par1;
        this.textureOffsetY = par2;
        return this;
    }

    public ModelRendererBones addBox(String par1Str, float par2, float par3, float par4, int par5, int par6, int par7) {
        par1Str = this.boxName + "." + par1Str;
        TextureOffset textureoffset = this.baseModel.func_78084_a(par1Str);
        this.setTextureOffset(textureoffset.field_78783_a, textureoffset.field_78782_b);
        this.cubeList.add(new ModelBox(this, this.textureOffsetX, this.textureOffsetY, par2, par3, par4, par5, par6, par7, 0.0f).func_78244_a(par1Str));
        return this;
    }

    public ModelRendererBones addBox(float par1, float par2, float par3, int par4, int par5, int par6) {
        this.cubeList.add(new ModelBox(this, this.textureOffsetX, this.textureOffsetY, par1, par2, par3, par4, par5, par6, 0.0f));
        return this;
    }

    public void addBox(float par1, float par2, float par3, int par4, int par5, int par6, float par7) {
        this.cubeList.add(new ModelBox(this, this.textureOffsetX, this.textureOffsetY, par1, par2, par3, par4, par5, par6, par7));
    }

    public void setRotationPoint(float par1, float par2, float par3) {
        this.rotationPointX = par1;
        this.rotationPointY = par2;
        this.rotationPointZ = par3;
    }

    @SideOnly(value=Side.CLIENT)
    public void render(IBTAgent agent, float scale, float partialTicks) {
        AnimationStateObject animData = agent.getAIBTAgent().profile.animationData.get(this.boxName);
        RenderEntityCoroAI render = (RenderEntityCoroAI)((Object)RenderManager.field_78727_a.field_78729_o.get(agent.getClass()));
        if (animData == null) {
            System.out.println("no animData found, creating a blank one");
            animData = new AnimationStateObject(this.boxName);
        }
        if (animData != null && !this.isHidden && this.showModel) {
            if (!this.compiled) {
                this.compileDisplayList(scale);
            }
            if (animData.rotateMode == 0) {
                if (animData.rotateAngleX == 0.0f && animData.rotateAngleY == 0.0f && animData.rotateAngleZ == 0.0f) {
                    if (this.rotationPointXRel == 0.0f && this.rotationPointYRel == 0.0f && this.rotationPointZRel == 0.0f) {
                        GL11.glCallList((int)this.displayList);
                        if (this.inventoryRenderType == 0) {
                            RenderEntityCoroAI.renderEquipment(agent.getAIBTAgent().ent, scale);
                        } else if (this.inventoryRenderType == 1) {
                            // empty if block
                        }
                        render.func_110777_b((Entity)agent.getAIBTAgent().ent);
                        if (this.childModels != null) {
                            for (int i = 0; i < this.childModels.size(); ++i) {
                                ((ModelRendererBones)this.childModels.get(i)).render(agent, scale, partialTicks);
                            }
                        }
                    } else {
                        GL11.glTranslatef((float)(this.rotationPointXRel * scale), (float)(this.rotationPointYRel * scale), (float)(this.rotationPointZRel * scale));
                        GL11.glCallList((int)this.displayList);
                        if (this.inventoryRenderType == 0) {
                            RenderEntityCoroAI.renderEquipment(agent.getAIBTAgent().ent, scale);
                        } else if (this.inventoryRenderType == 1) {
                            // empty if block
                        }
                        render.func_110777_b((Entity)agent.getAIBTAgent().ent);
                        if (this.childModels != null) {
                            for (int i = 0; i < this.childModels.size(); ++i) {
                                ((ModelRendererBones)this.childModels.get(i)).render(agent, scale, partialTicks);
                            }
                        }
                        GL11.glTranslatef((float)(-this.rotationPointXRel * scale), (float)(-this.rotationPointYRel * scale), (float)(-this.rotationPointZRel * scale));
                    }
                } else {
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)(this.rotationPointXRel * scale), (float)(this.rotationPointYRel * scale), (float)(this.rotationPointZRel * scale));
                    if (animData.rotateAngleZ != 0.0f) {
                        GL11.glRotatef((float)((animData.rotateAngleZPrev + (animData.rotateAngleZ - animData.rotateAngleZPrev) * scale) * 57.295776f), (float)0.0f, (float)0.0f, (float)1.0f);
                    }
                    if (animData.rotateAngleY != 0.0f) {
                        GL11.glRotatef((float)((animData.rotateAngleYPrev + (animData.rotateAngleY - animData.rotateAngleYPrev) * scale) * 57.295776f), (float)0.0f, (float)1.0f, (float)0.0f);
                    }
                    if (animData.rotateAngleX != 0.0f) {
                        GL11.glRotatef((float)((animData.rotateAngleXPrev + (animData.rotateAngleX - animData.rotateAngleXPrev) * partialTicks) * 57.295776f), (float)1.0f, (float)0.0f, (float)0.0f);
                    }
                    GL11.glCallList((int)this.displayList);
                    if (this.inventoryRenderType == 0) {
                        RenderEntityCoroAI.renderEquipment(agent.getAIBTAgent().ent, scale);
                    } else if (this.inventoryRenderType == 1) {
                        // empty if block
                    }
                    render.func_110777_b((Entity)agent.getAIBTAgent().ent);
                    if (this.childModels != null) {
                        for (int i = 0; i < this.childModels.size(); ++i) {
                            ((ModelRendererBones)this.childModels.get(i)).render(agent, scale, partialTicks);
                        }
                    }
                    GL11.glPopMatrix();
                }
            } else if (animData.rotateMode == 1) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)(this.rotationPointXRel * scale), (float)(this.rotationPointYRel * scale), (float)(this.rotationPointZRel * scale));
                if (this.boxName.equals("head")) {
                    // empty if block
                }
                FloatBuffer buffer = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer().put(animData.matrix);
                buffer.flip();
                GL11.glMultMatrix((FloatBuffer)buffer);
                GL11.glCallList((int)this.displayList);
                if (this.inventoryRenderType == 0 || this.inventoryRenderType == 1) {
                    // empty if block
                }
                render.func_110777_b((Entity)agent.getAIBTAgent().ent);
                if (this.childModels != null) {
                    for (int i = 0; i < this.childModels.size(); ++i) {
                        ((ModelRendererBones)this.childModels.get(i)).render(agent, scale, partialTicks);
                    }
                }
                GL11.glPopMatrix();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void compileDisplayList(float par1) {
        this.displayList = GLAllocation.func_74526_a((int)1);
        GL11.glNewList((int)this.displayList, (int)4864);
        Tessellator tessellator = Tessellator.field_78398_a;
        for (int i = 0; i < this.cubeList.size(); ++i) {
            ((ModelBox)this.cubeList.get(i)).render(tessellator, par1);
        }
        GL11.glEndList();
        this.compiled = true;
    }

    public ModelRendererBones setTextureSize(int par1, int par2) {
        this.textureWidth = par1;
        this.textureHeight = par2;
        return this;
    }
}

