/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.world.location;

import CoroUtil.util.ChunkCoordinatesBlock;
import CoroUtil.util.CoroUtilBlock;
import CoroUtil.world.location.StructureObject;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class StructureDamagable
extends StructureObject {
    public int healthCur;
    public int healthMax;

    @Override
    public void tickUpdate() {
        super.tickUpdate();
        boolean needCacheUpdate = false;
        WorldServer world = DimensionManager.getWorld((int)this.location.dimID);
        if (world != null) {
            if (world.func_82737_E() % 6000L == 0L) {
                // empty if block
            }
            if (needCacheUpdate) {
                List<ChunkCoordinatesBlock> data = this.getStructureGenerationComplete(false);
                this.healthCur = this.getStructureHealth(data, false);
                if (this.healthCur < this.healthMax / 4 * 3) {
                    System.out.println(this.name + " rebuilding, health: " + this.healthCur + " / " + this.healthMax);
                    this.buildStructureComplete(false);
                }
            }
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound var1) {
        super.readFromNBT(var1);
        this.healthCur = var1.func_74762_e("healthCur");
        this.healthMax = var1.func_74762_e("healthMax");
    }

    @Override
    public void writeToNBT(NBTTagCompound var1) {
        super.writeToNBT(var1);
        var1.func_74768_a("healthCur", this.healthCur);
        var1.func_74768_a("healthMax", this.healthMax);
    }

    @Override
    public void updateStructureState(List<ChunkCoordinatesBlock> parStructure, boolean firstTimeGen) {
        super.updateStructureState(parStructure, firstTimeGen);
        this.healthCur = this.getStructureHealth(parStructure, firstTimeGen);
    }

    public int getStructureHealth(List<ChunkCoordinatesBlock> parStructure, boolean andUpdateMaxHealth) {
        float totalHealthCur = 0.0f;
        float totalHealthMax = 0.0f;
        WorldServer world = DimensionManager.getWorld((int)this.location.dimID);
        int blockCount = 0;
        if (world != null) {
            for (int i = 0; i < parStructure.size(); ++i) {
                ChunkCoordinatesBlock coords = parStructure.get(i);
                int x = coords.field_71574_a;
                int y = coords.field_71572_b;
                int z = coords.field_71573_c;
                Block id = world.func_147439_a(x, y, z);
                if (CoroUtilBlock.isAir(id)) continue;
                ++blockCount;
                System.out.println("TODO: BlockDataGrid usage");
            }
        }
        if (andUpdateMaxHealth) {
            this.healthMax = (int)totalHealthMax;
        }
        return (int)totalHealthCur;
    }

    @Override
    public void buildPattern(List<ChunkCoordinatesBlock> parStructure) {
        WorldServer world = DimensionManager.getWorld((int)this.location.dimID);
        if (world != null) {
            for (int i = 0; i < parStructure.size(); ++i) {
                ChunkCoordinatesBlock coords = parStructure.get(i);
                System.out.println("TODO: BlockDataGrid usage");
            }
        }
    }
}

