/*
 * Decompiled with CFR 0.152.
 */
package build;

import build.BuildMod;
import build.EventHandlerPacket;
import build.config.BuildConfig;
import build.enums.EnumBuildState;
import build.enums.EnumCopyState;
import build.render.Overlays;
import build.world.Build;
import cpw.mods.fml.client.FMLClientHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class BuildClientTicks {
    public EnumBuildState buildState = EnumBuildState.NORMAL;
    public EnumCopyState copyState = EnumCopyState.NORMAL;
    public Build clipboardData = new Build(0, 0, 0, "clipboard", true);
    public MovingObjectPosition extendedMouseOver = null;
    public static BuildClientTicks i = new BuildClientTicks();
    public int direction = 0;
    public int lookDist = 20;
    public int lastPlayerSlot = 0;
    public boolean wasKeyDown = false;
    int sx;
    int sy;
    int sz;
    int ex;
    int ey;
    int ez;

    public BuildClientTicks() {
        this.clipboardData.newFormat = true;
    }

    public void worldRenderTick(float partialTicks) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc.field_71451_h != null) {
            this.extendedMouseOver = mc.field_71451_h.func_70614_a((double)this.lookDist, partialTicks);
            if (this.extendedMouseOver == null) {
                Vec3 vec3 = mc.field_71451_h.func_70666_h(partialTicks);
                Vec3 vec31 = mc.field_71451_h.func_70676_i(partialTicks);
                Vec3 vec32 = vec3.func_72441_c(vec31.field_72450_a * (double)this.lookDist, vec31.field_72448_b * (double)this.lookDist, vec31.field_72449_c * (double)this.lookDist);
                this.extendedMouseOver = new MovingObjectPosition((int)vec32.field_72450_a, (int)vec32.field_72448_b, (int)vec32.field_72449_c, 0, vec32);
            }
        }
        if (this.buildState == EnumBuildState.PLACE) {
            Overlays.renderBuildOutline(this.clipboardData, this.direction);
            Overlays.renderDirectionArrow(this.clipboardData, this.direction);
        } else if (this.copyState == EnumCopyState.SETMAX) {
            int x = MathHelper.func_76128_c((double)mc.field_71439_g.field_70165_t);
            int y = MathHelper.func_76128_c((double)(mc.field_71439_g.field_70163_u - (double)mc.field_71439_g.field_70129_M));
            int z = MathHelper.func_76128_c((double)mc.field_71439_g.field_70161_v);
            if (this.extendedMouseOver != null) {
                x = this.extendedMouseOver.field_72311_b;
                y = this.extendedMouseOver.field_72312_c;
                z = this.extendedMouseOver.field_72309_d;
            }
            Overlays.renderBuildOutline(this.sx, this.sy, this.sz, x, y, z);
        }
    }

    public void onRenderTick() {
        String mainStr = "";
        if (this.buildState == EnumBuildState.PLACE) {
            mainStr = "Paste Mode: (" + BuildConfig.key_Build + ") to paste, (" + BuildConfig.key_Rotate + ") to rotate, (" + BuildConfig.key_Copy + ") to cancel. Dir: " + this.direction;
        } else if (this.copyState == EnumCopyState.SETMIN) {
            mainStr = "Copy Mode: Mark start coord with (" + BuildConfig.key_Copy + "), (" + BuildConfig.key_Build + ") to cancel";
        } else if (this.copyState == EnumCopyState.SETMAX) {
            mainStr = "Copy Mode: Mark end coord with (" + BuildConfig.key_Copy + "), (" + BuildConfig.key_Build + ") to cancel";
        }
        Minecraft mc = FMLClientHandler.instance().getClient();
        ScaledResolution var8 = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
        int width = var8.func_78326_a();
        int height = var8.func_78328_b();
        int xOffset = width / 2;
        int yOffset = height - 50;
        int strWidth = mc.field_71466_p.func_78256_a(mainStr);
        mc.field_71466_p.func_78261_a(mainStr, xOffset - strWidth / 2, yOffset, 0xFFFFFF);
    }

    public void onTickInGUI(GuiScreen guiscreen) {
    }

    public void onTickInGame() {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc.field_71439_g == null || mc.field_71441_e == null) {
            return;
        }
        if (mc.field_71441_e != null) {
            this.clipboardData.dim = mc.field_71441_e.field_73011_w.field_76574_g;
        }
        if (this.buildState == EnumBuildState.PLACE) {
            if (this.extendedMouseOver != null) {
                if (mc.field_71439_g.func_70093_af()) {
                    this.clipboardData.setCornerPosition(this.extendedMouseOver.field_72311_b, MathHelper.func_76128_c((double)(mc.field_71439_g.field_70163_u - (double)mc.field_71439_g.field_70129_M)), this.extendedMouseOver.field_72309_d);
                } else {
                    this.clipboardData.setCornerPosition(this.extendedMouseOver.field_72311_b, this.extendedMouseOver.field_72312_c + 1, this.extendedMouseOver.field_72309_d);
                }
            } else {
                this.clipboardData.setCornerPosition(MathHelper.func_76128_c((double)mc.field_71439_g.field_70165_t), MathHelper.func_76128_c((double)(mc.field_71439_g.field_70163_u - (double)mc.field_71439_g.field_70129_M)), MathHelper.func_76128_c((double)mc.field_71439_g.field_70161_v));
            }
        }
        if (BuildConfig.enableEditMode && mc.field_71462_r == null) {
            this.updateInput();
        } else {
            this.copyState = EnumCopyState.NORMAL;
            this.buildState = EnumBuildState.NORMAL;
        }
    }

    public void updateInput() {
        int k = Mouse.getEventDWheel();
        if (k > 0) {
            k = 1;
        } else if (k < 0) {
            k = -1;
        }
        if (this.lastPlayerSlot != Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70461_c) {
            this.lastPlayerSlot = Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70461_c;
            if (k != 0) {
                this.lookDist += k * 1;
            }
        }
        if (Keyboard.isKeyDown((int)Keyboard.getKeyIndex((String)BuildConfig.key_Copy))) {
            if (this.buildState != EnumBuildState.NORMAL) {
                this.buildState = EnumBuildState.NORMAL;
            } else if (!this.wasKeyDown) {
                this.eventCopy();
            }
            this.wasKeyDown = true;
        } else if (Keyboard.isKeyDown((int)Keyboard.getKeyIndex((String)BuildConfig.key_Build))) {
            if (this.copyState != EnumCopyState.NORMAL) {
                this.copyState = EnumCopyState.NORMAL;
            } else if (!this.wasKeyDown) {
                this.eventBuild();
            }
            this.wasKeyDown = true;
        } else if (Keyboard.isKeyDown((int)Keyboard.getKeyIndex((String)BuildConfig.key_Rotate))) {
            if (!this.wasKeyDown && this.buildState == EnumBuildState.PLACE) {
                ++this.direction;
                if (this.direction > 3) {
                    this.direction = 0;
                }
            }
            this.wasKeyDown = true;
        } else {
            this.wasKeyDown = false;
        }
    }

    public void eventCopy() {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (this.copyState == EnumCopyState.NORMAL) {
            this.lookDist = 20;
            this.copyState = EnumCopyState.SETMIN;
        } else if (this.copyState == EnumCopyState.SETMIN) {
            this.copyState = EnumCopyState.SETMAX;
            this.sx = MathHelper.func_76128_c((double)mc.field_71439_g.field_70165_t);
            this.sy = (int)(mc.field_71439_g.field_70163_u - (double)mc.field_71439_g.field_70129_M);
            this.sz = MathHelper.func_76128_c((double)mc.field_71439_g.field_70161_v);
            if (this.extendedMouseOver != null) {
                this.sx = this.extendedMouseOver.field_72311_b;
                this.sy = this.extendedMouseOver.field_72312_c;
                this.sz = this.extendedMouseOver.field_72309_d;
            }
        } else {
            this.ex = MathHelper.func_76128_c((double)mc.field_71439_g.field_70165_t);
            this.ey = (int)(mc.field_71439_g.field_70163_u - (double)mc.field_71439_g.field_70129_M);
            this.ez = MathHelper.func_76128_c((double)mc.field_71439_g.field_70161_v);
            if (this.extendedMouseOver != null) {
                this.ex = this.extendedMouseOver.field_72311_b;
                this.ey = this.extendedMouseOver.field_72312_c;
                this.ez = this.extendedMouseOver.field_72309_d;
            }
            this.clipboardData.recalculateLevelSize(this.sx, this.sy, this.sz, this.ex, this.ey, this.ez, true);
            this.clipboardData.scanLevelToData((World)FMLClientHandler.instance().getClient().field_71441_e);
            this.clipboardData.writeNBT();
            BuildMod.eventChannel.sendToServer(EventHandlerPacket.getBuildCommandPacket(this.clipboardData, 0, -1));
            this.copyState = EnumCopyState.NORMAL;
        }
        System.out.println((Object)this.copyState);
    }

    public void eventBuild() {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (this.buildState == EnumBuildState.NORMAL) {
            this.buildState = EnumBuildState.PLACE;
        } else if (this.buildState == EnumBuildState.PLACE) {
            this.buildState = EnumBuildState.NORMAL;
            BuildMod.eventChannel.sendToServer(EventHandlerPacket.getBuildCommandPacket(this.clipboardData, 1, this.direction));
        }
    }
}

