/*
 * Decompiled with CFR 0.152.
 */
package modconfig;

import CoroUtil.OldUtil;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import modconfig.ConfigComment;
import modconfig.ConfigEntryInfo;
import modconfig.ConfigMod;
import modconfig.IConfigCategory;
import net.minecraftforge.common.config.Configuration;

public class ModConfigData {
    public String configID;
    public Class configClass;
    public IConfigCategory configInstance;
    public HashMap<String, String> valsString = new HashMap();
    public HashMap<String, Integer> valsInteger = new HashMap();
    public HashMap<String, Double> valsDouble = new HashMap();
    public HashMap<String, Boolean> valsBoolean = new HashMap();
    public List<ConfigEntryInfo> configData = new ArrayList<ConfigEntryInfo>();
    public Configuration preInitConfig;
    public File saveFilePath;

    public ModConfigData(File savePath, String parStr, Class parClass, IConfigCategory parConfig) {
        this.configID = parStr;
        this.configClass = parClass;
        this.configInstance = parConfig;
        this.saveFilePath = savePath;
    }

    public void updateHashMaps() {
        Field[] fields = this.configClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            String name = field.getName();
            this.processField(name);
        }
    }

    public void initData() {
        this.valsString.clear();
        this.valsInteger.clear();
        this.valsDouble.clear();
        this.valsBoolean.clear();
        this.updateHashMaps();
    }

    public boolean updateField(String name, Object obj) {
        if (this.setFieldBasedOnType(name, obj)) {
            this.writeConfigFile(true);
            return true;
        }
        return false;
    }

    public boolean setFieldBasedOnType(String name, Object obj) {
        try {
            if (this.valsString.containsKey(name)) {
                OldUtil.setPrivateValue(this.configClass, (Object)this.configInstance, name, (Object)((String)obj));
                this.inputField(name, (String)obj);
            } else if (this.valsInteger.containsKey(name)) {
                OldUtil.setPrivateValue(this.configClass, (Object)this.configInstance, name, (Object)Integer.valueOf(obj.toString()));
                this.inputField(name, Integer.valueOf(obj.toString()));
            } else if (this.valsDouble.containsKey(name)) {
                OldUtil.setPrivateValue(this.configClass, (Object)this.configInstance, name, (Object)Double.valueOf(obj.toString()));
                this.inputField(name, Double.valueOf(obj.toString()));
            } else if (this.valsBoolean.containsKey(name)) {
                OldUtil.setPrivateValue(this.configClass, (Object)this.configInstance, name, (Object)Boolean.valueOf(obj.toString()));
                this.inputField(name, Boolean.valueOf(obj.toString()));
            } else {
                return false;
            }
            this.configInstance.hookUpdatedValues();
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private void processField(String fieldName) {
        try {
            Object obj = ConfigMod.getField(this.configID, fieldName);
            if (obj instanceof String) {
                this.valsString.put(fieldName, (String)obj);
            } else if (obj instanceof Integer) {
                this.valsInteger.put(fieldName, (Integer)obj);
            } else if (obj instanceof Double) {
                this.valsDouble.put(fieldName, (Double)obj);
            } else if (obj instanceof Boolean) {
                this.valsBoolean.put(fieldName, (Boolean)obj);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void inputField(String fieldName, Object obj) {
        if (obj instanceof String) {
            this.valsString.put(fieldName, (String)obj);
        } else if (obj instanceof Integer) {
            this.valsInteger.put(fieldName, (Integer)obj);
        } else if (obj instanceof Double) {
            this.valsDouble.put(fieldName, (Double)obj);
        } else if (obj instanceof Boolean) {
            this.valsBoolean.put(fieldName, (Boolean)obj);
        }
    }

    public void writeConfigFile(boolean resetConfig) {
        if (resetConfig && this.saveFilePath.exists()) {
            this.saveFilePath.delete();
        }
        this.preInitConfig = new Configuration(this.saveFilePath);
        this.preInitConfig.load();
        Field[] fields = this.configClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            String name = field.getName();
            this.addToConfig(field, name);
        }
        this.preInitConfig.save();
    }

    private void addToConfig(Field field, String name) {
        Object obj;
        String comment = null;
        ConfigComment anno_comment = field.getAnnotation(ConfigComment.class);
        if (anno_comment != null) {
            comment = anno_comment.value()[0];
        }
        if ((obj = ConfigMod.getField(this.configID, name)) instanceof String) {
            obj = this.preInitConfig.get(this.configInstance.getCategory(), name, (String)obj, comment).getString();
        } else if (obj instanceof Integer) {
            obj = this.preInitConfig.get(this.configInstance.getCategory(), name, ((Integer)obj).intValue(), comment).getInt(((Integer)obj).intValue());
        } else if (obj instanceof Double) {
            obj = this.preInitConfig.get(this.configInstance.getCategory(), name, ((Double)obj).doubleValue(), comment).getDouble(((Double)obj).doubleValue());
        } else if (obj instanceof Boolean) {
            obj = this.preInitConfig.get(this.configInstance.getCategory(), name, ((Boolean)obj).booleanValue(), comment).getBoolean(((Boolean)obj).booleanValue());
        }
        this.setFieldBasedOnType(name, obj);
    }
}

