/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.network.annotation;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import uk.co.qmunity.lib.network.LocatedPacket;
import uk.co.qmunity.lib.network.annotation.PacketCUpdateGui;
import uk.co.qmunity.lib.network.annotation.SyncedField;
import uk.co.qmunity.lib.tile.TileBase;

public class PacketDescription
extends LocatedPacket<PacketDescription> {
    private byte[] types;
    private Object[] values;
    private NBTTagCompound extraData;

    public PacketDescription() {
    }

    public PacketDescription(TileBase te) {
        super(te.field_145851_c, te.field_145848_d, te.field_145849_e);
        this.values = new Object[te.getDescriptionFields().size()];
        this.types = new byte[this.values.length];
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = te.getDescriptionFields().get(i).getValue();
            this.types[i] = PacketCUpdateGui.getType(te.getDescriptionFields().get(i));
        }
        this.extraData = new NBTTagCompound();
        te.writeToPacketNBT(this.extraData);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.values.length);
        for (int i = 0; i < this.types.length; ++i) {
            buf.writeByte((int)this.types[i]);
            PacketCUpdateGui.writeField(buf, this.values[i], this.types[i]);
        }
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.extraData);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        int dataAmount = buf.readInt();
        this.types = new byte[dataAmount];
        this.values = new Object[dataAmount];
        for (int i = 0; i < dataAmount; ++i) {
            this.types[i] = buf.readByte();
            this.values[i] = PacketCUpdateGui.readField(buf, this.types[i]);
        }
        this.extraData = ByteBufUtils.readTag((ByteBuf)buf);
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        TileEntity te = this.getTileEntity(player.field_70170_p);
        if (te instanceof TileBase) {
            List<SyncedField> descFields = ((TileBase)te).getDescriptionFields();
            if (descFields != null && descFields.size() == this.types.length) {
                for (int i = 0; i < descFields.size(); ++i) {
                    descFields.get(i).setValue(this.values[i]);
                }
            }
            ((TileBase)te).readFromPacketNBT(this.extraData);
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

