/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.texture;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.awt.image.BufferedImage;
import java.io.InputStreamReader;
import java.io.Reader;

public class LayoutConfiguration {
    private int width;
    private int height;
    private int layouts = 1;

    protected LayoutConfiguration(BufferedImage img) throws Exception {
        if (img == null) {
            throw new Exception("You need a valid image in order to create a layout configuration.");
        }
        if (img.getWidth() != img.getHeight()) {
            throw new Exception("The layout isn't symmetrical and a .layout file isn't provided. Loading an empty layout!");
        }
        this.width = img.getWidth();
        this.height = img.getHeight();
    }

    protected LayoutConfiguration(BufferedImage img, String file) throws Exception {
        if (img == null) {
            throw new Exception("You need a valid image in order to create a layout configuration.");
        }
        this.width = img.getWidth();
        this.height = img.getHeight();
        JsonObject obj = null;
        try {
            obj = (JsonObject)new JsonParser().parse(new JsonReader((Reader)new InputStreamReader(this.getClass().getResourceAsStream(file))));
        }
        catch (Exception ex) {
            if (img.getWidth() != img.getHeight()) {
                throw new Exception("The layout isn't symmetrical and a .layout file isn't provided. Loading an empty layout!");
            }
            return;
        }
        if (obj.has("width") || obj.has("height")) {
            if (obj.has("width") != obj.has("height")) {
                throw new Exception("One of the layout size parameters hasn't been set. You need either none or both of them. Loading an empty layout!");
            }
            this.width = obj.getAsJsonPrimitive("width").getAsInt();
            this.height = obj.getAsJsonPrimitive("height").getAsInt();
        }
        if (obj.has("layouts")) {
            this.layouts = obj.getAsJsonPrimitive("layouts").getAsInt();
            if (this.layouts <= 0) {
                throw new Exception("You must have one or more layouts in the same file. Loading an empty layout!");
            }
            if (this.layouts * this.height > img.getHeight()) {
                throw new Exception("The height of an image of size <layouts> * <layout_height> (" + this.layouts * this.height + ") exceeds the layout image height (" + img.getHeight() + "). Loading an empty layout!");
            }
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getLayouts() {
        return this.layouts;
    }

    public BufferedImage getSubLayout(BufferedImage img, int id) {
        if (id >= this.layouts) {
            return null;
        }
        if (img.getWidth() != this.getWidth() || img.getHeight() % this.getHeight() != 0) {
            return null;
        }
        return img.getSubimage(0, id * this.getHeight(), this.getWidth(), this.getHeight());
    }
}

