/*
 * Decompiled with CFR 0.152.
 */
package uk.co.qmunity.lib.tile;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import uk.co.qmunity.lib.network.annotation.DescPacketHandler;
import uk.co.qmunity.lib.network.annotation.DescSynced;
import uk.co.qmunity.lib.network.annotation.NetworkUtils;
import uk.co.qmunity.lib.network.annotation.PacketDescription;
import uk.co.qmunity.lib.network.annotation.SyncedField;
import uk.co.qmunity.lib.tile.IRotatable;
import uk.co.qmunity.lib.util.QLog;
import uk.co.qmunity.lib.vec.IWorldLocation;

public class TileBase
extends TileEntity
implements IRotatable,
IWorldLocation {
    private boolean isRedstonePowered;
    private int outputtingRedstone;
    private int ticker = 0;
    private ForgeDirection rotation = ForgeDirection.UP;
    private List<SyncedField> descriptionFields;

    public void func_145839_a(NBTTagCompound tCompound) {
        super.func_145839_a(tCompound);
        this.isRedstonePowered = tCompound.func_74767_n("isRedstonePowered");
        this.readFromPacketNBT(tCompound);
    }

    public void func_145841_b(NBTTagCompound tCompound) {
        super.func_145841_b(tCompound);
        tCompound.func_74757_a("isRedstonePowered", this.isRedstonePowered);
        this.writeToPacketNBT(tCompound);
    }

    public void writeToPacketNBT(NBTTagCompound tCompound) {
        tCompound.func_74774_a("rotation", (byte)this.rotation.ordinal());
        tCompound.func_74774_a("outputtingRedstone", (byte)this.outputtingRedstone);
    }

    public void readFromPacketNBT(NBTTagCompound tCompound) {
        this.rotation = ForgeDirection.getOrientation((int)tCompound.func_74771_c("rotation"));
        if (this.rotation.ordinal() > 5) {
            QLog.warning("invalid rotation!");
            this.rotation = ForgeDirection.UP;
        }
        this.outputtingRedstone = tCompound.func_74771_c("outputtingRedstone");
        if (this.field_145850_b != null) {
            this.markForRenderUpdate();
        }
    }

    public List<SyncedField> getDescriptionFields() {
        if (this.descriptionFields == null) {
            this.descriptionFields = NetworkUtils.getSyncedFields(this, DescSynced.class);
            for (SyncedField field : this.descriptionFields) {
                field.update();
            }
        }
        return this.descriptionFields;
    }

    public Packet func_145844_m() {
        return DescPacketHandler.getPacket(new PacketDescription(this));
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readFromPacketNBT(pkt.func_148857_g());
    }

    protected void sendUpdatePacket() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    protected void markForRenderUpdate() {
        if (this.field_145850_b != null) {
            this.field_145850_b.func_147458_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    protected void notifyNeighborBlockUpdate() {
        this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
    }

    public void func_145845_h() {
        if (this.ticker == 0) {
            this.onTileLoaded();
        }
        super.func_145845_h();
        ++this.ticker;
        if (!this.field_145850_b.field_72995_K) {
            boolean descriptionPacketScheduled = false;
            if (this.descriptionFields == null) {
                descriptionPacketScheduled = true;
            }
            for (SyncedField field : this.getDescriptionFields()) {
                if (!field.update()) continue;
                descriptionPacketScheduled = true;
            }
            if (descriptionPacketScheduled) {
                this.sendUpdatePacket();
            }
        }
    }

    public void onBlockNeighbourChanged() {
        this.checkRedstonePower();
    }

    public void checkRedstonePower() {
        boolean isIndirectlyPowered = this.func_145831_w().func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (isIndirectlyPowered && !this.getIsRedstonePowered()) {
            this.redstoneChanged(true);
        } else if (this.getIsRedstonePowered() && !isIndirectlyPowered) {
            this.redstoneChanged(false);
        }
    }

    public void setOutputtingRedstone(boolean newValue) {
        this.setOutputtingRedstone(newValue ? 15 : 0);
    }

    public void setOutputtingRedstone(int value) {
        value = Math.max(0, value);
        if (this.outputtingRedstone != (value = Math.min(15, value))) {
            this.outputtingRedstone = value;
            this.notifyNeighborBlockUpdate();
        }
    }

    public int getOutputtingRedstone() {
        return this.outputtingRedstone;
    }

    protected void redstoneChanged(boolean newValue) {
        this.isRedstonePowered = newValue;
    }

    public boolean getIsRedstonePowered() {
        return this.isRedstonePowered;
    }

    public int getTicker() {
        return this.ticker;
    }

    protected void onTileLoaded() {
        if (!this.field_145850_b.field_72995_K) {
            this.onBlockNeighbourChanged();
        }
    }

    public List<ItemStack> getDrops() {
        return new ArrayList<ItemStack>();
    }

    @Override
    public void setFacingDirection(ForgeDirection dir) {
        this.rotation = dir;
        if (this.field_145850_b != null) {
            this.sendUpdatePacket();
            this.notifyNeighborBlockUpdate();
        }
    }

    @Override
    public ForgeDirection getFacingDirection() {
        return this.rotation;
    }

    public boolean canConnectRedstone() {
        return false;
    }

    public void onNeighborBlockChanged() {
    }

    @Override
    public World getWorld() {
        return this.field_145850_b;
    }

    @Override
    public int getX() {
        return this.field_145851_c;
    }

    @Override
    public int getY() {
        return this.field_145848_d;
    }

    @Override
    public int getZ() {
        return this.field_145849_e;
    }
}

