/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.tool;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.DimensionChunkCoords;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.ManualHelper;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.IESaveData;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.network.MessageMineralListSync;
import blusunrize.lib.manual.IManualPage;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.ManualPages;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ExcavatorHandler {
    public static LinkedHashMap<MineralMix, Integer> mineralList = new LinkedHashMap();
    public static HashMap<DimensionChunkCoords, MineralWorldInfo> mineralCache = new HashMap();
    private static HashMap<Integer, Integer> dimensionBasedTotalWeight = new HashMap();
    public static int mineralVeinCapacity = 0;
    @SideOnly(value=Side.CLIENT)
    static ManualInstance.ManualEntry mineralEntry;

    public static MineralMix addMineral(String name, int mineralWeight, float failChance, String[] ores, float[] chances) {
        assert (ores.length == chances.length);
        MineralMix mix = new MineralMix(name, failChance, ores, chances);
        mineralList.put(mix, mineralWeight);
        return mix;
    }

    public static void recalculateChances(boolean mutePackets) {
        for (Map.Entry<MineralMix, Integer> e : mineralList.entrySet()) {
            e.getKey().recalculateChances();
        }
        dimensionBasedTotalWeight.clear();
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            HashMap<MineralMix, Integer> packetMap = new HashMap<MineralMix, Integer>();
            for (Map.Entry<MineralMix, Integer> e : mineralList.entrySet()) {
                if (e.getKey() == null || e.getValue() == null) continue;
                packetMap.put(e.getKey(), e.getValue());
            }
            if (!mutePackets) {
                ImmersiveEngineering.packetHandler.sendToAll((IMessage)new MessageMineralListSync(packetMap));
            }
        }
    }

    public static int getDimensionTotalWeight(int dim) {
        if (dimensionBasedTotalWeight.containsKey(dim)) {
            return dimensionBasedTotalWeight.get(dim);
        }
        int totalWeight = 0;
        for (Map.Entry<MineralMix, Integer> e : mineralList.entrySet()) {
            e.getKey().recalculateChances();
            if (!e.getKey().isValid() || !e.getKey().validDimension(dim)) continue;
            totalWeight += e.getValue().intValue();
        }
        dimensionBasedTotalWeight.put(dim, totalWeight);
        return totalWeight;
    }

    public static MineralMix getRandomMineral(World world, int chunkX, int chunkZ) {
        if (world.field_72995_K) {
            return null;
        }
        MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo(world, chunkX, chunkZ);
        if (info == null || info.mineral == null && info.mineralOverride == null) {
            return null;
        }
        if (mineralVeinCapacity >= 0 && info.depletion > mineralVeinCapacity) {
            return null;
        }
        return info.mineralOverride != null ? info.mineralOverride : info.mineral;
    }

    public static MineralWorldInfo getMineralWorldInfo(World world, int chunkX, int chunkZ) {
        if (world.field_72995_K) {
            return null;
        }
        int dim = world.field_73011_w.field_76574_g;
        DimensionChunkCoords coords = new DimensionChunkCoords(dim, chunkX, chunkZ);
        MineralWorldInfo worldInfo = mineralCache.get((Object)coords);
        if (worldInfo == null) {
            MineralMix mix = null;
            Random r = world.func_72964_e(chunkX, chunkZ).func_76617_a(940610L);
            double dd = r.nextDouble();
            boolean empty = dd > 0.125;
            int query = r.nextInt();
            if (!empty) {
                int weight = Math.abs(query % ExcavatorHandler.getDimensionTotalWeight(dim));
                for (Map.Entry<MineralMix, Integer> e : mineralList.entrySet()) {
                    if (!e.getKey().isValid() || !e.getKey().validDimension(dim) || (weight -= e.getValue().intValue()) >= 0) continue;
                    mix = e.getKey();
                    break;
                }
            }
            worldInfo = new MineralWorldInfo();
            worldInfo.mineral = mix;
            mineralCache.put(coords, worldInfo);
        }
        return worldInfo;
    }

    public static void depleteMinerals(World world, int chunkX, int chunkZ) {
        MineralWorldInfo info = ExcavatorHandler.getMineralWorldInfo(world, chunkX, chunkZ);
        ++info.depletion;
        IESaveData.setDirty(world.field_73011_w.field_76574_g);
    }

    @SideOnly(value=Side.CLIENT)
    public static void handleMineralManual() {
        if (ManualHelper.getManual() != null) {
            ArrayList<ManualPages> pages = new ArrayList<ManualPages>();
            pages.add(new ManualPages.Text(ManualHelper.getManual(), "minerals0"));
            pages.add(new ManualPages.Crafting(ManualHelper.getManual(), "minerals1", new ItemStack((Block)IEContent.blockMetalDevice, 1, 14)));
            pages.add(new ManualPages.Text(ManualHelper.getManual(), "minerals2"));
            final MineralMix[] minerals = mineralList.keySet().toArray(new MineralMix[0]);
            ArrayList<Integer> mineralIndices = new ArrayList<Integer>();
            for (int i = 0; i < minerals.length; ++i) {
                if (!minerals[i].isValid()) continue;
                mineralIndices.add(i);
            }
            Collections.sort(mineralIndices, new Comparator<Integer>(){

                @Override
                public int compare(Integer paramT1, Integer paramT2) {
                    String name2;
                    String localizedName2;
                    String name1 = "desc.ImmersiveEngineering.info.mineral." + minerals[paramT1.intValue()].name;
                    String localizedName1 = StatCollector.func_74838_a((String)name1);
                    if (localizedName1 == name1) {
                        localizedName1 = minerals[paramT1.intValue()].name;
                    }
                    if ((localizedName2 = StatCollector.func_74838_a((String)(name2 = "desc.ImmersiveEngineering.info.mineral." + minerals[paramT2.intValue()].name))) == name2) {
                        localizedName2 = minerals[paramT2.intValue()].name;
                    }
                    return localizedName1.compareToIgnoreCase(localizedName2);
                }
            });
            Iterator iterator = mineralIndices.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                String name = "desc.ImmersiveEngineering.info.mineral." + minerals[i].name;
                String localizedName = StatCollector.func_74838_a((String)name);
                if (localizedName == name) {
                    localizedName = minerals[i].name;
                }
                String s0 = "";
                if (minerals[i].dimensionWhitelist != null && minerals[i].dimensionWhitelist.length > 0) {
                    String validDims = "";
                    for (int dim : minerals[i].dimensionWhitelist) {
                        validDims = validDims + (!validDims.isEmpty() ? ", " : "") + "<dim;" + dim + ">";
                    }
                    s0 = StatCollector.func_74837_a((String)"ie.manual.entry.mineralsDimValid", (Object[])new Object[]{localizedName, validDims});
                } else if (minerals[i].dimensionBlacklist != null && minerals[i].dimensionBlacklist.length > 0) {
                    String invalidDims = "";
                    for (int dim : minerals[i].dimensionBlacklist) {
                        invalidDims = invalidDims + (!invalidDims.isEmpty() ? ", " : "") + "<dim;" + dim + ">";
                    }
                    s0 = StatCollector.func_74837_a((String)"ie.manual.entry.mineralsDimInvalid", (Object[])new Object[]{localizedName, invalidDims});
                } else {
                    s0 = StatCollector.func_74837_a((String)"ie.manual.entry.mineralsDimAny", (Object[])new Object[]{localizedName});
                }
                ArrayList<Integer> formattedOutputs = new ArrayList<Integer>();
                for (int j = 0; j < minerals[i].oreOutput.length; ++j) {
                    formattedOutputs.add(j);
                }
                final int fi = i;
                Collections.sort(formattedOutputs, new Comparator<Integer>(){

                    @Override
                    public int compare(Integer paramT1, Integer paramT2) {
                        return -Double.compare(minerals[fi].recalculatedChances[paramT1], minerals[fi].recalculatedChances[paramT2]);
                    }
                });
                String s1 = "";
                ItemStack[] sortedOres = new ItemStack[minerals[i].oreOutput.length];
                for (int j = 0; j < formattedOutputs.size(); ++j) {
                    if (minerals[i].oreOutput[j] == null) continue;
                    int sorted = (Integer)formattedOutputs.get(j);
                    s1 = s1 + "<br>" + Utils.formatDouble(minerals[i].recalculatedChances[sorted] * 100.0f, "00.00").replaceAll("\\G0", " ") + "% " + minerals[i].oreOutput[sorted].func_82833_r();
                    sortedOres[j] = minerals[i].oreOutput[sorted];
                }
                String s2 = StatCollector.func_74837_a((String)"ie.manual.entry.minerals3", (Object[])new Object[]{s0, s1});
                pages.add(new ManualPages.ItemDisplay(ManualHelper.getManual(), s2, sortedOres));
            }
            if (mineralEntry != null) {
                mineralEntry.setPages(pages.toArray(new IManualPage[pages.size()]));
            } else {
                ManualHelper.addEntry("minerals", ManualHelper.CAT_GENERAL, pages.toArray(new IManualPage[pages.size()]));
                mineralEntry = ManualHelper.getManual().getEntry("minerals");
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    static String[][][] formatToTable_ExcavatorMinerals() {
        MineralMix[] minerals = mineralList.keySet().toArray(new MineralMix[0]);
        String[][][] multiTables = new String[1][minerals.length][2];
        int curTable = 0;
        int totalLines = 0;
        for (int i = 0; i < minerals.length; ++i) {
            if (!minerals[i].isValid()) continue;
            String name = "desc.ImmersiveEngineering.info.mineral." + minerals[i].name;
            if (StatCollector.func_74838_a((String)name) == name) {
                name = minerals[i].name;
            }
            multiTables[curTable][i][0] = name;
            multiTables[curTable][i][1] = "";
            for (int j = 0; j < minerals[i].oreOutput.length; ++j) {
                if (minerals[i].oreOutput[j] == null) continue;
                String[] stringArray = multiTables[curTable][i];
                stringArray[1] = stringArray[1] + minerals[i].oreOutput[j].func_82833_r() + " " + Utils.formatDouble(minerals[i].recalculatedChances[j] * 100.0f, "#.00") + "%" + (j < minerals[i].oreOutput.length - 1 ? "\n" : "");
                ++totalLines;
            }
            if (i >= minerals.length - 1 || totalLines + minerals[i + 1].oreOutput.length < 13) continue;
            String[][][] newMultiTables = new String[multiTables.length + 1][minerals.length][2];
            System.arraycopy(multiTables, 0, newMultiTables, 0, multiTables.length);
            multiTables = newMultiTables;
            totalLines = 0;
            ++curTable;
        }
        return multiTables;
    }

    public static class MineralWorldInfo {
        public MineralMix mineral;
        public MineralMix mineralOverride;
        public int depletion;

        public NBTTagCompound writeToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            if (this.mineral != null) {
                tag.func_74778_a("mineral", this.mineral.name);
            }
            if (this.mineralOverride != null) {
                tag.func_74778_a("mineralOverride", this.mineralOverride.name);
            }
            tag.func_74768_a("depletion", this.depletion);
            return tag;
        }

        public static MineralWorldInfo readFromNBT(NBTTagCompound tag) {
            String s;
            MineralWorldInfo info = new MineralWorldInfo();
            if (tag.func_74764_b("mineral")) {
                s = tag.func_74779_i("mineral");
                for (MineralMix mineral : mineralList.keySet()) {
                    if (!s.equalsIgnoreCase(mineral.name)) continue;
                    info.mineral = mineral;
                }
            }
            if (tag.func_74764_b("mineralOverride")) {
                s = tag.func_74779_i("mineralOverride");
                for (MineralMix mineral : mineralList.keySet()) {
                    if (!s.equalsIgnoreCase(mineral.name)) continue;
                    info.mineralOverride = mineral;
                }
            }
            info.depletion = tag.func_74762_e("depletion");
            return info;
        }
    }

    public static class MineralMix {
        public String name;
        public float failChance;
        public String[] ores;
        public float[] chances;
        public ItemStack[] oreOutput;
        public float[] recalculatedChances;
        boolean isValid = false;
        public HashMap<String, String> replacementOres;
        public int[] dimensionWhitelist = new int[0];
        public int[] dimensionBlacklist = new int[0];

        public MineralMix(String name, float failChance, String[] ores, float[] chances) {
            this.name = name;
            this.failChance = failChance;
            this.ores = ores;
            this.chances = chances;
        }

        public MineralMix addReplacement(String original, String replacement) {
            if (this.replacementOres == null) {
                this.replacementOres = new HashMap();
            }
            this.replacementOres.put(original, replacement);
            return this;
        }

        public void recalculateChances() {
            int i;
            double chanceSum = 0.0;
            ArrayList<ItemStack> existing = new ArrayList<ItemStack>();
            ArrayList<Double> reChances = new ArrayList<Double>();
            for (i = 0; i < this.ores.length; ++i) {
                ItemStack preferredOre;
                String ore = this.ores[i];
                if (this.replacementOres != null && !ApiUtils.isExistingOreName(ore) && this.replacementOres.containsKey(ore)) {
                    ore = this.replacementOres.get(ore);
                }
                if (ore == null || ore.isEmpty() || !ApiUtils.isExistingOreName(ore) || (preferredOre = IEApi.getPreferredOreStack(ore)) == null) continue;
                existing.add(preferredOre);
                reChances.add(Double.valueOf(this.chances[i]));
                chanceSum += (double)this.chances[i];
            }
            this.isValid = existing.size() > 0;
            this.oreOutput = existing.toArray(new ItemStack[existing.size()]);
            this.recalculatedChances = new float[reChances.size()];
            for (i = 0; i < reChances.size(); ++i) {
                this.recalculatedChances[i] = (float)((Double)reChances.get(i) / chanceSum);
            }
        }

        public ItemStack getRandomOre(Random rand) {
            float r = rand.nextFloat();
            for (int i = 0; i < this.recalculatedChances.length; ++i) {
                if (!((r -= this.recalculatedChances[i]) < 0.0f)) continue;
                return this.oreOutput[i];
            }
            return null;
        }

        public boolean isValid() {
            return this.isValid;
        }

        public boolean validDimension(int dim) {
            if (this.dimensionWhitelist != null && this.dimensionWhitelist.length > 0) {
                for (int white : this.dimensionWhitelist) {
                    if (dim != white) continue;
                    return true;
                }
                return false;
            }
            if (this.dimensionBlacklist != null && this.dimensionBlacklist.length > 0) {
                for (int black : this.dimensionBlacklist) {
                    if (dim != black) continue;
                    return false;
                }
                return true;
            }
            return true;
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("name", this.name);
            tag.func_74776_a("failChance", this.failChance);
            NBTTagList tagList = new NBTTagList();
            for (String string : this.ores) {
                tagList.func_74742_a((NBTBase)new NBTTagString(string));
            }
            tag.func_74782_a("ores", (NBTBase)tagList);
            tagList = new NBTTagList();
            for (float f : this.chances) {
                tagList.func_74742_a((NBTBase)new NBTTagFloat(f));
            }
            tag.func_74782_a("chances", (NBTBase)tagList);
            tagList = new NBTTagList();
            if (this.oreOutput != null) {
                for (ItemStack itemStack : this.oreOutput) {
                    tagList.func_74742_a((NBTBase)itemStack.func_77955_b(new NBTTagCompound()));
                }
            }
            tag.func_74782_a("oreOutput", (NBTBase)tagList);
            tagList = new NBTTagList();
            for (float f : this.recalculatedChances) {
                tagList.func_74742_a((NBTBase)new NBTTagFloat(f));
            }
            tag.func_74782_a("recalculatedChances", (NBTBase)tagList);
            tag.func_74757_a("isValid", this.isValid);
            tag.func_74783_a("dimensionWhitelist", this.dimensionWhitelist);
            tag.func_74783_a("dimensionBlacklist", this.dimensionBlacklist);
            return tag;
        }

        public static MineralMix readFromNBT(NBTTagCompound tag) {
            String name = tag.func_74779_i("name");
            float failChance = tag.func_74760_g("failChance");
            NBTTagList tagList = tag.func_150295_c("ores", 8);
            String[] ores = new String[tagList.func_74745_c()];
            for (int i = 0; i < ores.length; ++i) {
                ores[i] = tagList.func_150307_f(i);
            }
            tagList = tag.func_150295_c("chances", 5);
            float[] chances = new float[tagList.func_74745_c()];
            for (int i = 0; i < chances.length; ++i) {
                chances[i] = tagList.func_150308_e(i);
            }
            tagList = tag.func_150295_c("oreOutput", 10);
            ItemStack[] oreOutput = new ItemStack[tagList.func_74745_c()];
            for (int i = 0; i < oreOutput.length; ++i) {
                oreOutput[i] = ItemStack.func_77949_a((NBTTagCompound)tagList.func_150305_b(i));
            }
            tagList = tag.func_150295_c("recalculatedChances", 5);
            float[] recalculatedChances = new float[tagList.func_74745_c()];
            for (int i = 0; i < recalculatedChances.length; ++i) {
                recalculatedChances[i] = tagList.func_150308_e(i);
            }
            boolean isValid = tag.func_74767_n("isValid");
            MineralMix mix = new MineralMix(name, failChance, ores, chances);
            mix.oreOutput = oreOutput;
            mix.recalculatedChances = recalculatedChances;
            mix.isValid = isValid;
            mix.dimensionWhitelist = tag.func_74759_k("dimensionWhitelist");
            mix.dimensionBlacklist = tag.func_74759_k("dimensionBlacklist");
            return mix;
        }
    }
}

