/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.opencomputers;

import blusunrize.immersiveengineering.api.energy.DieselHandler;
import blusunrize.immersiveengineering.common.blocks.TileEntityIEBase;
import blusunrize.immersiveengineering.common.blocks.metal.TileEntityRefinery;
import blusunrize.immersiveengineering.common.util.compat.opencomputers.ManagedEnvironmentIE;
import java.util.HashMap;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.prefab.DriverTileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class RefineryDriver
extends DriverTileEntity {
    public ManagedEnvironment createEnvironment(World w, int x, int y, int z) {
        int pos;
        TileEntity te = w.func_147438_o(x, y, z);
        if (te instanceof TileEntityRefinery && (pos = ((TileEntityRefinery)te).pos) == 9) {
            TileEntityRefinery ref = (TileEntityRefinery)te;
            return new RefineryEnvironment(w, ref.field_145851_c - ref.offset[0], ref.field_145848_d - ref.offset[1], ref.field_145849_e - ref.offset[2], TileEntityRefinery.class);
        }
        return null;
    }

    public Class<?> getTileEntityClass() {
        return TileEntityRefinery.class;
    }

    public class RefineryEnvironment
    extends ManagedEnvironmentIE<TileEntityRefinery> {
        public String preferredName() {
            return "ie_refinery";
        }

        public int priority() {
            return 1000;
        }

        public RefineryEnvironment(World w, int x, int y, int z, Class<? extends TileEntityIEBase> teClass) {
            super(w, x, y, z, teClass);
        }

        public void onConnect(Node node) {
            TileEntityRefinery master = (TileEntityRefinery)this.getTileEntity();
            if (master != null) {
                master.computerControlled = true;
                master.computerOn = true;
            }
        }

        public void onDisconnect(Node node) {
            TileEntityRefinery te = (TileEntityRefinery)this.getTileEntity();
            if (te != null) {
                te.computerControlled = false;
            }
        }

        @Callback(doc="function(enable:boolean) -- enable or disable the refinery")
        public Object[] setEnabled(Context context, Arguments args) {
            ((TileEntityRefinery)this.getTileEntity()).computerOn = args.checkBoolean(0);
            return null;
        }

        @Callback(doc="function():number -- get energy storage capacity")
        public Object[] getEnergyStored(Context context, Arguments args) {
            return new Object[]{((TileEntityRefinery)this.getTileEntity()).energyStorage.getEnergyStored()};
        }

        @Callback(doc="function():number -- get currently stored energy")
        public Object[] getMaxEnergyStored(Context context, Arguments args) {
            return new Object[]{((TileEntityRefinery)this.getTileEntity()).energyStorage.getMaxEnergyStored()};
        }

        @Callback(doc="function():table -- get tankinfo for input tanks")
        public Object[] getInputFluidTanks(Context context, Arguments args) {
            TileEntityRefinery master = (TileEntityRefinery)this.getTileEntity();
            HashMap<String, FluidTankInfo> ret = new HashMap<String, FluidTankInfo>(2);
            ret.put("input1", master.tank0.getInfo());
            ret.put("input2", master.tank1.getInfo());
            return new Object[]{ret};
        }

        @Callback(doc="function():table -- get tankinfo for output tank")
        public Object[] getOutputTank(Context context, Arguments args) {
            return new Object[]{((TileEntityRefinery)this.getTileEntity()).tank2.getInfo()};
        }

        @Callback(doc="function():table -- get current recipe")
        public Object[] getRecipe(Context context, Arguments args) {
            DieselHandler.RefineryRecipe recipe = ((TileEntityRefinery)this.getTileEntity()).getRecipe(false);
            if (recipe == null) {
                throw new IllegalArgumentException("The recipe of the refinery is invalid");
            }
            HashMap<String, FluidStack> ret = new HashMap<String, FluidStack>(3);
            ret.put("input1", recipe.input0);
            ret.put("input2", recipe.input1);
            ret.put("output", recipe.output);
            return new Object[]{ret};
        }

        @Callback(doc="function():boolean -- check whether a valid recipe exists for the current inputs")
        public Object[] isValidRecipe(Context context, Arguments args) {
            return new Object[]{((TileEntityRefinery)this.getTileEntity()).getRecipe(false) != null};
        }

        @Callback(doc="function():table -- return item input slot contents for both input and output tanks")
        public Object[] getEmptyCannister(Context context, Arguments args) {
            TileEntityRefinery te = (TileEntityRefinery)this.getTileEntity();
            HashMap<String, ItemStack> ret = new HashMap<String, ItemStack>(3);
            ret.put("input1", te.inventory[1]);
            ret.put("input2", te.inventory[3]);
            ret.put("output", te.inventory[4]);
            return new Object[]{ret};
        }

        @Callback(doc="function():table -- return item output slot contents for both input and output tanks")
        public Object[] getFullCannisters(Context context, Arguments args) {
            TileEntityRefinery te = (TileEntityRefinery)this.getTileEntity();
            HashMap<String, ItemStack> ret = new HashMap<String, ItemStack>(3);
            ret.put("input1", te.inventory[0]);
            ret.put("input2", te.inventory[2]);
            ret.put("output", te.inventory[5]);
            return new Object[]{ret};
        }
    }
}

