/*
 * Decompiled with CFR 0.152.
 */
package io.endertech.multiblock;

import io.endertech.multiblock.IMultiblockPart;
import io.endertech.multiblock.MultiblockControllerBase;
import io.endertech.multiblock.MultiblockWorldRegistry;
import io.endertech.util.helper.LocalisationHelper;
import io.endertech.util.helper.LogHelper;
import java.util.HashMap;
import net.minecraft.world.World;

public class MultiblockRegistry {
    private static HashMap<World, MultiblockWorldRegistry> registries = new HashMap();

    public static void tickStart(World world) {
        if (registries.containsKey(world)) {
            MultiblockWorldRegistry registry = registries.get(world);
            registry.tickStart();
        }
    }

    public static void tickEnd(World world) {
        if (registries.containsKey(world)) {
            MultiblockWorldRegistry registry = registries.get(world);
            registry.tickEnd();
        }
    }

    public static void onChunkLoaded(World world, int chunkX, int chunkZ) {
        if (registries.containsKey(world)) {
            registries.get(world).onChunkLoaded(chunkX, chunkZ);
        }
    }

    public static void onPartAdded(World world, IMultiblockPart part) {
        MultiblockWorldRegistry registry = MultiblockRegistry.getOrCreateRegistry(world);
        registry.onPartAdded(part);
    }

    public static void onPartRemovedFromWorld(World world, IMultiblockPart part) {
        if (registries.containsKey(world)) {
            registries.get(world).onPartRemovedFromWorld(part);
        }
    }

    public static void onWorldUnloaded(World world) {
        if (registries.containsKey(world)) {
            registries.get(world).onWorldUnloaded();
            registries.remove(world);
        }
    }

    public static void addDirtyController(World world, MultiblockControllerBase controller) {
        if (!registries.containsKey(world)) {
            throw new IllegalArgumentException("Adding a dirty controller to a world that has no registered controllers!");
        }
        registries.get(world).addDirtyController(controller);
    }

    public static void addDeadController(World world, MultiblockControllerBase controller) {
        if (registries.containsKey(world)) {
            registries.get(world).addDeadController(controller);
        } else {
            LogHelper.warn(LocalisationHelper.localiseString("warning.multiblock.controller.dead_but_world_not_tracked", controller.hashCode(), world), new Object[0]);
        }
    }

    private static MultiblockWorldRegistry getOrCreateRegistry(World world) {
        if (registries.containsKey(world)) {
            return registries.get(world);
        }
        MultiblockWorldRegistry newRegistry = new MultiblockWorldRegistry(world);
        registries.put(world, newRegistry);
        return newRegistry;
    }
}

