/*
 * Decompiled with CFR 0.152.
 */
package io.endertech.tile;

import cofh.lib.util.helpers.ServerHelper;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.endertech.config.GeneralConfig;
import io.endertech.fx.EntityHealthPadFX;
import io.endertech.gui.client.GuiHealthPad;
import io.endertech.gui.container.ContainerHealthPad;
import io.endertech.network.PacketETBase;
import io.endertech.tile.TilePad;
import io.endertech.util.helper.LocalisationHelper;
import io.endertech.util.helper.StringHelper;
import java.util.List;
import java.util.Random;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class TileHealthPad
extends TilePad {
    public static final int[] RECEIVE = new int[]{0, 2000, 20000};
    public static final int[] CAPACITY = new int[]{-1, 2000000, 10000000};
    public static final int[] TICKS_PER_HEAL = new int[]{10, 40, 20};
    public static byte particleSkip = 0;
    public int ticksSinceLastHealthSent = 0;
    public float sentHealth = 0.0f;

    public TileHealthPad() {
        this.tileName = "Health Pad";
    }

    public static void init() {
        GameRegistry.registerTileEntity(TileHealthPad.class, (String)"tile.healthPad");
    }

    @Override
    public int getMaxEnergyStored(int meta) {
        return CAPACITY[meta];
    }

    @Override
    public int getMaxReceiveRate(int meta) {
        return RECEIVE[meta];
    }

    @Override
    public int getMaxSendRate(int meta) {
        return GeneralConfig.healthPadChargeCostPerHalfHeart * 2;
    }

    public String toString() {
        return "Health Pad: position " + this.field_145851_c + ", " + this.field_145848_d + ", " + this.field_145849_e;
    }

    public void func_145845_h() {
        int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        boolean bl = this.isCreative = meta == 0;
        if (ServerHelper.isServerWorld(this.field_145850_b)) {
            boolean oldActive = this.isActive;
            this.isActive = this.sentHealth > 0.0f;
            this.sentHealth = 0.0f;
            int totalChargeUseable = this.extractEnergy(this.getMaxSendRate(meta), meta, true);
            float totalHealthSendable = MathHelper.func_76141_d((float)((float)totalChargeUseable / (float)GeneralConfig.healthPadChargeCostPerHalfHeart));
            if (this.isCreative) {
                totalHealthSendable = 8.0f;
            }
            if (totalHealthSendable >= 1.0f) {
                AxisAlignedBB front = this.getAABBInFront(2);
                List healableEntitiesInRange = this.field_145850_b.func_72872_a(EntityLivingBase.class, front);
                int healableEntityCount = healableEntitiesInRange.size();
                if (healableEntityCount > 0) {
                    float healthPerEntity = MathHelper.func_76141_d((float)(1.0f / (float)healableEntityCount));
                    for (EntityLivingBase entity : healableEntitiesInRange) {
                        if (!(entity.func_110143_aJ() < entity.func_110138_aP() && entity.func_70089_S()) && !GeneralConfig.healthPadForceAlwaysSendHealth) continue;
                        float efficiency = (float)this.calculateEfficiencyForEntity((Entity)entity);
                        if (this.ticksSinceLastHealthSent > TICKS_PER_HEAL[meta] && this.field_145850_b.field_73012_v.nextInt(TICKS_PER_HEAL[meta] / 4) == 0) {
                            int costForHalfHeart = MathHelper.func_76141_d((float)((float)GeneralConfig.healthPadChargeCostPerHalfHeart * healthPerEntity));
                            costForHalfHeart = (int)((float)costForHalfHeart + (1.0f - efficiency) * (float)costForHalfHeart);
                            int couldExtract = this.extractEnergy(costForHalfHeart, meta, true);
                            if (this.isCreative || couldExtract == costForHalfHeart) {
                                this.extractEnergy(costForHalfHeart, meta, false);
                                entity.func_70691_i(1.0f);
                                this.ticksSinceLastHealthSent = 0;
                            }
                        } else if (this.ticksSinceLastHealthSent < 100) {
                            ++this.ticksSinceLastHealthSent;
                        }
                        this.sentHealth += healthPerEntity * efficiency;
                    }
                } else {
                    this.ticksSinceLastHealthSent = 0;
                }
            }
            this.chargeFromGUISlot();
            boolean shouldSendUpdate = false;
            boolean bl2 = shouldSendUpdate = shouldSendUpdate || this.isActive != oldActive;
            if (this.ticksSinceLastUpdate == 20) {
                this.ticksSinceLastUpdate = 0;
                shouldSendUpdate = true;
            }
            if (shouldSendUpdate) {
                this.sendDescriptionPacket();
            }
            this.ticksSinceLastUpdate = (short)(this.ticksSinceLastUpdate + 1);
            if (this.ticksSinceLastUpdate > 20) {
                this.ticksSinceLastUpdate = (short)20;
            }
        }
        if (this.sentHealth > 0.0f && ServerHelper.isClientWorld(this.field_145850_b) && (particleSkip = (byte)(particleSkip + 1)) == 3) {
            this.spawnParticles(meta);
            particleSkip = 0;
        }
    }

    @Override
    public PacketETBase getPacket() {
        PacketETBase packet = super.getPacket();
        packet.addFloat(this.sentHealth);
        packet.addInt(this.ticksSinceLastHealthSent);
        return packet;
    }

    @Override
    public void handleTilePacket(PacketETBase tilePacket, boolean isServer) {
        super.handleTilePacket(tilePacket, isServer);
        float sentHealth = tilePacket.getFloat();
        int ticksSinceLastHealthSent = tilePacket.getInt();
        if (!isServer) {
            this.sentHealth = sentHealth;
            this.ticksSinceLastHealthSent = ticksSinceLastHealthSent;
        }
    }

    @Override
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip) {
        if (this.isActive) {
            currenttip.add(EnumChatFormatting.GREEN + LocalisationHelper.localiseString("info.active", new Object[0]) + EnumChatFormatting.RESET);
        } else {
            currenttip.add(EnumChatFormatting.RED + LocalisationHelper.localiseString("info.inactive", new Object[0]) + EnumChatFormatting.RESET);
        }
        int blockMeta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (this.isCreative) {
            currenttip.add(LocalisationHelper.localiseString("info.charge", "Infinite"));
        } else {
            currenttip.add(LocalisationHelper.localiseString("info.charge", StringHelper.getEnergyString(this.storedEnergy) + " / " + StringHelper.getEnergyString(this.getMaxEnergyStored(blockMeta)) + " RF"));
        }
        return currenttip;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void spawnParticles(int meta) {
        EffectRenderer er = FMLClientHandler.instance().getClient().field_71452_i;
        ForgeDirection orientation = this.getOrientation();
        Random rand = this.field_145850_b.field_73012_v;
        for (int particle = this.getParticleCount(meta); particle > 0; --particle) {
            double xSign = rand.nextBoolean() ? -1 : 1;
            double ySign = rand.nextBoolean() ? -1 : 1;
            double zSign = rand.nextBoolean() ? -1 : 1;
            double xAddition = xSign * (rand.nextDouble() * 0.3) + 0.05 * xSign;
            double yAddition = ySign * (rand.nextDouble() * 0.3) + 0.05 * ySign;
            double zAddition = zSign * (rand.nextDouble() * 0.3) + 0.05 * zSign;
            double x = (double)((float)this.field_145851_c + 0.5f * (float)orientation.offsetX) + 0.5 + xAddition;
            double y = (double)((float)this.field_145848_d + 0.5f * (float)orientation.offsetY) + 0.5 + yAddition;
            double z = (double)((float)this.field_145849_e + 0.5f * (float)orientation.offsetZ) + 0.5 + zAddition;
            EntityHealthPadFX particleFX = new EntityHealthPadFX(this.field_145850_b, x, y, z, this.getParticleMaxAge(), this.getParticleVelocity(), this.getParticleColour(rand), this.getParticleSizeModifier(meta));
            er.func_78873_a((EntityFX)particleFX);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getParticleMaxAge() {
        return 16;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public double[] getParticleVelocity() {
        ForgeDirection orientation = this.getOrientation();
        return new double[]{(double)orientation.offsetX * 0.15, (double)orientation.offsetY * 0.15, (double)orientation.offsetZ * 0.15};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float[] getParticleColour(Random rand) {
        if (this.isItemInChargeSlotTuberous()) {
            return this.getRainbowParticleColour(rand);
        }
        float r = 1.0f;
        float g = 0.0f + rand.nextFloat() * 0.25f;
        float b = 0.0f + rand.nextFloat() * 0.25f;
        return new float[]{r, g, b};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getParticleCount(int meta) {
        if (meta == 0) {
            return 2;
        }
        if (meta == 2) {
            return 2;
        }
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float getParticleSizeModifier(int meta) {
        if (meta == 0) {
            return 0.9f;
        }
        if (meta == 2) {
            return 0.75f;
        }
        return 0.6f;
    }

    @Override
    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiHealthPad(inventory, this);
    }

    @Override
    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerHealthPad(inventory, this);
    }
}

