/*
 * Decompiled with CFR 0.152.
 */
package li.cil.oc;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import com.typesafe.config.impl.OpenComputersConfigCommentManipulationHook;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.VersionRange;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import li.cil.oc.OpenComputers$;
import li.cil.oc.Settings;
import li.cil.oc.Settings$;
import li.cil.oc.api.internal.TextBuffer;
import org.apache.commons.lang3.StringEscapeUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.convert.WrapAsScala$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.MutableList;
import scala.collection.mutable.MutableList$;
import scala.collection.mutable.StringBuilder;
import scala.compat.Platform$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.sys.package$;
import scala.util.matching.Regex;
import scala.util.matching.Regex$;

public final class Settings$ {
    public static final Settings$ MODULE$;
    private final String resourceDomain;
    private final String namespace;
    private final String savePath;
    private final String scriptPath;
    private final Tuple2<Object, Object>[] screenResolutionsByTier;
    private final TextBuffer.ColorDepth[] screenDepthsByTier;
    private final int[] deviceComplexityByTier;
    private boolean rTreeDebugRenderer;
    private int blockRenderId;
    private final List<String> forbiddenConfigLists;
    private final String li$cil$oc$Settings$$prefix;
    private Settings settings;
    private final Tuple2<VersionRange, String[]>[] configPatches;
    private final VersionRange fileringRulesPatchVersion;

    static {
        new Settings$();
    }

    public String resourceDomain() {
        return this.resourceDomain;
    }

    public String namespace() {
        return this.namespace;
    }

    public String savePath() {
        return this.savePath;
    }

    public String scriptPath() {
        return this.scriptPath;
    }

    public Tuple2<Object, Object>[] screenResolutionsByTier() {
        return this.screenResolutionsByTier;
    }

    public TextBuffer.ColorDepth[] screenDepthsByTier() {
        return this.screenDepthsByTier;
    }

    public int[] deviceComplexityByTier() {
        return this.deviceComplexityByTier;
    }

    public boolean rTreeDebugRenderer() {
        return this.rTreeDebugRenderer;
    }

    public void rTreeDebugRenderer_$eq(boolean x$1) {
        this.rTreeDebugRenderer = x$1;
    }

    public int blockRenderId() {
        return this.blockRenderId;
    }

    public void blockRenderId_$eq(int x$1) {
        this.blockRenderId = x$1;
    }

    private List<String> forbiddenConfigLists() {
        return this.forbiddenConfigLists;
    }

    public String li$cil$oc$Settings$$prefix() {
        return this.li$cil$oc$Settings$$prefix;
    }

    public int basicScreenPixels() {
        return this.screenResolutionsByTier()[0]._1$mcI$sp() * this.screenResolutionsByTier()[0]._2$mcI$sp();
    }

    private Settings settings() {
        return this.settings;
    }

    private void settings_$eq(Settings x$1) {
        this.settings = x$1;
    }

    public Settings get() {
        return this.settings();
    }

    public void load(File file) {
        Config config;
        InputStream in = Settings.class.getResourceAsStream("/application.conf");
        String config2 = Source$.MODULE$.fromInputStream(in, Codec$.MODULE$.UTF8()).getLines().mkString("", Platform$.MODULE$.EOL(), Platform$.MODULE$.EOL());
        in.close();
        Config defaults = ConfigFactory.parseString((String)config2);
        try {
            String plain = Source$.MODULE$.fromFile(file, Codec$.MODULE$.UTF8()).getLines().mkString("", Platform$.MODULE$.EOL(), Platform$.MODULE$.EOL());
            Config config3 = this.patchConfig(ConfigFactory.parseString((String)plain), defaults).withFallback((ConfigMergeable)defaults);
            this.settings_$eq(new Settings(config3.getConfig("opencomputers")));
            config = config3;
        }
        catch (Throwable throwable) {
            if (file.exists()) {
                throw new RuntimeException(new StringBuilder().append((Object)"Error parsing configuration file. To restore defaults, delete '").append((Object)file.getName()).append((Object)"' and restart the game.").toString(), throwable);
            }
            this.settings_$eq(new Settings(defaults.getConfig("opencomputers")));
            config = defaults;
        }
        Config config4 = config;
        this.forbiddenConfigLists().foreach((Function1)new Serializable(config4){
            private final Config config$1;

            public final void apply(String key) {
                if (this.config$1.hasPath(new StringBuilder().append((Object)Settings$.MODULE$.li$cil$oc$Settings$$prefix()).append((Object)key).toString()) && !this.config$1.getStringList(new StringBuilder().append((Object)Settings$.MODULE$.li$cil$oc$Settings$$prefix()).append((Object)key).toString()).isEmpty()) {
                    throw new RuntimeException(new StringBuilder().append((Object)"Error parsing configuration file: removed configuration option '").append((Object)key).append((Object)"' is not empty. This option should no longer be used.").toString());
                }
            }
            {
                this.config$1 = config$1;
            }
        });
        try {
            ConfigRenderOptions renderSettings = ConfigRenderOptions.defaults().setJson(false).setOriginComments(false);
            String nl = (String)package$.MODULE$.props().apply((Object)"line.separator");
            String nle = StringEscapeUtils.escapeJava((String)nl);
            PrintWriter out = new PrintWriter(file);
            out.write(new StringOps(Predef$.MODULE$.augmentString(config4.root().render(renderSettings))).lines().map((Function1)new Serializable(){

                public final String apply(String line) {
                    return new StringOps(Predef$.MODULE$.augmentString("^(\\s*)")).r().replaceAllIn((CharSequence)line, (Function1)new Serializable(this){

                        public final String apply(Regex.Match m) {
                            return Regex$.MODULE$.quoteReplacement(m.group(1).replace("  ", " "));
                        }
                    });
                }
            }).filter((Function1)new Serializable(){

                public final boolean apply(String x$2) {
                    String string = x$2;
                    String string2 = "";
                    return string != null ? !string.equals(string2) : string2 != null;
                }
            }).mkString(nl).replaceAll(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"((?:\\\\s*#.*", ")(?:\\\\s*[^#\\\\s].*", ")+)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{nle, nle})), new StringBuilder().append((Object)"$1").append((Object)nl).toString()));
            out.close();
        }
        catch (Throwable throwable) {
            OpenComputers$.MODULE$.log().warn("Failed saving config.", throwable);
        }
    }

    private Tuple2<VersionRange, String[]>[] configPatches() {
        return this.configPatches;
    }

    private VersionRange fileringRulesPatchVersion() {
        return this.fileringRulesPatchVersion;
    }

    private Config patchConfig(Config config, Config defaults) {
        ModContainer mod = Loader.instance().activeModContainer();
        DefaultArtifactVersion configVersion = new DefaultArtifactVersion(config.hasPath(new StringBuilder().append((Object)this.li$cil$oc$Settings$$prefix()).append((Object)"version").toString()) ? config.getString(new StringBuilder().append((Object)this.li$cil$oc$Settings$$prefix()).append((Object)"version").toString()) : "0.0.0");
        ObjectRef patched = ObjectRef.create((Object)config);
        if (configVersion.compareTo(mod.getProcessedVersion()) != 0) {
            OpenComputers$.MODULE$.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updating config from version '", "' to '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{configVersion.getVersionString(), defaults.getString(new StringBuilder().append((Object)this.li$cil$oc$Settings$$prefix()).append((Object)"version").toString())})));
            patched.elem = ((Config)patched.elem).withValue(new StringBuilder().append((Object)this.li$cil$oc$Settings$$prefix()).append((Object)"version").toString(), defaults.getValue(new StringBuilder().append((Object)this.li$cil$oc$Settings$$prefix()).append((Object)"version").toString()));
            Predef$.MODULE$.refArrayOps((Object[])this.configPatches()).withFilter((Function1)new Serializable(){

                public final boolean apply(Tuple2<VersionRange, String[]> check$ifrefutable$1) {
                    Tuple2<VersionRange, String[]> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).withFilter((Function1)new Serializable(configVersion){
                private final DefaultArtifactVersion configVersion$1;

                public final boolean apply(Tuple2<VersionRange, String[]> x$3) {
                    Tuple2<VersionRange, String[]> tuple2 = x$3;
                    if (tuple2 != null) {
                        VersionRange version2 = (VersionRange)tuple2._1();
                        boolean bl = version2.containsVersion((ArtifactVersion)this.configVersion$1);
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.configVersion$1 = configVersion$1;
                }
            }).foreach((Function1)new Serializable(defaults, patched){
                public final Config defaults$1;
                public final ObjectRef patched$1;

                public final void apply(Tuple2<VersionRange, String[]> x$4) {
                    Tuple2<VersionRange, String[]> tuple2 = x$4;
                    if (tuple2 != null) {
                        String[] paths = (String[])tuple2._2();
                        Predef$.MODULE$.refArrayOps((Object[])paths).foreach((Function1)new Serializable(this){
                            private final /* synthetic */ anonfun.patchConfig.3 $outer;

                            public final void apply(String path) {
                                String fullPath = new StringBuilder().append((Object)Settings$.MODULE$.li$cil$oc$Settings$$prefix()).append((Object)path).toString();
                                OpenComputers$.MODULE$.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"=> Updating setting '", "'. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullPath})));
                                this.$outer.patched$1.elem = this.$outer.defaults$1.hasPath(fullPath) ? ((Config)this.$outer.patched$1.elem).withValue(fullPath, this.$outer.defaults$1.getValue(fullPath)) : ((Config)this.$outer.patched$1.elem).withoutPath(fullPath);
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.defaults$1 = defaults$1;
                    this.patched$1 = patched$1;
                }
            });
            if (this.fileringRulesPatchVersion().containsVersion((ArtifactVersion)configVersion)) {
                OpenComputers$.MODULE$.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"=> Migrating Internet Card filtering rules. "})).s((Seq)Nil$.MODULE$));
                Regex cidrPattern = new StringOps(Predef$.MODULE$.augmentString("(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})(?:/(\\d{1,2}))")).r();
                java.util.List httpHostWhitelist = ((Config)patched.elem).getStringList(new StringBuilder().append((Object)this.li$cil$oc$Settings$$prefix()).append((Object)"internet.whitelist").toString());
                java.util.List httpHostBlacklist = ((Config)patched.elem).getStringList(new StringBuilder().append((Object)this.li$cil$oc$Settings$$prefix()).append((Object)"internet.blacklist").toString());
                MutableList internetFilteringRules = (MutableList)MutableList$.MODULE$.apply((Seq)Nil$.MODULE$);
                WrapAsScala$.MODULE$.asScalaBuffer(httpHostBlacklist).foreach((Function1)new Serializable(cidrPattern, internetFilteringRules){
                    private final Regex cidrPattern$1;
                    private final MutableList internetFilteringRules$1;

                    public final MutableList<String> apply(String blockedAddress) {
                        return this.cidrPattern$1.findFirstIn((CharSequence)blockedAddress).isDefined() ? this.internetFilteringRules$1.$plus$eq((Object)new StringBuilder().append((Object)"deny ip:").append((Object)blockedAddress).toString()) : this.internetFilteringRules$1.$plus$eq((Object)new StringBuilder().append((Object)"deny domain:").append((Object)blockedAddress).toString());
                    }
                    {
                        this.cidrPattern$1 = cidrPattern$1;
                        this.internetFilteringRules$1 = internetFilteringRules$1;
                    }
                });
                WrapAsScala$.MODULE$.asScalaBuffer(httpHostWhitelist).foreach((Function1)new Serializable(cidrPattern, internetFilteringRules){
                    private final Regex cidrPattern$1;
                    private final MutableList internetFilteringRules$1;

                    public final MutableList<String> apply(String allowedAddress) {
                        return this.cidrPattern$1.findFirstIn((CharSequence)allowedAddress).isDefined() ? this.internetFilteringRules$1.$plus$eq((Object)new StringBuilder().append((Object)"allow ip:").append((Object)allowedAddress).toString()) : this.internetFilteringRules$1.$plus$eq((Object)new StringBuilder().append((Object)"allow domain:").append((Object)allowedAddress).toString());
                    }
                    {
                        this.cidrPattern$1 = cidrPattern$1;
                        this.internetFilteringRules$1 = internetFilteringRules$1;
                    }
                });
                Object object = httpHostWhitelist.isEmpty() ? BoxedUnit.UNIT : internetFilteringRules.$plus$eq((Object)"deny all");
                WrapAsScala$.MODULE$.asScalaBuffer(defaults.getStringList(new StringBuilder().append((Object)this.li$cil$oc$Settings$$prefix()).append((Object)"internet.filteringRules").toString())).foreach((Function1)new Serializable(internetFilteringRules){
                    private final MutableList internetFilteringRules$1;

                    public final MutableList<String> apply(String defaultRule) {
                        return this.internetFilteringRules$1.$plus$eq((Object)defaultRule);
                    }
                    {
                        this.internetFilteringRules$1 = internetFilteringRules$1;
                    }
                });
                ConfigList patchedRules = ConfigValueFactory.fromIterable((Iterable)((Iterable)JavaConverters$.MODULE$.mutableSeqAsJavaListConverter((scala.collection.mutable.Seq)internetFilteringRules).asJava()));
                try {
                    List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"internet.whitelist", "internet.blacklist"})).foreach((Function1)new Serializable(patched){
                        private final ObjectRef patched$1;

                        public final void apply(String key) {
                            if (((Config)this.patched$1.elem).hasPath(new StringBuilder().append((Object)Settings$.MODULE$.li$cil$oc$Settings$$prefix()).append((Object)key).toString())) {
                                ConfigValue originalValue = ((Config)this.patched$1.elem).getValue(new StringBuilder().append((Object)Settings$.MODULE$.li$cil$oc$Settings$$prefix()).append((Object)key).toString());
                                ConfigList deprecatedValue = ConfigValueFactory.fromIterable(new ArrayList<E>(), (String)originalValue.origin().description());
                                MutableList comments = (MutableList)MutableList$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No longer used! See internet.filteringRules.", "", "Previous contents:"}));
                                WrapAsScala$.MODULE$.asScalaBuffer(((Config)this.patched$1.elem).getStringList(new StringBuilder().append((Object)Settings$.MODULE$.li$cil$oc$Settings$$prefix()).append((Object)key).toString())).foreach((Function1)new Serializable(this, comments){
                                    private final MutableList comments$1;

                                    public final MutableList<String> apply(String value) {
                                        return this.comments$1.$plus$eq((Object)new StringBuilder().append((Object)"\"").append((Object)value).append((Object)"\"").toString());
                                    }
                                    {
                                        this.comments$1 = comments$1;
                                    }
                                });
                                deprecatedValue = OpenComputersConfigCommentManipulationHook.setComments((ConfigValue)deprecatedValue, (java.util.List)JavaConverters$.MODULE$.mutableSeqAsJavaListConverter((scala.collection.mutable.Seq)comments).asJava());
                                this.patched$1.elem = ((Config)this.patched$1.elem).withValue(new StringBuilder().append((Object)Settings$.MODULE$.li$cil$oc$Settings$$prefix()).append((Object)key).toString(), (ConfigValue)deprecatedValue);
                            }
                        }
                        {
                            this.patched$1 = patched$1;
                        }
                    });
                    patchedRules = OpenComputersConfigCommentManipulationHook.setComments((ConfigValue)patchedRules, defaults.getValue(new StringBuilder().append((Object)this.li$cil$oc$Settings$$prefix()).append((Object)"internet.filteringRules").toString()).origin().comments());
                }
                catch (Throwable throwable) {}
                patched.elem = ((Config)patched.elem).withValue(new StringBuilder().append((Object)this.li$cil$oc$Settings$$prefix()).append((Object)"internet.filteringRules").toString(), (ConfigValue)patchedRules);
            }
        }
        return (Config)patched.elem;
    }

    public java.util.List<Integer> getIntList(Config config, String path, Option<java.util.List<Integer>> option) {
        return config.hasPath(path) ? config.getIntList(path) : (java.util.List)option.getOrElse((Function0)new Serializable(){

            public final LinkedList<Integer> apply() {
                return new LinkedList<Integer>();
            }
        });
    }

    public Option<java.util.List<Integer>> getIntList$default$3() {
        return None$.MODULE$;
    }

    private Settings$() {
        MODULE$ = this;
        this.resourceDomain = "opencomputers";
        this.namespace = "oc:";
        this.savePath = "opencomputers/";
        this.scriptPath = new StringBuilder().append((Object)"/assets/").append((Object)this.resourceDomain()).append((Object)"/lua/").toString();
        this.screenResolutionsByTier = (Tuple2[])((Object[])new Tuple2[]{new Tuple2.mcII.sp(50, 16), new Tuple2.mcII.sp(80, 25), new Tuple2.mcII.sp(160, 50)});
        this.screenDepthsByTier = (TextBuffer.ColorDepth[])((Object[])new TextBuffer.ColorDepth[]{TextBuffer.ColorDepth.OneBit, TextBuffer.ColorDepth.FourBit, TextBuffer.ColorDepth.EightBit});
        this.deviceComplexityByTier = new int[]{12, 24, 32, 9001};
        this.rTreeDebugRenderer = false;
        this.blockRenderId = -1;
        this.forbiddenConfigLists = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"internet.blacklist", "internet.whitelist"}));
        this.li$cil$oc$Settings$$prefix = "opencomputers.";
        this.configPatches = (Tuple2[])((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)VersionRange.createFromVersionSpec((String)"[0.0, 1.4.7)")), (Object)new String[]{"misc.geolyzerNoise"}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)VersionRange.createFromVersionSpec((String)"[0.0, 1.4.8)")), (Object)new String[]{"power.value.AppliedEnergistics2", "power.value.Factorization", "power.value.Galacticraft", "power.value.IndustrialCraft2", "power.value.Mekanism", "power.value.RedstoneFlux"}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)VersionRange.createFromVersionSpec((String)"[0.0, 1.5.20)")), (Object)new String[]{"switch.relayDelayUpgrade"}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)VersionRange.createFromVersionSpec((String)"[0.0, 1.7.2)")), (Object)new String[]{"power.cost.wirelessCostPerRange", "misc.maxWirelessRange", "misc.maxOpenPorts", "computer.cpuComponentCount"}), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)VersionRange.createFromVersionSpec((String)"[0.0, 1.8.0)")), (Object)new String[]{"computer.robot.limitFlightHeight"})});
        this.fileringRulesPatchVersion = VersionRange.createFromVersionSpec((String)"[0.0, 1.8.3)");
    }
}

