/*
 * Decompiled with CFR 0.152.
 */
package net.coolsimulations.FloatingItems;

import cpw.mods.fml.client.config.IConfigElement;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Level;

public class FIConfig {
    static Configuration config;
    public static FIConfigItem[] blacklistItems;
    public static int[] blacklistRegistryItems;
    public static String[] blacklistOreDict;
    public static String serverLang;
    public static boolean disableUpdateCheck;

    public static void init(File file) {
        config = new Configuration(file);
        FIConfig.syncConfig(true);
    }

    public static void forceSave() {
        config.save();
    }

    public static void syncConfig(boolean load) {
        ArrayList<String> propOrder = new ArrayList<String>();
        try {
            if (!FIConfig.config.isChild && load) {
                config.load();
            }
            Property prop = config.get("util", "Blacklist of Items that should not Float", new String[0]);
            prop.comment = "Format: {Item ID}(Metadata). Example of Spruce Log: {17}(1)";
            ArrayList<FIConfigItem> blacklist = new ArrayList<FIConfigItem>();
            for (String entry : prop.getStringList()) {
                blacklist.add(new FIConfigItem(entry));
            }
            if (blacklist != null) {
                blacklistItems = blacklist.toArray(new FIConfigItem[0]);
            }
            propOrder.add(prop.getName());
            prop = config.get("util", "Blacklist of All Items regardless of Metadata that should not Float", new int[0]);
            prop.comment = "Format: Item ID. Example of Cobblestone: 4";
            blacklistRegistryItems = prop.getIntList();
            propOrder.add(prop.getName());
            prop = config.get("util", "Blacklist of OreDict Entries that should not Float", new String[0]);
            prop.comment = "Format: OreDict. Example of Copper Ingot: ingotCopper";
            blacklistOreDict = prop.getStringList();
            propOrder.add(prop.getName());
            prop = config.get("util", "Default Server language", "en_us");
            prop.comment = "Server language codes are based off the Minecraft .lang files. See https://minecraft.gamepedia.com/Language for list.";
            serverLang = prop.getString();
            propOrder.add(prop.getName());
            prop = config.get("util", "Disable FloatingItems Update Checker Message", false);
            disableUpdateCheck = prop.getBoolean(false);
            propOrder.add(prop.getName());
            if (config.hasChanged()) {
                config.save();
            }
        }
        catch (Exception e) {
            FMLRelaunchLog.log((String)"FloatingItems", (Level)Level.ERROR, (String)"Problem loading FloatingItems config (\"FloatingItems.conf\")", (Object[])new Object[0]);
            e.printStackTrace();
        }
    }

    public static List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        list.addAll(new ConfigElement(config.getCategory("util")).getChildElements());
        return list;
    }

    public static class FIConfigItem {
        private int registry;
        private int meta;
        private Item item;

        FIConfigItem(ItemStack stack) {
            this.item = stack.func_77973_b();
            this.meta = stack.func_77960_j();
            this.registry = Item.func_150891_b((Item)this.item);
        }

        FIConfigItem(String entry) {
            entry = entry.replaceAll(" ", "");
            this.meta = Integer.parseInt(StringUtils.substringBetween((String)entry, (String)"(", (String)")"));
            this.registry = Integer.parseInt(StringUtils.substringBetween((String)entry, (String)"{", (String)"}"));
            this.item = (Item)Item.field_150901_e.func_148754_a(this.registry);
        }

        public Item getItem() {
            return this.item;
        }

        public int getMeta() {
            return this.meta;
        }

        public ItemStack getStack() {
            return this.getStack(1);
        }

        public ItemStack getStack(int count) {
            return new ItemStack(this.item, count, this.meta);
        }

        public int getRegistry() {
            return this.registry;
        }

        public String toString() {
            return "{" + this.registry + "}(" + this.meta + ")";
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof FIConfigItem)) {
                return false;
            }
            FIConfigItem other = (FIConfigItem)obj;
            return this.registry == other.registry && this.meta == other.meta && this.item == other.item;
        }
    }
}

