/*
 * Decompiled with CFR 0.152.
 */
package neresources.config;

import cpw.mods.fml.client.config.IConfigElement;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import neresources.config.Settings;
import neresources.utils.TranslationHelper;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;

public class ConfigHandler {
    public static Configuration config;

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            ConfigHandler.loadConfig();
        }
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equalsIgnoreCase("neresources")) {
            ConfigHandler.loadConfig();
        }
    }

    private static void loadConfig() {
        Settings.ITEMS_PER_COLUMN = config.getInt(TranslationHelper.translateToLocal("ner.config.itemsPerColumn.title"), "general", 4, 1, 4, TranslationHelper.translateToLocal("ner.config.itemsPerColumn.description"));
        Settings.ITEMS_PER_ROW = config.getInt(TranslationHelper.translateToLocal("ner.config.itemsPerRow.title"), "general", 4, 1, 4, TranslationHelper.translateToLocal("ner.config.itemsPerRow.description"));
        Settings.CYCLE_TIME = config.getFloat(TranslationHelper.translateToLocal("ner.config.cycleTime.title"), "general", 1.5f, 0.5f, 3.0f, TranslationHelper.translateToLocal("ner.config.cycleTime.description"));
        Settings.EXTRA_RANGE = config.getInt(TranslationHelper.translateToLocal("ner.config.extraRange.title"), "general", 3, 0, 25, TranslationHelper.translateToLocal("ner.config.extraRange.description"));
        Settings.useDimNames = config.getBoolean(TranslationHelper.translateToLocal("ner.config.dimNames.title"), "general", true, TranslationHelper.translateToLocal("ner.config.dimNames.description"));
        Settings.excludedEnchants = config.getStringList(TranslationHelper.translateToLocal("ner.config.echantsBlacklist.title"), "general", new String[]{"flimflam"}, TranslationHelper.translateToLocal("ner.config.echantsBlacklist.description"));
        if (config.hasChanged()) {
            config.save();
        }
        Settings.reload();
    }

    public static List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        list.addAll(new ConfigElement(config.getCategory("general")).getChildElements());
        return list;
    }
}

