/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.block.transport;

import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import powercrystals.minefactoryreloaded.MineFactoryReloadedCore;
import powercrystals.minefactoryreloaded.block.transport.BlockFactoryRail;
import powercrystals.minefactoryreloaded.setup.MFRConfig;

public class BlockRailPassengerDropoff
extends BlockFactoryRail {
    public BlockRailPassengerDropoff() {
        super(true, false);
        this.func_149663_c("mfr.rail.passenger.dropoff");
    }

    @Override
    public void onMinecartPass(World world, EntityMinecart entityMinecart, int n, int n2, int n3) {
        Class clazz;
        if (world.field_72995_K) {
            return;
        }
        Class clazz2 = clazz = this.isPowered(world, n, n2, n3) ? EntityLiving.class : EntityPlayer.class;
        if (!clazz.isInstance(entityMinecart.field_70153_n)) {
            return;
        }
        Entity entity = entityMinecart.field_70153_n;
        AxisAlignedBB axisAlignedBB = this.findSpaceForPlayer(entity, n, n2, n3, world);
        if (axisAlignedBB == null) {
            return;
        }
        entity.func_70078_a(null);
        MineFactoryReloadedCore.proxy.movePlayerToCoordinates((EntityLivingBase)entity, axisAlignedBB.field_72340_a + (axisAlignedBB.field_72336_d - axisAlignedBB.field_72340_a) / 2.0, axisAlignedBB.field_72338_b, axisAlignedBB.field_72339_c + (axisAlignedBB.field_72334_f - axisAlignedBB.field_72339_c) / 2.0);
    }

    private AxisAlignedBB findSpaceForPlayer(Entity entity, int n, int n2, int n3, World world) {
        int n4 = MFRConfig.passengerRailSearchMaxHorizontal.getInt();
        int n5 = MFRConfig.passengerRailSearchMaxVertical.getInt() * 2;
        AxisAlignedBB axisAlignedBB = entity.field_70121_D.func_72325_c(0.0, 0.0, 0.0);
        double d = (axisAlignedBB.field_72336_d - axisAlignedBB.field_72340_a) / 2.0;
        double d2 = (axisAlignedBB.field_72334_f - axisAlignedBB.field_72339_c) / 2.0;
        axisAlignedBB.func_72317_d((double)n - axisAlignedBB.field_72340_a + 0.5 - d, (double)n2 - axisAlignedBB.field_72338_b + 0.05, (double)n3 - axisAlignedBB.field_72339_c + 0.5 - d2);
        AxisAlignedBB axisAlignedBB2 = axisAlignedBB.func_72329_c();
        axisAlignedBB.func_72317_d(0.0, (double)(-(n5 >> 1)), 0.0);
        for (int i = -n5; i <= n5; ++i) {
            axisAlignedBB.func_72317_d((double)(-n4), 0.0, 0.0);
            for (int j = -n4; j <= n4; ++j) {
                axisAlignedBB.func_72317_d(0.0, 0.0, (double)(-n4));
                for (int k = -n4; k <= n4; ++k) {
                    int n6;
                    int n7;
                    int n8;
                    if (world.func_147461_a(axisAlignedBB).isEmpty() && !this.isBadBlockToStandIn(world, axisAlignedBB) && !world.func_72953_d(axisAlignedBB) && !this.isBadBlockToStandOn(world, n8 = MathHelper.func_76128_c((double)(axisAlignedBB.field_72340_a + d)), (n7 = MathHelper.func_76128_c((double)axisAlignedBB.field_72338_b)) - 1, n6 = MathHelper.func_76128_c((double)(axisAlignedBB.field_72339_c + d2)))) {
                        return axisAlignedBB;
                    }
                    axisAlignedBB.func_72317_d(0.0, 0.0, 1.0);
                }
                axisAlignedBB.func_72317_d(1.0, 0.0, (double)(-n4 - 1));
            }
            axisAlignedBB.func_72317_d((double)(-n4 - 1), 0.5, 0.0);
        }
        return null;
    }

    private boolean isBadBlockToStandOn(World world, int n, int n2, int n3) {
        Block block = world.func_147439_a(n, n2, n3);
        return block.isAir((IBlockAccess)world, n, n2, n3) || null == block.func_149668_a(world, n, n2, n3);
    }

    private boolean isBadBlockToStandIn(World world, AxisAlignedBB axisAlignedBB) {
        int n = MathHelper.func_76128_c((double)axisAlignedBB.field_72340_a);
        int n2 = MathHelper.func_76128_c((double)(axisAlignedBB.field_72336_d + 1.0));
        int n3 = MathHelper.func_76128_c((double)axisAlignedBB.field_72338_b);
        int n4 = MathHelper.func_76128_c((double)(axisAlignedBB.field_72337_e + 1.0));
        int n5 = MathHelper.func_76128_c((double)axisAlignedBB.field_72339_c);
        int n6 = MathHelper.func_76128_c((double)(axisAlignedBB.field_72334_f + 1.0));
        if (axisAlignedBB.field_72340_a < 0.0) {
            --n;
        }
        if (axisAlignedBB.field_72338_b < 0.0) {
            --n3;
        }
        if (axisAlignedBB.field_72339_c < 0.0) {
            --n5;
        }
        for (int i = n; i < n2; ++i) {
            for (int j = n3; j < n4; ++j) {
                for (int k = n5; k < n6; ++k) {
                    Block block = world.func_147439_a(i, j, k);
                    if (block != Blocks.field_150480_ab && !block.func_149688_o().func_76224_d() && !block.isBurning((IBlockAccess)world, i, j, k) && !BlockRailBase.func_150051_a((Block)block)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

