/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.glasses.server;

import openperipheral.addons.glasses.drawable.Drawable;
import openperipheral.addons.glasses.utils.ColorPoint2d;
import openperipheral.addons.glasses.utils.Point2d;
import openperipheral.api.adapter.AdapterSourceName;
import openperipheral.api.adapter.Asynchronous;
import openperipheral.api.adapter.method.Alias;
import openperipheral.api.adapter.method.Arg;
import openperipheral.api.adapter.method.Optionals;
import openperipheral.api.adapter.method.ReturnType;
import openperipheral.api.adapter.method.ScriptCallable;

@Asynchronous
@AdapterSourceName(value="drawable_container")
public interface IDrawableFactory {
    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Add a new text object to the screen")
    public Drawable addText(@Arg(name="x", description="The x position from the top left") float var1, @Arg(name="y", description="The y position from the top left") float var2, @Arg(name="text", description="The text to display") String var3, @Optionals @Arg(name="color", description="The text color") Integer var4);

    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Add a new box to the screen")
    public Drawable addBox(@Arg(name="x", description="The x position from the top left") float var1, @Arg(name="y", description="The y position from the top left") float var2, @Arg(name="width", description="The width of the box") float var3, @Arg(name="height", description="The height of the box") float var4, @Optionals @Arg(name="color", description="The color of the box") Integer var5, @Arg(name="opacity", description="The opacity of the box (from 0 to 1)") Float var6);

    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Add a new gradient box to the screen")
    public Drawable addGradientBox(@Arg(name="x", description="The x position from the top left") float var1, @Arg(name="y", description="The y position from the top left") float var2, @Arg(name="width", description="The width of the box") float var3, @Arg(name="height", description="The height of the box") float var4, @Arg(name="color", description="The color of the box") int var5, @Arg(name="opacity", description="The opacity of the box (from 0 to 1)") float var6, @Arg(name="color2", description="The color of the other side of the box") int var7, @Arg(name="opacity2", description="The opacity of the other side of the box (from 0 to 1)") float var8, @Arg(name="gradient", description="The gradient direction (1 for horizontal, 2 for vertical)") int var9);

    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Add an icon of an item to the screen")
    public Drawable addIcon(@Arg(name="x", description="The x position from the top left") float var1, @Arg(name="y", description="The y position from the top left") float var2, @Arg(name="id", description="The id of the item to draw") String var3, @Optionals @Arg(name="meta", description="The meta of the item to draw") Short var4);

    @Alias(value={"addFluid"})
    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Add a box textured like a liquid to the screen")
    public Drawable addLiquid(@Arg(name="x", description="The x position from the top left") float var1, @Arg(name="y", description="The y position from the top left") float var2, @Arg(name="width", description="The width of the liquid box") float var3, @Arg(name="height", description="The height of the liquid box") float var4, @Arg(name="liquid", description="The name of the fluid to render") String var5);

    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Add a triangle")
    public Drawable addTriangle(@Arg(name="p1", description="Coordinates of first point") Point2d var1, @Arg(name="p2", description="Coordinates of second point") Point2d var2, @Arg(name="p3", description="Coordinates of third point") Point2d var3, @Optionals @Arg(name="color", description="The color of the line") Integer var4, @Arg(name="opacity", description="The opacity of the line (from 0 to 1)") Float var5);

    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Add a triangle")
    public Drawable addGradientTriangle(@Arg(name="p1", description="Coordinates of first point") ColorPoint2d var1, @Arg(name="p2", description="Coordinates of second point") ColorPoint2d var2, @Arg(name="p3", description="Coordinates of third point") ColorPoint2d var3);

    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Add a quad")
    public Drawable addQuad(@Arg(name="p1", description="Coordinates of first point") Point2d var1, @Arg(name="p2", description="Coordinates of second point") Point2d var2, @Arg(name="p3", description="Coordinates of third point") Point2d var3, @Arg(name="p4", description="Coordinates of fourth point") Point2d var4, @Optionals @Arg(name="color", description="The color of the line") Integer var5, @Arg(name="opacity", description="The opacity of the line (from 0 to 1)") Float var6);

    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Add a gradient quad")
    public Drawable addGradientQuad(@Arg(name="p1", description="Coordinates of first point") ColorPoint2d var1, @Arg(name="p2", description="Coordinates of second point") ColorPoint2d var2, @Arg(name="p3", description="Coordinates of third point") ColorPoint2d var3, @Arg(name="p4", description="Coordinates of fourth point") ColorPoint2d var4);

    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Add a line")
    public Drawable addLine(@Arg(name="p1", description="Coordinates of first point") Point2d var1, @Arg(name="p2", description="Coordinate of second point") Point2d var2, @Optionals @Arg(name="color", description="The color of the line") Integer var3, @Arg(name="opacity", description="The opacity of the line (from 0 to 1)") Float var4);

    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Add a gradient line")
    public Drawable addGradientLine(@Arg(name="p1", description="Coordinates of first point") ColorPoint2d var1, @Arg(name="p2", description="Coordinate of second point") ColorPoint2d var2);

    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Add a line strip")
    public Drawable addLineList(@Optionals @Arg(name="color", description="The color of the line") Integer var1, @Arg(name="opacity", description="The opacity of the line (from 0 to 1)") Float var2, Point2d ... var3);

    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Add a gradient line strip")
    public Drawable addGradientLineList(ColorPoint2d ... var1);

    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Add a concave polygon")
    public Drawable addPolygon(@Optionals @Arg(name="color", description="The color of the line") Integer var1, @Arg(name="opacity", description="The opacity of the line (from 0 to 1)") Float var2, Point2d ... var3);

    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Add a gradient concave polygon")
    public Drawable addGradientPolygon(ColorPoint2d ... var1);

    @ScriptCallable(returnTypes={ReturnType.OBJECT}, description="Add a point")
    public Drawable addPoint(@Arg(name="coord", description="Coordinates of point") Point2d var1, @Optionals @Arg(name="color", description="The color of the point") Integer var2, @Arg(name="opacity", description="The opacity of the point (from 0 to 1)") Float var3);
}

