/*
 * Decompiled with CFR 0.152.
 */
package openperipheral.addons.pim;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import openmods.renderer.IBlockRenderer;
import openmods.utils.render.RenderUtils;
import openperipheral.addons.pim.BlockPIM;
import openperipheral.addons.pim.TileEntityPIM;

public class BlockPIMRenderer
implements IBlockRenderer<BlockPIM> {
    private static boolean hasPlayer(IBlockAccess world, int x, int y, int z) {
        TileEntity pim = world.func_147438_o(x, y, z);
        return pim instanceof TileEntityPIM && ((TileEntityPIM)pim).hasPlayer();
    }

    private static void setTopPartBounds(RenderBlocks renderer, boolean hasPlayer) {
        renderer.func_147782_a(0.0625, 0.3, 0.0625, 0.9375, hasPlayer ? 0.32 : 0.4, 0.9375);
    }

    public void renderInventoryBlock(BlockPIM block, int metadata, int modelID, RenderBlocks renderer) {
        RenderUtils.renderInventoryBlock((RenderBlocks)renderer, (Block)block, (int)0);
        renderer.func_147757_a(BlockPIM.Icons.black);
        BlockPIMRenderer.setTopPartBounds(renderer, false);
        RenderUtils.renderInventoryBlockNoBounds((RenderBlocks)renderer, (Block)block, (int)0);
        renderer.func_147771_a();
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, BlockPIM block, int modelId, RenderBlocks renderer) {
        renderer.func_147775_a((Block)block);
        renderer.func_147784_q((Block)block, x, y, z);
        boolean isBreaking = renderer.func_147744_b();
        if (!isBreaking) {
            renderer.func_147757_a(BlockPIM.Icons.black);
        }
        boolean hasPlayer = BlockPIMRenderer.hasPlayer(world, x, y, z);
        BlockPIMRenderer.setTopPartBounds(renderer, hasPlayer);
        renderer.func_147784_q((Block)block, x, y, z);
        if (!isBreaking) {
            renderer.func_147771_a();
        }
        return true;
    }
}

