/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.integration.MineTweaker;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IItemStack;
import minetweaker.api.minecraft.MineTweakerMC;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.customRecipes.RecipeShapelessHidden;
import moze_intel.projecte.utils.MetaBlock;
import moze_intel.projecte.utils.WorldTransmutations;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.projecte.PhiloStone")
public class PhiloStone {
    @ZenMethod
    public static void addPhiloSmelting(IItemStack output, IItemStack input) {
        MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(output, input));
    }

    @ZenMethod
    public static void addPhiloSmelting(IItemStack output, IItemStack input, IItemStack fuel) {
        MineTweakerAPI.apply((IUndoableAction)new AddRecipeAction(output, input, fuel));
    }

    @ZenMethod
    public static void removePhiloSmelting(IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new RemoveRecipeAction(output));
    }

    @ZenMethod
    public static void addWorldTransmutation(IItemStack output, IItemStack input) {
        MineTweakerAPI.apply((IUndoableAction)new AddWorldTransmutationAction(output, input));
    }

    @ZenMethod
    public static void addWorldTransmutation(IItemStack output, IItemStack sneakOutput, IItemStack input) {
        MineTweakerAPI.apply((IUndoableAction)new AddWorldTransmutationAction(output, sneakOutput, input));
    }

    @ZenMethod
    public static void removeWorldTransmutation(IItemStack output, IItemStack input) {
        MineTweakerAPI.apply((IUndoableAction)new RemoveWorldTransmutationAction(output, input));
    }

    @ZenMethod
    public static void removeWorldTransmutation(IItemStack output, IItemStack sneakOutput, IItemStack input) {
        MineTweakerAPI.apply((IUndoableAction)new RemoveWorldTransmutationAction(output, sneakOutput, input));
    }

    private static class RemoveWorldTransmutationAction
    implements IUndoableAction {
        private final MetaBlock output;
        private final MetaBlock sneakOutput;
        private final MetaBlock input;

        public RemoveWorldTransmutationAction(IItemStack output, IItemStack input) {
            this.output = new MetaBlock(MineTweakerMC.getBlock((IItemStack)output));
            this.sneakOutput = null;
            this.input = new MetaBlock(MineTweakerMC.getBlock((IItemStack)input));
        }

        public RemoveWorldTransmutationAction(IItemStack output, IItemStack sneakOutput, IItemStack input) {
            this.output = new MetaBlock(MineTweakerMC.getBlock((IItemStack)output));
            this.sneakOutput = new MetaBlock(MineTweakerMC.getBlock((IItemStack)sneakOutput));
            this.input = new MetaBlock(MineTweakerMC.getBlock((IItemStack)input));
        }

        public void apply() {
            Iterator<Map.Entry<MetaBlock, MetaBlock[]>> it = WorldTransmutations.MAP.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<MetaBlock, MetaBlock[]> entry = it.next();
                if (!entry.getKey().equals(this.input) || !entry.getValue()[0].equals(this.output) || entry.getValue().length > 1 && !entry.getValue()[1].equals(this.sneakOutput)) continue;
                it.remove();
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            WorldTransmutations.register(this.input, this.output, this.sneakOutput);
        }

        public String describe() {
            return "Removing world transmutation recipe for " + this.output;
        }

        public String describeUndo() {
            return "Un-removing world transmutation recipe for " + this.output;
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddWorldTransmutationAction
    implements IUndoableAction {
        private final MetaBlock output;
        private final MetaBlock sneakOutput;
        private final MetaBlock input;

        public AddWorldTransmutationAction(IItemStack output, IItemStack input) {
            this.output = new MetaBlock(MineTweakerMC.getBlock((IItemStack)output));
            this.sneakOutput = null;
            this.input = new MetaBlock(MineTweakerMC.getBlock((IItemStack)input));
        }

        public AddWorldTransmutationAction(IItemStack output, IItemStack sneakOutput, IItemStack input) {
            this.output = new MetaBlock(MineTweakerMC.getBlock((IItemStack)output));
            this.sneakOutput = new MetaBlock(MineTweakerMC.getBlock((IItemStack)sneakOutput));
            this.input = new MetaBlock(MineTweakerMC.getBlock((IItemStack)input));
        }

        public void apply() {
            WorldTransmutations.register(this.input, this.output, this.sneakOutput);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            Iterator<Map.Entry<MetaBlock, MetaBlock[]>> it = WorldTransmutations.MAP.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<MetaBlock, MetaBlock[]> entry = it.next();
                if (!entry.getKey().equals(this.input) || !entry.getValue()[0].equals(this.output) || entry.getValue().length > 1 && !entry.getValue()[1].equals(this.sneakOutput)) continue;
                it.remove();
            }
        }

        public String describe() {
            return "Adding world transmutation recipe for " + this.output;
        }

        public String describeUndo() {
            return "Removing world transmutation recipe for " + this.output;
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class RemoveRecipeAction
    implements IUndoableAction {
        IRecipe recipe = null;
        ItemStack remove;

        public RemoveRecipeAction(IItemStack rem) {
            this.remove = MineTweakerMC.getItemStack((IItemStack)rem);
            List allrecipes = CraftingManager.func_77594_a().func_77592_b();
            for (IRecipe irecipe : allrecipes) {
                if (!(irecipe instanceof RecipeShapelessHidden) || !this.remove.func_77969_a(irecipe.func_77571_b())) continue;
                this.recipe = irecipe;
            }
        }

        public void apply() {
            CraftingManager.func_77594_a().func_77592_b().remove(this.recipe);
        }

        public boolean canUndo() {
            return this.recipe != null;
        }

        public void undo() {
            CraftingManager.func_77594_a().func_77592_b().add(this.recipe);
        }

        public String describe() {
            return "Removing Philosopher's Stone Smelting Recipe for " + this.recipe.func_77571_b().func_82833_r();
        }

        public String describeUndo() {
            return "Un-removing Philosopher's Stone Smelting Recipe for " + this.recipe.func_77571_b().func_82833_r();
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddRecipeAction
    implements IUndoableAction {
        private final ItemStack output;
        private final ItemStack input;
        private final ItemStack fuel;
        IRecipe recipe;

        public AddRecipeAction(IItemStack output, IItemStack input) {
            this.output = MineTweakerMC.getItemStack((IItemStack)output);
            this.input = MineTweakerMC.getItemStack((IItemStack)input);
            this.fuel = new ItemStack(Items.field_151044_h, 1, Short.MAX_VALUE);
            this.recipe = new RecipeShapelessHidden(this.output, new ItemStack(ObjHandler.philosStone), this.input, this.input, this.input, this.input, this.input, this.input, this.input, this.fuel);
        }

        public AddRecipeAction(IItemStack output, IItemStack input, IItemStack fuel) {
            this.output = MineTweakerMC.getItemStack((IItemStack)output);
            this.input = MineTweakerMC.getItemStack((IItemStack)input);
            this.fuel = MineTweakerMC.getItemStack((IItemStack)fuel);
            this.recipe = new RecipeShapelessHidden(this.output, new ItemStack(ObjHandler.philosStone), this.input, this.input, this.input, this.input, this.input, this.input, this.input, this.fuel);
        }

        public void apply() {
            GameRegistry.addRecipe((IRecipe)this.recipe);
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            CraftingManager.func_77594_a().func_77592_b().remove(this.recipe);
        }

        public String describe() {
            return "Adding Philosopher's Stone Smelting recipe for " + this.output;
        }

        public String describeUndo() {
            return "Removing Philosopher's Stone Smelting recipe for " + this.output;
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

