/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.config;

import com.falsepattern.lib.config.ConfigException;
import com.falsepattern.lib.internal.ReflectionUtil;
import com.falsepattern.lib.internal.impl.config.ConfigurationManagerImpl;
import cpw.mods.fml.client.config.IConfigElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import lombok.Generated;

public class ConfigurationManager {
    public static void initialize(Class<?> ... configClasses) throws ConfigException {
        ConfigurationManager.initialize((Class<?> a, Field b) -> {}, configClasses);
    }

    public static void selfInit() {
        ConfigurationManager.initialize(ReflectionUtil.getCallerClass());
    }

    public static void initialize(BiConsumer<Class<?>, Field> validatorErrorCallback, Class<?> ... configClasses) throws ConfigException {
        for (Class<?> clazz : configClasses) {
            ConfigurationManagerImpl.register(clazz);
            ConfigurationManagerImpl.load(clazz);
            ConfigurationManagerImpl.validateFields(validatorErrorCallback, clazz, true);
            ConfigurationManagerImpl.save(clazz);
        }
    }

    public static boolean validate(boolean resetInvalid, Class<?> ... configClasses) throws ConfigException {
        return ConfigurationManager.validate((x, y) -> {}, resetInvalid, configClasses);
    }

    public static boolean validate(BiConsumer<Class<?>, Field> validatorErrorCallback, boolean resetInvalid, Class<?> ... configClasses) throws ConfigException {
        boolean valid = true;
        for (Class<?> clazz : configClasses) {
            valid &= ConfigurationManagerImpl.validateFields(validatorErrorCallback, clazz, resetInvalid);
        }
        return valid;
    }

    public static void loadFromFile(Class<?> ... configClasses) throws ConfigException {
        for (Class<?> clazz : configClasses) {
            ConfigurationManagerImpl.load(clazz);
        }
    }

    public static void saveToFile(boolean validateAndResetInvalid, Class<?> ... configClasses) throws ConfigException {
        for (Class<?> clazz : configClasses) {
            if (validateAndResetInvalid) {
                ConfigurationManagerImpl.validateFields((a, b) -> {}, clazz, true);
            }
            ConfigurationManagerImpl.save(clazz);
        }
    }

    public static List<IConfigElement> getConfigElements(Class<?> configClass) throws ConfigException {
        return ConfigurationManagerImpl.getConfigElements(configClass);
    }

    public static List<IConfigElement> getConfigElementsMulti(Class<?> ... configClasses) throws ConfigException {
        switch (configClasses.length) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return ConfigurationManager.getConfigElements(configClasses[0]);
            }
        }
        ArrayList<IConfigElement> result = new ArrayList<IConfigElement>();
        for (Class<?> configClass : configClasses) {
            result.addAll(ConfigurationManager.getConfigElements(configClass));
        }
        return result;
    }

    public static List<IConfigElement> getConfigElementsMultiStructured(Class<?> ... configClasses) throws ConfigException {
        if (configClasses.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<IConfigElement> result = new ArrayList<IConfigElement>();
        for (Class<?> configClass : configClasses) {
            result.add((IConfigElement)ConfigurationManagerImpl.getConfigCategoryElement(configClass));
        }
        return result;
    }

    @Generated
    private ConfigurationManager() {
    }
}

