/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.asm.transformers;

import com.falsepattern.lib.turboasm.ClassHeaderMetadata;
import com.falsepattern.lib.turboasm.ClassNodeHandle;
import com.falsepattern.lib.turboasm.TurboClassTransformer;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;

public class MixinPluginTransformer
implements TurboClassTransformer {
    private static final String IMIXINPLUGIN = "com.falsepattern.lib.mixin.IMixinPlugin";
    private static final String IMIXINPLUGIN_INTERNAL = "com.falsepattern.lib.mixin.IMixinPlugin".replace('.', '/');
    private static final String IMIXINCONFIGPLUGIN = "org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin";
    private static final String IMIXINCONFIGPLUGIN_INTERNAL = "org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin".replace('.', '/');
    private static final Map<Class<?>, String> primitiveDescriptors = new HashMap();
    private static String PREAPPLY_DESC = null;
    private static String POSTAPPLY_DESC = null;
    private static String CLASSNODE_REAL = null;

    @Override
    public String owner() {
        return "FalsePatternLib";
    }

    @Override
    public String name() {
        return "MixinPluginTransformer";
    }

    @Override
    public boolean shouldTransformClass(@NotNull String className, @NotNull ClassNodeHandle classNode) {
        ClassHeaderMetadata meta;
        if (IMIXINPLUGIN.equals(className) || IMIXINCONFIGPLUGIN.equals(className)) {
            return true;
        }
        if (!classNode.isPresent()) {
            return false;
        }
        if (classNode.isOriginal() && (meta = classNode.getOriginalMetadata()) != null && meta.interfacesCount == 0) {
            return false;
        }
        ClassNode cn = classNode.getNode();
        if (cn == null) {
            return false;
        }
        for (String i : cn.interfaces) {
            if (!IMIXINPLUGIN_INTERNAL.equals(i) && !IMIXINCONFIGPLUGIN_INTERNAL.equals(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean transformClass(@NotNull String className, @NotNull ClassNodeHandle classNode) {
        ClassNode cn = classNode.getNode();
        if (cn == null) {
            return false;
        }
        if (IMIXINCONFIGPLUGIN.equals(className)) {
            return MixinPluginTransformer.extractMixinConfigPluginData(cn);
        }
        return MixinPluginTransformer.transformPlugin(cn);
    }

    private static boolean extractMixinConfigPluginData(ClassNode cn) {
        boolean changed = false;
        block8: for (MethodNode method : cn.methods) {
            switch (method.name) {
                case "preApply": {
                    PREAPPLY_DESC = method.desc;
                    break;
                }
                case "postApply": {
                    POSTAPPLY_DESC = method.desc;
                    break;
                }
                default: {
                    continue block8;
                }
            }
            if (CLASSNODE_REAL == null) continue;
            for (LocalVariableNode local : method.localVariables) {
                if (!local.desc.contains("ClassNode;")) continue;
                local.desc = local.desc.replaceAll("L[a-zA-Z/$]+[a-zA-Z$]+/ClassNode;", CLASSNODE_REAL);
                changed = true;
            }
        }
        return changed;
    }

    private static boolean transformPlugin(ClassNode cn) {
        if (PREAPPLY_DESC == null) {
            PREAPPLY_DESC = MixinPluginTransformer.extractMethodWithReflection("preApply");
        }
        if (POSTAPPLY_DESC == null) {
            POSTAPPLY_DESC = MixinPluginTransformer.extractMethodWithReflection("postApply");
        }
        boolean changed = false;
        for (MethodNode method : cn.methods) {
            switch (method.name) {
                case "preApply": {
                    if (PREAPPLY_DESC.equals(method.desc)) break;
                    method.desc = PREAPPLY_DESC;
                    changed = true;
                    break;
                }
                case "postApply": {
                    if (POSTAPPLY_DESC.equals(method.desc)) break;
                    method.desc = POSTAPPLY_DESC;
                    changed = true;
                }
            }
        }
        return changed;
    }

    private static String extractMethodWithReflection(String m) {
        for (Method method : IMixinConfigPlugin.class.getDeclaredMethods()) {
            if (!method.getName().equals(m)) continue;
            StringBuilder b = new StringBuilder("(");
            for (Class<?> param : method.getParameterTypes()) {
                if (param.getName().contains("ClassNode")) {
                    CLASSNODE_REAL = "L" + param.getName().replace('.', '/') + ";";
                }
                b.append(MixinPluginTransformer.classToRaw(param));
            }
            b.append(")").append(MixinPluginTransformer.classToRaw(method.getReturnType()));
            return b.toString();
        }
        throw new RuntimeException("Could not extract " + m + " from IMixinConfigPlugin!");
    }

    private static String classToRaw(Class<?> clazz) {
        if (primitiveDescriptors.containsKey(clazz)) {
            return primitiveDescriptors.get(clazz);
        }
        return "L" + clazz.getName().replace('.', '/') + ";";
    }

    static {
        primitiveDescriptors.put(Void.TYPE, "V");
        primitiveDescriptors.put(Boolean.TYPE, "Z");
        primitiveDescriptors.put(Byte.TYPE, "B");
        primitiveDescriptors.put(Short.TYPE, "S");
        primitiveDescriptors.put(Integer.TYPE, "I");
        primitiveDescriptors.put(Long.TYPE, "J");
        primitiveDescriptors.put(Float.TYPE, "F");
        primitiveDescriptors.put(Double.TYPE, "D");
        primitiveDescriptors.put(Character.TYPE, "C");
    }
}

