/*
 * Decompiled with CFR 0.152.
 */
package com.falsepattern.lib.internal.impl.config.fields;

import com.falsepattern.lib.config.Config;
import com.falsepattern.lib.config.event.ConfigValidationFailureEvent;
import com.falsepattern.lib.internal.impl.config.ConfigFieldParameters;
import com.falsepattern.lib.internal.impl.config.fields.AConfigField;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Optional;
import net.minecraftforge.common.config.Property;

public class BooleanConfigField
extends AConfigField<Boolean> {
    private final boolean primitive;
    private final boolean defaultValue;

    public BooleanConfigField(ConfigFieldParameters params) {
        super(params, Property.Type.BOOLEAN);
        this.primitive = this.field.getType().isPrimitive();
        this.defaultValue = Optional.ofNullable(this.field.getAnnotation(Config.DefaultBoolean.class)).map(Config.DefaultBoolean::value).orElseThrow(() -> BooleanConfigField.noDefault(this.field, "DefaultBoolean"));
        Property property = this.getProperty();
        property.setDefaultValue(this.defaultValue);
        if (!property.isBooleanValue()) {
            this.setToDefault();
        }
        property.comment = property.comment + "\n[default: " + this.defaultValue + "]";
    }

    @Override
    protected Boolean getField() {
        return this.primitive ? this.field.getBoolean(null) : ((Boolean)this.field.get(null)).booleanValue();
    }

    @Override
    protected void putField(Boolean value) {
        if (this.primitive) {
            this.field.setBoolean(null, value);
        } else {
            this.field.set(null, value);
        }
    }

    @Override
    protected Boolean getConfig() {
        return this.getProperty().getBoolean();
    }

    @Override
    protected void putConfig(Boolean value) {
        this.getProperty().set(value.booleanValue());
    }

    @Override
    protected Boolean getDefault() {
        return this.defaultValue;
    }

    @Override
    public boolean validateField() {
        if (!this.primitive && this.field.get(null) == null) {
            ConfigValidationFailureEvent.fieldIsNull(this.field, -1);
            return false;
        }
        return true;
    }

    @Override
    public void transmit(DataOutput output) throws IOException {
        output.writeBoolean(this.getField());
    }

    @Override
    public void receive(DataInput input) throws IOException {
        this.putField(input.readBoolean());
    }
}

